/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.federation.FederatedRepositoryConnection;
import org.jboss.dna.connector.federation.FederatedWorkspace;
import org.jboss.dna.connector.federation.FederatingRequestProcessor;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FederatedRepository {
    private final String name;
    private final ExecutionContext context;
    private final RepositoryConnectionFactory connectionFactory;
    private final Map<String, FederatedWorkspace> workspaceConfigsByName;
    private final FederatedWorkspace defaultWorkspace;
    private final AtomicInteger openExecutors = new AtomicInteger(0);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);

    public FederatedRepository(String repositoryName, ExecutionContext context, RepositoryConnectionFactory connectionFactory, Iterable<FederatedWorkspace> workspaces) {
        CheckArg.isNotEmpty((String)repositoryName, (String)"repositoryName");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull(workspaces, (String)"workspaces");
        this.name = repositoryName;
        this.context = context;
        this.connectionFactory = connectionFactory;
        FederatedWorkspace defaultWorkspace = null;
        HashMap<String, FederatedWorkspace> configsByName = new HashMap<String, FederatedWorkspace>();
        for (FederatedWorkspace workspace : workspaces) {
            if (defaultWorkspace == null) {
                defaultWorkspace = workspace;
            }
            configsByName.put(workspace.getName(), workspace);
        }
        this.workspaceConfigsByName = Collections.unmodifiableMap(configsByName);
        this.defaultWorkspace = defaultWorkspace;
    }

    public String getName() {
        return this.name;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    protected RepositoryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public synchronized void start() {
    }

    public boolean isRunning() {
        return !this.shutdownRequested.get();
    }

    public synchronized void shutdown() {
        this.shutdownRequested.set(true);
        if (this.openExecutors.get() <= 0) {
            this.shutdownLatch.countDown();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }

    public boolean isTerminated() {
        return this.openExecutors.get() != 0;
    }

    public RepositoryConnection createConnection(RepositorySource source, String username, Object credentials) {
        return new FederatedRepositoryConnection(this, source.getName());
    }

    public Map<String, FederatedWorkspace> getWorkspaceConfigurations() {
        return this.workspaceConfigsByName;
    }

    protected RequestProcessor getProcessor(ExecutionContext context, String sourceName) {
        Map<String, FederatedWorkspace> workspaces = this.getWorkspaceConfigurations();
        return new FederatingRequestProcessor(context, sourceName, workspaces, this.defaultWorkspace, this.getConnectionFactory());
    }

    void register(FederatedRepositoryConnection connection) {
        this.openExecutors.incrementAndGet();
    }

    void unregister(FederatedRepositoryConnection connection) {
        if (this.openExecutors.decrementAndGet() <= 0 && this.shutdownRequested.get()) {
            this.shutdownLatch.countDown();
        }
    }
}

