/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.FederatedRepository;
import org.jboss.dna.connector.federation.FederationI18n;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.processor.RequestProcessor;

@ThreadSafe
public class FederatedRepositoryConnection
implements RepositoryConnection {
    private final FederatedRepository repository;
    private final String sourceName;

    protected FederatedRepositoryConnection(FederatedRepository repository, String sourceName) {
        assert (sourceName != null);
        assert (repository != null);
        this.sourceName = sourceName;
        this.repository = repository;
        this.repository.register(this);
    }

    protected FederatedRepository getRepository() {
        return this.repository;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CachePolicy getDefaultCachePolicy() {
        return null;
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return this.repository.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        if (!this.repository.isRunning()) {
            throw new RepositorySourceException(FederationI18n.repositoryHasBeenShutDown.text(new Object[]{this.repository.getName()}));
        }
        if (request == null) {
            return;
        }
        RequestProcessor processor = this.repository.getProcessor(context, this.sourceName);
        assert (processor != null);
        try {
            processor.process(request);
        }
        finally {
            processor.close();
        }
    }

    public void close() {
    }
}

