/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.contribution.NonEmptyContribution;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MultiChildContribution
extends NonEmptyContribution {
    private static final long serialVersionUID = 1L;
    private List<Location> children;

    public MultiChildContribution(String sourceName, String workspaceName, Location locationInSource, DateTime expirationTime, Iterable<Location> children) {
        super(sourceName, workspaceName, locationInSource, expirationTime);
        assert (children != null);
        this.children = new LinkedList<Location>();
        for (Location child : children) {
            if (child == null) continue;
            this.children.add(child);
        }
        assert (!this.children.isEmpty());
    }

    @Override
    public Iterator<Location> getChildren() {
        return new Contribution.ImmutableIterator<Location>(this.children.iterator());
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }
}

