/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.contribution.NonEmptyContribution;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class TwoPropertyContribution
extends NonEmptyContribution {
    private static final long serialVersionUID = 1L;
    private final Property property1;
    private final Property property2;

    public TwoPropertyContribution(String sourceName, String workspaceName, Location locationInSource, DateTime expirationTime, Property property1, Property property2) {
        super(sourceName, workspaceName, locationInSource, expirationTime);
        assert (property1 != null);
        assert (!property1.isEmpty());
        assert (property2 != null);
        assert (!property2.isEmpty());
        this.property1 = property1;
        this.property2 = property2;
    }

    @Override
    public Iterator<Property> getProperties() {
        return new Contribution.TwoValueIterator<Property>(this.property1, this.property2);
    }

    @Override
    public int getPropertyCount() {
        return 2;
    }

    @Override
    public Property getProperty(Name name) {
        if (this.property1.getName().equals(name)) {
            return this.property1;
        }
        if (this.property2.getName().equals(name)) {
            return this.property2;
        }
        return null;
    }
}

