/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.MergePlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FourContributionMergePlan
extends MergePlan {
    private static final long serialVersionUID = 1L;
    private final Contribution contribution1;
    private final Contribution contribution2;
    private final Contribution contribution3;
    private final Contribution contribution4;

    FourContributionMergePlan(Contribution contribution1, Contribution contribution2, Contribution contribution3, Contribution contribution4) {
        assert (contribution1 != null);
        assert (contribution2 != null);
        assert (contribution3 != null);
        assert (contribution4 != null);
        this.contribution1 = contribution1;
        this.contribution2 = contribution2;
        this.contribution3 = contribution3;
        this.contribution4 = contribution4;
        assert (this.checkEachContributionIsFromDistinctSource());
    }

    @Override
    public int getContributionCount() {
        return 4;
    }

    @Override
    public Contribution getContributionFrom(String sourceName) {
        if (this.contribution1.getSourceName().equals(sourceName)) {
            return this.contribution1;
        }
        if (this.contribution2.getSourceName().equals(sourceName)) {
            return this.contribution2;
        }
        if (this.contribution3.getSourceName().equals(sourceName)) {
            return this.contribution3;
        }
        if (this.contribution4.getSourceName().equals(sourceName)) {
            return this.contribution4;
        }
        return null;
    }

    @Override
    public Iterator<Contribution> iterator() {
        return new Iterator<Contribution>(){
            private int next = 4;

            @Override
            public boolean hasNext() {
                return this.next > 0;
            }

            @Override
            public Contribution next() {
                if (this.next == 4) {
                    this.next = 3;
                    return FourContributionMergePlan.this.contribution1;
                }
                if (this.next == 3) {
                    this.next = 2;
                    return FourContributionMergePlan.this.contribution2;
                }
                if (this.next == 2) {
                    this.next = 1;
                    return FourContributionMergePlan.this.contribution3;
                }
                if (this.next == 1) {
                    this.next = 0;
                    return FourContributionMergePlan.this.contribution4;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSource(String sourceName) {
        if (this.contribution1.getSourceName().equals(sourceName)) {
            return true;
        }
        if (this.contribution2.getSourceName().equals(sourceName)) {
            return true;
        }
        if (this.contribution3.getSourceName().equals(sourceName)) {
            return true;
        }
        return this.contribution4.getSourceName().equals(sourceName);
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.contribution1, this.contribution2, this.contribution3, this.contribution4});
    }
}

