/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.infinispan;

import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.Cache;
import org.infinispan.manager.CacheManager;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.LockFailedException;
import org.jboss.dna.graph.connector.map.AbstractMapWorkspace;
import org.jboss.dna.graph.connector.map.LockBasedTransaction;
import org.jboss.dna.graph.connector.map.MapNode;
import org.jboss.dna.graph.connector.map.MapRepository;
import org.jboss.dna.graph.connector.map.MapRepositoryTransaction;
import org.jboss.dna.graph.connector.map.MapWorkspace;
import org.jboss.dna.graph.request.LockBranchRequest;

public class InfinispanRepository
extends MapRepository {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CacheManager cacheManager;

    public InfinispanRepository(String sourceName, UUID rootNodeUuid, CacheManager cacheManager) {
        super(sourceName, rootNodeUuid, null);
        assert (cacheManager != null);
        this.cacheManager = cacheManager;
        this.initialize();
    }

    public InfinispanRepository(String sourceName, UUID rootNodeUuid, String defaultWorkspaceName, CacheManager cacheManager) {
        super(sourceName, rootNodeUuid, defaultWorkspaceName);
        assert (cacheManager != null);
        this.cacheManager = cacheManager;
        this.initialize();
    }

    protected MapWorkspace createWorkspace(ExecutionContext context, String name) {
        assert (name != null);
        assert (this.cacheManager != null);
        Cache newWorkspaceCache = this.cacheManager.getCache(name);
        return new Workspace(this, name, (Cache<UUID, MapNode>)newWorkspaceCache);
    }

    public MapRepositoryTransaction startTransaction(boolean readonly) {
        return new LockBasedTransaction(readonly ? this.lock.readLock() : this.lock.writeLock()){

            public void commit() {
                super.commit();
            }

            public void rollback() {
                super.rollback();
            }
        };
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Workspace
    extends AbstractMapWorkspace {
        private final Cache<UUID, MapNode> workspaceCache;

        public Workspace(MapRepository repository, String name, Cache<UUID, MapNode> workspaceCache) {
            super(repository, name);
            this.workspaceCache = workspaceCache;
            this.initialize();
        }

        protected void addNodeToMap(MapNode node) {
            assert (node != null);
            this.workspaceCache.put((Object)node.getUuid(), (Object)node);
        }

        protected MapNode removeNodeFromMap(UUID nodeUuid) {
            assert (nodeUuid != null);
            return (MapNode)this.workspaceCache.remove((Object)nodeUuid);
        }

        protected void removeAllNodesFromMap() {
            this.workspaceCache.clear();
        }

        public MapNode getNode(UUID nodeUuid) {
            assert (nodeUuid != null);
            return (MapNode)this.workspaceCache.get((Object)nodeUuid);
        }

        public void lockNode(MapNode node, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) throws LockFailedException {
        }

        public void unlockNode(MapNode node) {
        }
    }
}

