/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.connector.jbosscache.JBossCacheConnectorI18n;
import org.jboss.dna.connector.jbosscache.JBossCacheLexicon;
import org.jboss.dna.connector.jbosscache.JBossCacheSource;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.commands.CopyBranchCommand;
import org.jboss.dna.graph.commands.CopyNodeCommand;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.DeleteBranchCommand;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.GetPropertiesCommand;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.MoveBranchCommand;
import org.jboss.dna.graph.commands.RecordBranchCommand;
import org.jboss.dna.graph.commands.SetPropertiesCommand;
import org.jboss.dna.graph.commands.executor.AbstractCommandExecutor;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.connectors.RepositorySourceListener;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PathNotFoundException;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheConnection
implements RepositoryConnection {
    protected static final RepositorySourceListener NO_OP_LISTENER = new RepositorySourceListener(){

        public void notify(String sourceName, Object ... events) {
        }
    };
    private Name uuidPropertyName;
    private final JBossCacheSource source;
    private final Cache<Name, Object> cache;
    private RepositorySourceListener listener = NO_OP_LISTENER;

    JBossCacheConnection(JBossCacheSource source, Cache<Name, Object> cache) {
        assert (source != null);
        assert (cache != null);
        this.source = source;
        this.cache = cache;
    }

    Cache<Name, Object> getCache() {
        return this.cache;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        this.cache.getRoot();
        return true;
    }

    public void setListener(RepositorySourceListener listener) {
        this.listener = listener != null ? listener : NO_OP_LISTENER;
    }

    public void close() {
    }

    public void execute(ExecutionContext context, GraphCommand ... commands) throws RepositorySourceException {
        Executor executor = new Executor(context, this.getSourceName());
        for (GraphCommand command : commands) {
            executor.execute(command);
        }
    }

    protected RepositorySourceListener getListener() {
        return this.listener;
    }

    protected Name getUuidPropertyName(ExecutionContext context) {
        if (this.uuidPropertyName == null) {
            NameFactory nameFactory = context.getValueFactories().getNameFactory();
            this.uuidPropertyName = (Name)nameFactory.create(this.source.getUuidPropertyName());
        }
        return this.uuidPropertyName;
    }

    protected Fqn<?> getFullyQualifiedName(Path path) {
        assert (path != null);
        return Fqn.fromList((List)path.getSegmentsList());
    }

    protected Fqn<?> getFullyQualifiedName(Path.Segment pathSegment) {
        assert (pathSegment != null);
        return Fqn.fromElements((Object[])new Path.Segment[]{pathSegment});
    }

    protected Path getPath(PathFactory factory, Fqn<?> fqn) {
        List segments = fqn.peekElements();
        return factory.create(factory.createRootPath(), (Iterable)segments);
    }

    protected Node<Name, Object> getNode(ExecutionContext context, Path path) {
        Fqn fqn = this.getFullyQualifiedName(path);
        Node node = this.cache.getNode(fqn);
        if (node == null) {
            String nodePath = path.getString(context.getNamespaceRegistry());
            Path lowestExisting = null;
            while (fqn != null) {
                node = this.cache.getNode(fqn = fqn.getParent());
                if (node == null) continue;
                lowestExisting = this.getPath(context.getValueFactories().getPathFactory(), fqn);
                fqn = null;
            }
            throw new PathNotFoundException(path, lowestExisting, JBossCacheConnectorI18n.nodeDoesNotExist.text(new Object[]{nodePath}));
        }
        return node;
    }

    protected UUID generateUuid() {
        return UUID.randomUUID();
    }

    protected int copyNode(Node<Name, Object> original, Node<Name, Object> newParent, boolean recursive, Name uuidProperty, ExecutionContext context) {
        assert (original != null);
        assert (newParent != null);
        Path.Segment name = (Path.Segment)original.getFqn().getLastElement();
        Path.Segment newSegment = this.updateChildList(newParent, name.getName(), context, true);
        Node copy = newParent.addChild(this.getFullyQualifiedName(newSegment));
        assert (this.checkChildren(newParent));
        copy.clearData();
        copy.putAll(original.getData());
        if (uuidProperty != null) {
            copy.put((Object)uuidProperty, (Object)this.generateUuid());
        }
        int numNodesCopied = 1;
        if (recursive) {
            for (Node child : original.getChildren()) {
                numNodesCopied += this.copyNode((Node<Name, Object>)child, (Node<Name, Object>)copy, true, uuidProperty, context);
            }
        }
        return numNodesCopied;
    }

    protected Path.Segment updateChildList(Node<Name, Object> parent, Name changedName, ExecutionContext context, boolean addChildWithName) {
        assert (parent != null);
        assert (changedName != null);
        assert (context != null);
        Set children = parent.getChildren();
        if (children.isEmpty() && !addChildWithName) {
            return null;
        }
        LinkedList<ChildInfo> childrenWithChangedName = new LinkedList<ChildInfo>();
        Path.Segment[] childNames = (Path.Segment[])parent.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        int index = 0;
        if (childNames != null) {
            for (Path.Segment childName : childNames) {
                if (childName.getName().equals(changedName)) {
                    ChildInfo info = new ChildInfo(childName, index);
                    childrenWithChangedName.add(info);
                }
                ++index;
            }
        }
        if (addChildWithName) {
            if (childNames == null) {
                childNames = new Path.Segment[1];
            } else {
                int numExisting = childNames.length;
                Path.Segment[] newChildNames = new Path.Segment[numExisting + 1];
                System.arraycopy(childNames, 0, newChildNames, 0, numExisting);
                childNames = newChildNames;
            }
            ChildInfo info = new ChildInfo(null, index);
            childrenWithChangedName.add(info);
            Path.Segment newSegment = context.getValueFactories().getPathFactory().createSegment(changedName);
            childNames[index++] = newSegment;
        }
        assert (childNames != null);
        assert (!childrenWithChangedName.isEmpty());
        if (childrenWithChangedName.size() == 1) {
            ChildInfo child = (ChildInfo)childrenWithChangedName.get(0);
            if (child.segment != null && child.segment.hasIndex()) {
                Path.Segment newSegment = context.getValueFactories().getPathFactory().createSegment(changedName);
                this.changeNodeName(parent, child.segment, newSegment, context);
                childNames[child.childIndex] = newSegment;
            }
        } else {
            int i = 0;
            for (ChildInfo child : childrenWithChangedName) {
                Path.Segment newSegment;
                if (child.segment != null) {
                    newSegment = context.getValueFactories().getPathFactory().createSegment(changedName, i + 1);
                    this.changeNodeName(parent, child.segment, newSegment, context);
                    childNames[child.childIndex] = newSegment;
                } else {
                    childNames[child.childIndex] = newSegment = context.getValueFactories().getPathFactory().createSegment(changedName, i + 1);
                }
                ++i;
            }
        }
        context.getLogger(this.getClass()).trace("Updating child list of {0} to: {1}", new Object[]{parent.getFqn(), StringUtil.readableString((Object)childNames)});
        parent.put((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST, (Object)childNames);
        if (addChildWithName) {
            return childNames[childNames.length - 1];
        }
        return null;
    }

    protected boolean checkChildren(Node<Name, Object> parent) {
        Path.Segment[] childNamesProperty = (Path.Segment[])parent.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        Set childNames = parent.getChildrenNames();
        boolean result = true;
        if (childNamesProperty.length != childNames.size()) {
            result = false;
        }
        for (int i = 0; i != childNamesProperty.length; ++i) {
            if (childNames.contains(childNamesProperty[i])) continue;
            result = false;
        }
        if (!result) {
            ArrayList<Path.Segment> names = new ArrayList<Path.Segment>();
            for (Object name : childNames) {
                names.add((Path.Segment)name);
            }
            Collections.sort(names);
        }
        return result;
    }

    protected void changeNodeName(Node<Name, Object> parent, Path.Segment existing, Path.Segment newSegment, ExecutionContext context) {
        assert (parent != null);
        assert (existing != null);
        assert (newSegment != null);
        assert (context != null);
        if (existing.equals(newSegment)) {
            return;
        }
        context.getLogger(this.getClass()).trace("Renaming {0} to {1} under {2}", new Object[]{existing, newSegment, parent.getFqn()});
        Node existingChild = parent.getChild((Object)existing);
        assert (existingChild != null);
        Node newChild = parent.addChild(Fqn.fromElements((Object[])new Path.Segment[]{newSegment}));
        Fqn newChildFqn = newChild.getFqn();
        newChild.putAll(existingChild.getData());
        for (Node grandChild : existingChild.getChildren()) {
            this.cache.move(grandChild.getFqn(), newChildFqn);
        }
        parent.removeChild((Object)existing);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Executor
    extends AbstractCommandExecutor {
        private final PropertyFactory propertyFactory;
        private final ValueFactory<UUID> uuidFactory;

        protected Executor(ExecutionContext context, String sourceName) {
            super(context, sourceName);
            this.propertyFactory = context.getPropertyFactory();
            this.uuidFactory = context.getValueFactories().getUuidFactory();
        }

        public void execute(CreateNodeCommand command) {
            Path path = command.getPath();
            Path parent = path.getParent();
            Node<Name, Object> parentNode = this.getNode(parent);
            Path.Segment newSegment = JBossCacheConnection.this.updateChildList(parentNode, path.getLastSegment().getName(), this.getExecutionContext(), true);
            Node node = parentNode.addChild(Fqn.fromElements((Object[])new Path.Segment[]{newSegment}));
            assert (JBossCacheConnection.this.checkChildren(parentNode));
            Name uuidPropertyName = JBossCacheConnection.this.getUuidPropertyName(this.getExecutionContext());
            if (uuidPropertyName != null) {
                node.put((Object)uuidPropertyName, (Object)JBossCacheConnection.this.generateUuid());
            }
            for (Property property : command.getProperties()) {
                if (property.size() == 0) continue;
                Name propName = property.getName();
                Object value = null;
                value = property.size() == 1 ? property.iterator().next() : property.getValuesAsArray();
                node.put((Object)propName, value);
            }
        }

        public void execute(GetChildrenCommand command) {
            Path.Segment[] childList;
            Node<Name, Object> node = this.getNode(command.getPath());
            Name uuidPropertyName = JBossCacheConnection.this.getUuidPropertyName(this.getExecutionContext());
            for (Path.Segment child : childList = (Path.Segment[])node.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) {
                Node childNode = node.getChild((Object)child);
                Object uuid = childNode.get((Object)uuidPropertyName);
                if (uuid == null) {
                    uuid = JBossCacheConnection.this.generateUuid();
                    childNode.put((Object)uuidPropertyName, uuid);
                } else {
                    uuid = this.uuidFactory.create(uuid);
                }
                Property uuidProperty = this.propertyFactory.create(uuidPropertyName, new Object[]{uuid});
                command.addChild(child, new Property[]{uuidProperty});
            }
        }

        public void execute(GetPropertiesCommand command) {
            Node<Name, Object> node = this.getNode(command.getPath());
            Map dataMap = node.getData();
            for (Map.Entry data : dataMap.entrySet()) {
                Name propertyName = (Name)data.getKey();
                if (propertyName.equals(JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) continue;
                Object values = data.getValue();
                Property property = this.propertyFactory.create(propertyName, new Object[]{values});
                command.setProperty(property);
            }
        }

        public void execute(SetPropertiesCommand command) {
            Node<Name, Object> node = this.getNode(command.getPath());
            for (Property property : command.getProperties()) {
                Name propName = property.getName();
                if (propName.equals(JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) continue;
                if (property.size() == 0) {
                    node.remove((Object)propName);
                    continue;
                }
                Object value = null;
                value = property.size() == 1 ? property.iterator().next() : property.getValuesAsArray();
                node.put((Object)propName, value);
            }
        }

        public void execute(DeleteBranchCommand command) {
            Node<Name, Object> node = this.getNode(command.getPath());
            node.getParent().removeChild(node.getFqn().getLastElement());
        }

        public void execute(CopyNodeCommand command) {
            Node<Name, Object> node = this.getNode(command.getPath());
            Path newPath = command.getNewPath();
            Node<Name, Object> newParent = this.getNode(newPath.getParent());
            JBossCacheConnection.this.copyNode(node, newParent, false, null, this.getExecutionContext());
        }

        public void execute(CopyBranchCommand command) {
            Node<Name, Object> node = this.getNode(command.getPath());
            Path newPath = command.getNewPath();
            Node<Name, Object> newParent = this.getNode(newPath.getParent());
            JBossCacheConnection.this.copyNode(node, newParent, true, null, this.getExecutionContext());
        }

        public void execute(MoveBranchCommand command) {
            Node<Name, Object> node = this.getNode(command.getPath());
            boolean recursive = true;
            Name uuidProperty = JBossCacheConnection.this.getUuidPropertyName(this.getExecutionContext());
            Path newPath = command.getNewPath();
            Node<Name, Object> newParent = this.getNode(newPath.getParent());
            JBossCacheConnection.this.copyNode(node, newParent, recursive, uuidProperty, this.getExecutionContext());
            Node oldParent = node.getParent();
            boolean removed = oldParent.removeChild(node.getFqn().getLastElement());
            assert (removed);
        }

        public void execute(RecordBranchCommand command) {
            Node<Name, Object> node = this.getNode(command.getPath());
            this.recordNode(command, node);
        }

        protected void recordNode(RecordBranchCommand command, Node<Name, Object> node) {
            Map dataMap = node.getData();
            LinkedList<Property> properties = new LinkedList<Property>();
            for (Map.Entry data : dataMap.entrySet()) {
                Name propertyName = (Name)data.getKey();
                Object values = data.getValue();
                Property property = this.propertyFactory.create(propertyName, new Object[]{values});
                properties.add(property);
            }
            command.record(command.getPath(), properties);
            for (Node child : node.getChildren()) {
                this.recordNode(command, (Node<Name, Object>)child);
            }
        }

        protected Node<Name, Object> getNode(Path path) {
            return JBossCacheConnection.this.getNode(this.getExecutionContext(), path);
        }
    }

    private static class ChildInfo {
        protected final Path.Segment segment;
        protected final int childIndex;

        protected ChildInfo(Path.Segment childSegment, int childIndex) {
            this.segment = childSegment;
            this.childIndex = childIndex;
        }
    }
}

