/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.ThreadSafe;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.connector.jbosscache.JBossCacheConnection;
import org.jboss.dna.connector.jbosscache.JBossCacheConnectorI18n;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryContext;
import org.jboss.dna.graph.connectors.RepositorySource;
import org.jboss.dna.graph.connectors.RepositorySourceCapabilities;
import org.jboss.dna.graph.connectors.RepositorySourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JBossCacheSource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_UUID_PROPERTY_NAME = DnaLexicon.UUID.getString();
    protected static final String ROOT_NODE_UUID = "rootNodeUuid";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String DEFAULT_CACHE_POLICY = "defaultCachePolicy";
    protected static final String CACHE_CONFIGURATION_NAME = "cacheConfigurationName";
    protected static final String CACHE_FACTORY_JNDI_NAME = "cacheFactoryJndiName";
    protected static final String CACHE_JNDI_NAME = "cacheJndiName";
    protected static final String UUID_PROPERTY_NAME = "uuidPropertyName";
    protected static final String RETRY_LIMIT = "retryLimit";
    private String name;
    private UUID rootNodeUuid = UUID.randomUUID();
    private CachePolicy defaultCachePolicy;
    private String cacheConfigurationName;
    private String cacheFactoryJndiName;
    private String cacheJndiName;
    private String uuidPropertyName = DEFAULT_UUID_PROPERTY_NAME;
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private transient Cache<org.jboss.dna.graph.properties.Name, Object> cache;
    private transient Context jndiContext;
    private transient RepositoryContext repositoryContext;

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public String getName() {
        return this.name;
    }

    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public synchronized void setName(String name) {
        if (this.name == name || this.name != null && this.name.equals(name)) {
            return;
        }
        this.name = name;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public synchronized void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        if (this.defaultCachePolicy == defaultCachePolicy || this.defaultCachePolicy != null && this.defaultCachePolicy.equals(defaultCachePolicy)) {
            return;
        }
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public String getCacheJndiName() {
        return this.cacheJndiName;
    }

    public synchronized void setCacheJndiName(String cacheJndiName) {
        if (this.cacheJndiName == cacheJndiName || this.cacheJndiName != null && this.cacheJndiName.equals(cacheJndiName)) {
            return;
        }
        this.cacheJndiName = cacheJndiName;
    }

    public String getCacheFactoryJndiName() {
        return this.cacheFactoryJndiName;
    }

    public synchronized void setCacheFactoryJndiName(String jndiName) {
        if (this.cacheFactoryJndiName == jndiName || this.cacheFactoryJndiName != null && this.cacheFactoryJndiName.equals(jndiName)) {
            return;
        }
        this.cacheFactoryJndiName = jndiName;
    }

    public String getCacheConfigurationName() {
        return this.cacheConfigurationName;
    }

    public synchronized void setCacheConfigurationName(String cacheConfigurationName) {
        if (this.cacheConfigurationName == cacheConfigurationName || this.cacheConfigurationName != null && this.cacheConfigurationName.equals(cacheConfigurationName)) {
            return;
        }
        this.cacheConfigurationName = cacheConfigurationName;
    }

    public String getRootNodeUuid() {
        return this.rootNodeUuid.toString();
    }

    public UUID getRootNodeUuidObject() {
        return this.rootNodeUuid;
    }

    public synchronized void setRootNodeUuid(String rootNodeUuid) {
        UUID uuid = null;
        uuid = rootNodeUuid == null ? UUID.randomUUID() : UUID.fromString(rootNodeUuid);
        if (this.rootNodeUuid.equals(uuid)) {
            return;
        }
        this.rootNodeUuid = uuid;
    }

    public String getUuidPropertyName() {
        return this.uuidPropertyName;
    }

    public synchronized void setUuidPropertyName(String uuidPropertyName) {
        if (uuidPropertyName == null || uuidPropertyName.trim().length() == 0) {
            uuidPropertyName = DEFAULT_UUID_PROPERTY_NAME;
        }
        if (this.uuidPropertyName.equals(uuidPropertyName)) {
            return;
        }
        this.uuidPropertyName = uuidPropertyName;
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.getName() == null) {
            I18n msg = JBossCacheConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.getUuidPropertyName() == null) {
            I18n msg = JBossCacheConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{UUID_PROPERTY_NAME}));
        }
        if (this.cache == null) {
            Context context = this.getContext();
            String jndiName = this.getCacheJndiName();
            if (jndiName != null && jndiName.trim().length() != 0) {
                Object object = null;
                try {
                    if (context == null) {
                        context = new InitialContext();
                    }
                    if ((object = context.lookup(jndiName)) != null) {
                        this.cache = (Cache)object;
                    }
                }
                catch (ClassCastException err) {
                    I18n msg = JBossCacheConnectorI18n.objectFoundInJndiWasNotCache;
                    String className = object != null ? object.getClass().getName() : "null";
                    throw new RepositorySourceException(this.getName(), msg.text(new Object[]{jndiName, this.getName(), className}), (Throwable)err);
                }
                catch (Throwable err) {
                    // empty catch block
                }
            }
            if (this.cache == null) {
                String configName;
                DefaultCacheFactory cacheFactory = null;
                jndiName = this.getCacheFactoryJndiName();
                if (jndiName != null && jndiName.trim().length() != 0) {
                    Object object = null;
                    try {
                        if (context == null) {
                            context = new InitialContext();
                        }
                        if ((object = context.lookup(jndiName)) != null) {
                            cacheFactory = (CacheFactory)object;
                        }
                    }
                    catch (ClassCastException err) {
                        I18n msg = JBossCacheConnectorI18n.objectFoundInJndiWasNotCacheFactory;
                        String className = object != null ? object.getClass().getName() : "null";
                        throw new RepositorySourceException(this.getName(), msg.text(new Object[]{jndiName, this.getName(), className}), (Throwable)err);
                    }
                    catch (Throwable err) {
                        // empty catch block
                    }
                }
                if (cacheFactory == null) {
                    cacheFactory = new DefaultCacheFactory();
                }
                this.cache = (configName = this.getCacheConfigurationName()) != null ? cacheFactory.createCache(configName) : cacheFactory.createCache();
            }
        }
        return new JBossCacheConnection(this, this.cache);
    }

    protected Context getContext() {
        return this.jndiContext;
    }

    protected synchronized void setContext(Context context) {
        this.jndiContext = context;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JBossCacheSource) {
            JBossCacheSource that = (JBossCacheSource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        if (this.getRootNodeUuid() != null) {
            ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuid().toString()));
        }
        if (this.getUuidPropertyName() != null) {
            ref.add(new StringRefAddr(UUID_PROPERTY_NAME, this.getUuidPropertyName()));
        }
        if (this.getCacheJndiName() != null) {
            ref.add(new StringRefAddr(CACHE_JNDI_NAME, this.getCacheJndiName()));
        }
        if (this.getCacheFactoryJndiName() != null) {
            ref.add(new StringRefAddr(CACHE_FACTORY_JNDI_NAME, this.getCacheFactoryJndiName()));
        }
        if (this.getCacheConfigurationName() != null) {
            ref.add(new StringRefAddr(CACHE_CONFIGURATION_NAME, this.getCacheConfigurationName()));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = JBossCacheConnectorI18n.errorSerializingCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String rootNodeUuidString = (String)values.get(ROOT_NODE_UUID);
            String uuidPropertyName = (String)values.get(UUID_PROPERTY_NAME);
            String cacheJndiName = (String)values.get(CACHE_JNDI_NAME);
            String cacheFactoryJndiName = (String)values.get(CACHE_FACTORY_JNDI_NAME);
            String cacheConfigurationName = (String)values.get(CACHE_CONFIGURATION_NAME);
            Object defaultCachePolicy = values.get(DEFAULT_CACHE_POLICY);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            JBossCacheSource source = new JBossCacheSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuidString != null) {
                source.setRootNodeUuid(rootNodeUuidString);
            }
            if (uuidPropertyName != null) {
                source.setUuidPropertyName(uuidPropertyName);
            }
            if (cacheJndiName != null) {
                source.setCacheJndiName(cacheJndiName);
            }
            if (cacheFactoryJndiName != null) {
                source.setCacheFactoryJndiName(cacheFactoryJndiName);
            }
            if (cacheConfigurationName != null) {
                source.setCacheConfigurationName(cacheConfigurationName);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return new Capabilities();
    }

    protected class Capabilities
    implements RepositorySourceCapabilities {
        protected Capabilities() {
        }

        public boolean supportsSameNameSiblings() {
            return true;
        }

        public boolean supportsUpdates() {
            return true;
        }
    }
}

