/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAResource;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.dna.connector.jbosscache.JBossCacheConnectorI18n;
import org.jboss.dna.connector.jbosscache.JBossCacheLexicon;
import org.jboss.dna.connector.jbosscache.JBossCacheSource;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.connectors.RepositorySourceListener;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PathNotFoundException;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.UuidFactory;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.graph.requests.CopyBranchRequest;
import org.jboss.dna.graph.requests.CreateNodeRequest;
import org.jboss.dna.graph.requests.DeleteBranchRequest;
import org.jboss.dna.graph.requests.MoveBranchRequest;
import org.jboss.dna.graph.requests.ReadAllChildrenRequest;
import org.jboss.dna.graph.requests.ReadAllPropertiesRequest;
import org.jboss.dna.graph.requests.Request;
import org.jboss.dna.graph.requests.UpdatePropertiesRequest;
import org.jboss.dna.graph.requests.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheConnection
implements RepositoryConnection {
    protected static final RepositorySourceListener NO_OP_LISTENER = new RepositorySourceListener(){

        public void notify(String sourceName, Object ... events) {
        }
    };
    private final JBossCacheSource source;
    private final Cache<Name, Object> cache;
    private RepositorySourceListener listener = NO_OP_LISTENER;

    JBossCacheConnection(JBossCacheSource source, Cache<Name, Object> cache) {
        assert (source != null);
        assert (cache != null);
        this.source = source;
        this.cache = cache;
    }

    Cache<Name, Object> getCache() {
        return this.cache;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        this.cache.getRoot();
        return true;
    }

    public void setListener(RepositorySourceListener listener) {
        this.listener = listener != null ? listener : NO_OP_LISTENER;
    }

    public void close() {
    }

    public void execute(final ExecutionContext context, Request request) throws RepositorySourceException {
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propertyFactory = context.getPropertyFactory();
        UuidFactory uuidFactory = context.getValueFactories().getUuidFactory();
        RequestProcessor processor = new RequestProcessor(this.getSourceName(), context, (ValueFactory)uuidFactory, propertyFactory, pathFactory){
            final /* synthetic */ ValueFactory val$uuidFactory;
            final /* synthetic */ PropertyFactory val$propertyFactory;
            final /* synthetic */ PathFactory val$pathFactory;
            {
                this.val$uuidFactory = valueFactory;
                this.val$propertyFactory = propertyFactory;
                this.val$pathFactory = pathFactory;
                super(x0, x1);
            }

            public void process(ReadAllChildrenRequest request) {
                Path.Segment[] childList;
                Path nodePath = request.of().getPath();
                Node<Name, Object> node = JBossCacheConnection.this.getNode(context, nodePath);
                for (Path.Segment child : childList = (Path.Segment[])node.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) {
                    Node childNode = node.getChild((Object)child);
                    Object uuid = childNode.get((Object)DnaLexicon.UUID);
                    if (uuid == null) {
                        uuid = JBossCacheConnection.this.generateUuid();
                        childNode.put((Object)DnaLexicon.UUID, uuid);
                    } else {
                        uuid = this.val$uuidFactory.create(uuid);
                    }
                    Property uuidProperty = this.val$propertyFactory.create(DnaLexicon.UUID, new Object[]{uuid});
                    request.addChild(this.val$pathFactory.create(nodePath, new Path.Segment[]{child}), uuidProperty);
                }
                UUID uuid = (UUID)this.val$uuidFactory.create(node.get((Object)DnaLexicon.UUID));
                request.setActualLocationOfNode(new Location(nodePath, uuid));
            }

            public void process(ReadAllPropertiesRequest request) {
                Path nodePath = request.at().getPath();
                Node<Name, Object> node = JBossCacheConnection.this.getNode(context, nodePath);
                Map dataMap = node.getData();
                for (Map.Entry data : dataMap.entrySet()) {
                    Name propertyName = (Name)data.getKey();
                    if (propertyName.equals(JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) continue;
                    Object values = data.getValue();
                    Property property = this.val$propertyFactory.create(propertyName, new Object[]{values});
                    request.addProperty(property);
                }
                UUID uuid = (UUID)this.val$uuidFactory.create(node.get((Object)DnaLexicon.UUID));
                request.setActualLocationOfNode(new Location(nodePath, uuid));
            }

            public void process(CreateNodeRequest request) {
                Path path = request.at().getPath();
                Path parent = path.getParent();
                Node<Name, Object> parentNode = JBossCacheConnection.this.getNode(context, parent);
                Path.Segment newSegment = JBossCacheConnection.this.updateChildList(parentNode, path.getLastSegment().getName(), this.getExecutionContext(), true);
                Node node = parentNode.addChild(Fqn.fromElements((Object[])new Path.Segment[]{newSegment}));
                assert (JBossCacheConnection.this.checkChildren(parentNode));
                node.put((Object)DnaLexicon.UUID, (Object)JBossCacheConnection.this.generateUuid());
                for (Property property : request.properties()) {
                    if (property.size() == 0) continue;
                    Name propName = property.getName();
                    Object value = null;
                    value = property.size() == 1 ? property.iterator().next() : property.getValuesAsArray();
                    node.put((Object)propName, value);
                }
                UUID uuid = (UUID)this.val$uuidFactory.create(node.get((Object)DnaLexicon.UUID));
                Path nodePath = this.val$pathFactory.create(parent, new Path.Segment[]{newSegment});
                request.setActualLocationOfNode(new Location(nodePath, uuid));
            }

            public void process(UpdatePropertiesRequest request) {
                Path nodePath = request.on().getPath();
                Node<Name, Object> node = JBossCacheConnection.this.getNode(context, nodePath);
                for (Property property : request.properties()) {
                    Name propName = property.getName();
                    if (propName.equals(JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) continue;
                    if (property.size() == 0) {
                        node.remove((Object)propName);
                        continue;
                    }
                    Object value = null;
                    value = property.size() == 1 ? property.iterator().next() : property.getValuesAsArray();
                    node.put((Object)propName, value);
                }
                UUID uuid = (UUID)this.val$uuidFactory.create(node.get((Object)DnaLexicon.UUID));
                request.setActualLocationOfNode(new Location(nodePath, uuid));
            }

            public void process(CopyBranchRequest request) {
                Path nodePath = request.from().getPath();
                Node<Name, Object> node = JBossCacheConnection.this.getNode(context, nodePath);
                Path newParentPath = request.into().getPath();
                Node<Name, Object> newParent = JBossCacheConnection.this.getNode(context, newParentPath);
                Path.Segment newSegment = JBossCacheConnection.this.copyNode(node, newParent, true, null, null, this.getExecutionContext());
                UUID uuid = (UUID)this.val$uuidFactory.create(node.get((Object)DnaLexicon.UUID));
                Path newPath = this.val$pathFactory.create(newParentPath, new Path.Segment[]{newSegment});
                request.setActualLocations(new Location(nodePath, uuid), new Location(newPath, uuid));
            }

            public void process(DeleteBranchRequest request) {
                Path nodePath = request.at().getPath();
                Node<Name, Object> node = JBossCacheConnection.this.getNode(context, nodePath);
                node.getParent().removeChild(node.getFqn().getLastElement());
                UUID uuid = (UUID)this.val$uuidFactory.create(node.get((Object)DnaLexicon.UUID));
                request.setActualLocationOfNode(new Location(nodePath, uuid));
            }

            public void process(MoveBranchRequest request) {
                Path nodePath = request.from().getPath();
                Node<Name, Object> node = JBossCacheConnection.this.getNode(context, nodePath);
                boolean recursive = true;
                Path newParentPath = request.into().getPath();
                Node<Name, Object> newParent = JBossCacheConnection.this.getNode(context, newParentPath);
                Path.Segment newSegment = JBossCacheConnection.this.copyNode(node, newParent, recursive, DnaLexicon.UUID, null, this.getExecutionContext());
                Node oldParent = node.getParent();
                boolean removed = oldParent.removeChild(node.getFqn().getLastElement());
                assert (removed);
                UUID uuid = (UUID)this.val$uuidFactory.create(node.get((Object)DnaLexicon.UUID));
                Path newPath = this.val$pathFactory.create(newParentPath, new Path.Segment[]{newSegment});
                request.setActualLocations(new Location(nodePath, uuid), new Location(newPath, uuid));
            }
        };
        processor.process(request);
    }

    protected RepositorySourceListener getListener() {
        return this.listener;
    }

    protected Fqn<?> getFullyQualifiedName(Path path) {
        assert (path != null);
        return Fqn.fromList((List)path.getSegmentsList());
    }

    protected Fqn<?> getFullyQualifiedName(Path.Segment pathSegment) {
        assert (pathSegment != null);
        return Fqn.fromElements((Object[])new Path.Segment[]{pathSegment});
    }

    protected Path getPath(PathFactory factory, Fqn<?> fqn) {
        List segments = fqn.peekElements();
        return factory.create(factory.createRootPath(), (Iterable)segments);
    }

    protected Node<Name, Object> getNode(ExecutionContext context, Path path) {
        Fqn fqn = this.getFullyQualifiedName(path);
        Node node = this.cache.getNode(fqn);
        if (node == null) {
            String nodePath = path.getString(context.getNamespaceRegistry());
            Path lowestExisting = null;
            while (fqn != null) {
                node = this.cache.getNode(fqn = fqn.getParent());
                if (node == null) continue;
                lowestExisting = this.getPath(context.getValueFactories().getPathFactory(), fqn);
                fqn = null;
            }
            throw new PathNotFoundException(new Location(path), lowestExisting, JBossCacheConnectorI18n.nodeDoesNotExist.text(new Object[]{nodePath}));
        }
        return node;
    }

    protected UUID generateUuid() {
        return UUID.randomUUID();
    }

    protected Path.Segment copyNode(Node<Name, Object> original, Node<Name, Object> newParent, boolean recursive, Name uuidProperty, AtomicInteger count, ExecutionContext context) {
        assert (original != null);
        assert (newParent != null);
        Path.Segment name = (Path.Segment)original.getFqn().getLastElement();
        Path.Segment newSegment = this.updateChildList(newParent, name.getName(), context, true);
        Node copy = newParent.addChild(this.getFullyQualifiedName(newSegment));
        assert (this.checkChildren(newParent));
        copy.clearData();
        copy.putAll(original.getData());
        if (uuidProperty != null) {
            copy.put((Object)uuidProperty, (Object)this.generateUuid());
        }
        if (count != null) {
            count.incrementAndGet();
        }
        if (recursive) {
            for (Node child : original.getChildren()) {
                this.copyNode((Node<Name, Object>)child, (Node<Name, Object>)copy, true, uuidProperty, count, context);
            }
        }
        return newSegment;
    }

    protected Path.Segment updateChildList(Node<Name, Object> parent, Name changedName, ExecutionContext context, boolean addChildWithName) {
        assert (parent != null);
        assert (changedName != null);
        assert (context != null);
        Set children = parent.getChildren();
        if (children.isEmpty() && !addChildWithName) {
            return null;
        }
        LinkedList<ChildInfo> childrenWithChangedName = new LinkedList<ChildInfo>();
        Path.Segment[] childNames = (Path.Segment[])parent.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        int index = 0;
        if (childNames != null) {
            for (Path.Segment childName : childNames) {
                if (childName.getName().equals(changedName)) {
                    ChildInfo info = new ChildInfo(childName, index);
                    childrenWithChangedName.add(info);
                }
                ++index;
            }
        }
        if (addChildWithName) {
            if (childNames == null) {
                childNames = new Path.Segment[1];
            } else {
                int numExisting = childNames.length;
                Path.Segment[] newChildNames = new Path.Segment[numExisting + 1];
                System.arraycopy(childNames, 0, newChildNames, 0, numExisting);
                childNames = newChildNames;
            }
            ChildInfo info = new ChildInfo(null, index);
            childrenWithChangedName.add(info);
            Path.Segment newSegment = context.getValueFactories().getPathFactory().createSegment(changedName);
            childNames[index++] = newSegment;
        }
        assert (childNames != null);
        assert (!childrenWithChangedName.isEmpty());
        if (childrenWithChangedName.size() == 1) {
            ChildInfo child = (ChildInfo)childrenWithChangedName.get(0);
            if (child.segment != null && child.segment.hasIndex()) {
                Path.Segment newSegment = context.getValueFactories().getPathFactory().createSegment(changedName);
                this.changeNodeName(parent, child.segment, newSegment, context);
                childNames[child.childIndex] = newSegment;
            }
        } else {
            int i = 0;
            for (ChildInfo child : childrenWithChangedName) {
                Path.Segment newSegment;
                if (child.segment != null) {
                    newSegment = context.getValueFactories().getPathFactory().createSegment(changedName, i + 1);
                    this.changeNodeName(parent, child.segment, newSegment, context);
                    childNames[child.childIndex] = newSegment;
                } else {
                    childNames[child.childIndex] = newSegment = context.getValueFactories().getPathFactory().createSegment(changedName, i + 1);
                }
                ++i;
            }
        }
        context.getLogger(this.getClass()).trace("Updating child list of {0} to: {1}", new Object[]{parent.getFqn(), Arrays.asList(childNames)});
        parent.put((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST, (Object)childNames);
        if (addChildWithName) {
            return childNames[childNames.length - 1];
        }
        return null;
    }

    protected boolean checkChildren(Node<Name, Object> parent) {
        Path.Segment[] childNamesProperty = (Path.Segment[])parent.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        Set childNames = parent.getChildrenNames();
        boolean result = true;
        if (childNamesProperty.length != childNames.size()) {
            result = false;
        }
        for (int i = 0; i != childNamesProperty.length; ++i) {
            if (childNames.contains(childNamesProperty[i])) continue;
            result = false;
        }
        if (!result) {
            ArrayList<Path.Segment> names = new ArrayList<Path.Segment>();
            for (Object name : childNames) {
                names.add((Path.Segment)name);
            }
            Collections.sort(names);
        }
        return result;
    }

    protected void changeNodeName(Node<Name, Object> parent, Path.Segment existing, Path.Segment newSegment, ExecutionContext context) {
        assert (parent != null);
        assert (existing != null);
        assert (newSegment != null);
        assert (context != null);
        if (existing.equals(newSegment)) {
            return;
        }
        context.getLogger(this.getClass()).trace("Renaming {0} to {1} under {2}", new Object[]{existing, newSegment, parent.getFqn()});
        Node existingChild = parent.getChild((Object)existing);
        assert (existingChild != null);
        Node newChild = parent.addChild(Fqn.fromElements((Object[])new Path.Segment[]{newSegment}));
        Fqn newChildFqn = newChild.getFqn();
        newChild.putAll(existingChild.getData());
        for (Node grandChild : existingChild.getChildren()) {
            this.cache.move(grandChild.getFqn(), newChildFqn);
        }
        parent.removeChild((Object)existing);
    }

    private static class ChildInfo {
        protected final Path.Segment segment;
        protected final int childIndex;

        protected ChildInfo(Path.Segment childSegment, int childIndex) {
            this.segment = childSegment;
            this.childIndex = childIndex;
        }
    }
}

