/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.jbosscache.JBossCacheConnectorI18n;
import org.jboss.dna.connector.jbosscache.JBossCacheLexicon;
import org.jboss.dna.connector.jbosscache.JBossCacheWorkspaces;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.UuidFactory;
import org.jboss.dna.graph.request.CacheableRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidRequestException;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheRequestProcessor
extends RequestProcessor {
    private final JBossCacheWorkspaces workspaces;
    private final boolean creatingWorkspacesAllowed;
    private final String defaultWorkspaceName;
    private final PathFactory pathFactory;
    private final PropertyFactory propertyFactory;
    private final UuidFactory uuidFactory;

    JBossCacheRequestProcessor(String sourceName, ExecutionContext context, JBossCacheWorkspaces workspaces, String defaultWorkspaceName, boolean creatingWorkspacesAllowed) {
        super(sourceName, context);
        assert (workspaces != null);
        assert (defaultWorkspaceName != null);
        this.workspaces = workspaces;
        this.creatingWorkspacesAllowed = creatingWorkspacesAllowed;
        this.defaultWorkspaceName = defaultWorkspaceName;
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.propertyFactory = context.getPropertyFactory();
        this.uuidFactory = context.getValueFactories().getUuidFactory();
    }

    public void process(ReadAllChildrenRequest request) {
        Cache<Name, Object> cache = this.getCache((Request)request, request.inWorkspace());
        if (cache == null) {
            return;
        }
        Path nodePath = request.of().getPath();
        Node<Name, Object> node = this.getNode((Request)request, cache, nodePath);
        if (node == null) {
            return;
        }
        Path.Segment[] childList = (Path.Segment[])node.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        if (childList != null) {
            for (Path.Segment child : childList) {
                request.addChild(Location.create((Path)this.pathFactory.create(nodePath, new Path.Segment[]{child})));
            }
        }
        request.setActualLocationOfNode(Location.create((Path)nodePath));
        this.setCacheableInfo((CacheableRequest)request);
    }

    public void process(ReadAllPropertiesRequest request) {
        Cache<Name, Object> cache = this.getCache((Request)request, request.inWorkspace());
        if (cache == null) {
            return;
        }
        Path nodePath = request.at().getPath();
        Node<Name, Object> node = this.getNode((Request)request, cache, nodePath);
        if (node == null) {
            return;
        }
        Map dataMap = node.getData();
        for (Map.Entry data : dataMap.entrySet()) {
            Name propertyName = (Name)data.getKey();
            if (propertyName.equals(JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) continue;
            Object values = data.getValue();
            Property property = this.propertyFactory.create(propertyName, new Object[]{values});
            request.addProperty(property);
        }
        request.setActualLocationOfNode(Location.create((Path)nodePath));
        this.setCacheableInfo((CacheableRequest)request);
    }

    public void process(CreateNodeRequest request) {
        Cache<Name, Object> cache = this.getCache((Request)request, request.inWorkspace());
        if (cache == null) {
            return;
        }
        Path parent = request.under().getPath();
        Node<Name, Object> parentNode = this.getNode((Request)request, cache, parent);
        if (parentNode == null) {
            return;
        }
        Path.Segment newSegment = this.updateChildList(cache, parentNode, request.named(), this.getExecutionContext(), true);
        Node node = parentNode.addChild(Fqn.fromElements((Object[])new Path.Segment[]{newSegment}));
        assert (this.checkChildren(parentNode));
        node.put((Object)DnaLexicon.UUID, (Object)this.uuidFactory.create());
        for (Property property : request.properties()) {
            if (property.size() == 0) continue;
            Name propName = property.getName();
            Object value = null;
            value = property.size() == 1 ? property.iterator().next() : property.getValuesAsArray();
            node.put((Object)propName, value);
        }
        Path nodePath = this.pathFactory.create(parent, new Path.Segment[]{newSegment});
        request.setActualLocationOfNode(Location.create((Path)nodePath));
    }

    public void process(UpdatePropertiesRequest request) {
        Cache<Name, Object> cache = this.getCache((Request)request, request.inWorkspace());
        if (cache == null) {
            return;
        }
        Path nodePath = request.on().getPath();
        Node<Name, Object> node = this.getNode((Request)request, cache, nodePath);
        if (node == null) {
            return;
        }
        for (Map.Entry entry : request.properties().entrySet()) {
            Name propName = (Name)entry.getKey();
            if (propName.equals(JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST)) continue;
            Property property = (Property)entry.getValue();
            if (property == null) {
                node.remove((Object)propName);
                continue;
            }
            Object value = null;
            value = property.isSingle() ? property.iterator().next() : property.getValuesAsArray();
            node.put((Object)propName, value);
        }
        request.setActualLocationOfNode(Location.create((Path)nodePath));
    }

    public void process(CopyBranchRequest request) {
        Cache<Name, Object> fromCache = this.getCache((Request)request, request.fromWorkspace());
        if (fromCache == null) {
            return;
        }
        Cache<Name, Object> intoCache = this.getCache((Request)request, request.intoWorkspace());
        if (intoCache == null) {
            return;
        }
        Path nodePath = request.from().getPath();
        Node<Name, Object> node = this.getNode((Request)request, fromCache, nodePath);
        if (node == null) {
            return;
        }
        Path newParentPath = request.into().getPath();
        Node<Name, Object> newParent = this.getNode((Request)request, intoCache, newParentPath);
        if (newParent == null) {
            return;
        }
        boolean useSameUuids = fromCache != intoCache;
        UUID uuid = (UUID)this.uuidFactory.create(node.get((Object)DnaLexicon.UUID));
        UUID newNodeUuid = useSameUuids ? uuid : this.uuidFactory.create();
        Name desiredName = request.desiredName();
        Path.Segment newSegment = this.copyNode(intoCache, node, newParent, desiredName, true, useSameUuids, newNodeUuid, null, this.getExecutionContext());
        Path newPath = this.pathFactory.create(newParentPath, new Path.Segment[]{newSegment});
        request.setActualLocations(Location.create((Path)nodePath), Location.create((Path)newPath));
    }

    public void process(DeleteBranchRequest request) {
        Cache<Name, Object> cache = this.getCache((Request)request, request.inWorkspace());
        if (cache == null) {
            return;
        }
        Path nodePath = request.at().getPath();
        Node<Name, Object> node = this.getNode((Request)request, cache, nodePath);
        if (node == null) {
            return;
        }
        Path.Segment nameOfRemovedNode = nodePath.getLastSegment();
        Node parent = node.getParent();
        if (cache.removeNode(node.getFqn())) {
            this.removeFromChildList(cache, (Node<Name, Object>)parent, nameOfRemovedNode, this.getExecutionContext());
            request.setActualLocationOfNode(Location.create((Path)nodePath));
        } else {
            String msg = JBossCacheConnectorI18n.unableToDeleteBranch.text(new Object[]{this.getSourceName(), request.inWorkspace(), nodePath});
            request.setError((Throwable)new RepositorySourceException(msg));
        }
    }

    public void process(MoveBranchRequest request) {
        Cache<Name, Object> cache = this.getCache((Request)request, request.inWorkspace());
        if (cache == null) {
            return;
        }
        Path nodePath = request.from().getPath();
        Node<Name, Object> node = this.getNode((Request)request, cache, nodePath);
        if (node == null) {
            return;
        }
        Path newParentPath = request.into().getPath();
        Node<Name, Object> newParent = this.getNode((Request)request, cache, newParentPath);
        if (newParent == null) {
            return;
        }
        Name desiredName = request.desiredName();
        Path.Segment newSegment = this.copyNode(cache, node, newParent, desiredName, true, true, null, null, this.getExecutionContext());
        Node oldParent = node.getParent();
        boolean removed = oldParent.removeChild(node.getFqn().getLastElement());
        assert (removed);
        Path.Segment nameOfRemovedNode = nodePath.getLastSegment();
        this.removeFromChildList(cache, (Node<Name, Object>)oldParent, nameOfRemovedNode, this.getExecutionContext());
        Path newPath = this.pathFactory.create(newParentPath, new Path.Segment[]{newSegment});
        request.setActualLocations(Location.create((Path)nodePath), Location.create((Path)newPath));
    }

    public void process(VerifyWorkspaceRequest request) {
        Cache<Name, Object> cache;
        String workspaceName = request.workspaceName();
        if (workspaceName == null) {
            workspaceName = this.defaultWorkspaceName;
        }
        if ((cache = this.workspaces.getWorkspace(workspaceName, false)) == null) {
            String msg = JBossCacheConnectorI18n.workspaceDoesNotExist.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
        } else {
            Fqn rootName = Fqn.root();
            UUID uuid = (UUID)this.uuidFactory.create(cache.get(rootName, (Object)DnaLexicon.UUID));
            if (uuid == null) {
                uuid = this.uuidFactory.create();
                cache.put(rootName, (Object)DnaLexicon.UUID, (Object)uuid);
            }
            request.setActualRootLocation(Location.create((Path)this.pathFactory.createRootPath()));
            request.setActualWorkspaceName(workspaceName);
        }
    }

    public void process(GetWorkspacesRequest request) {
        request.setAvailableWorkspaceNames(this.workspaces.getWorkspaceNames());
    }

    public void process(CreateWorkspaceRequest request) {
        String workspaceName = request.desiredNameOfNewWorkspace();
        if (!this.creatingWorkspacesAllowed) {
            String msg = JBossCacheConnectorI18n.unableToCreateWorkspaces.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidRequestException(msg));
            return;
        }
        Cache<Name, Object> cache = this.workspaces.getWorkspace(workspaceName, this.creatingWorkspacesAllowed);
        if (cache == null) {
            String msg = JBossCacheConnectorI18n.unableToCreateWorkspace.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
            return;
        }
        Fqn rootName = Fqn.root();
        UUID uuid = (UUID)this.uuidFactory.create(cache.get(rootName, (Object)DnaLexicon.UUID));
        if (uuid == null) {
            uuid = this.uuidFactory.create();
            cache.put(rootName, (Object)DnaLexicon.UUID, (Object)uuid);
        }
        request.setActualRootLocation(Location.create((Path)this.pathFactory.createRootPath()));
        request.setActualWorkspaceName(workspaceName);
    }

    public void process(CloneWorkspaceRequest request) {
        String fromWorkspaceName = request.nameOfWorkspaceToBeCloned();
        String toWorkspaceName = request.desiredNameOfTargetWorkspace();
        if (!this.creatingWorkspacesAllowed) {
            String msg = JBossCacheConnectorI18n.unableToCloneWorkspaces.text(new Object[]{this.getSourceName(), fromWorkspaceName, toWorkspaceName});
            request.setError((Throwable)new InvalidRequestException(msg));
            return;
        }
        Cache<Name, Object> fromCache = this.workspaces.getWorkspace(fromWorkspaceName, false);
        if (fromCache == null) {
            String msg = JBossCacheConnectorI18n.workspaceDoesNotExist.text(new Object[]{this.getSourceName(), fromWorkspaceName});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
            return;
        }
        Cache<Name, Object> intoCache = this.workspaces.createWorkspace(toWorkspaceName);
        if (intoCache == null) {
            String msg = JBossCacheConnectorI18n.workspaceAlreadyExists.text(new Object[]{this.getSourceName(), toWorkspaceName});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
            return;
        }
        Fqn rootName = Fqn.root();
        Node fromRoot = fromCache.getNode(rootName);
        Node intoRoot = intoCache.getNode(rootName);
        intoRoot.clearData();
        intoRoot.putAll(fromRoot.getData());
        ExecutionContext context = this.getExecutionContext();
        for (Node child : fromRoot.getChildren()) {
            this.copyNode(intoCache, (Node<Name, Object>)child, (Node<Name, Object>)intoRoot, null, true, true, null, null, context);
        }
        Path.Segment[] childNames = (Path.Segment[])fromRoot.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        intoRoot.put((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST, (Object)childNames);
    }

    public void process(DestroyWorkspaceRequest request) {
        if (!this.workspaces.removeWorkspace(request.workspaceName())) {
            String msg = JBossCacheConnectorI18n.workspaceDoesNotExist.text(new Object[]{request.workspaceName()});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
        }
    }

    protected Cache<Name, Object> getCache(Request request, String workspaceName) {
        Cache<Name, Object> cache;
        if (workspaceName == null) {
            workspaceName = this.defaultWorkspaceName;
        }
        if ((cache = this.workspaces.getWorkspace(workspaceName, this.creatingWorkspacesAllowed)) == null) {
            String msg = JBossCacheConnectorI18n.workspaceDoesNotExist.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
        }
        return cache;
    }

    protected Fqn<?> getFullyQualifiedName(Path path) {
        assert (path != null);
        return Fqn.fromList((List)path.getSegmentsList());
    }

    protected Fqn<?> getFullyQualifiedName(Path.Segment pathSegment) {
        assert (pathSegment != null);
        return Fqn.fromElements((Object[])new Path.Segment[]{pathSegment});
    }

    protected Path getPath(PathFactory factory, Fqn<?> fqn) {
        List segments = fqn.peekElements();
        return factory.create(factory.createRootPath(), (Iterable)segments);
    }

    protected Node<Name, Object> getNode(Request request, Cache<Name, Object> cache, Path path) {
        ExecutionContext context = this.getExecutionContext();
        if (path == null) {
            String msg = JBossCacheConnectorI18n.locationsMustHavePath.text(new Object[]{this.getSourceName(), request});
            request.setError((Throwable)new InvalidRequestException(msg));
            return null;
        }
        Fqn fqn = this.getFullyQualifiedName(path);
        Node node = cache.getNode(fqn);
        if (node == null) {
            String nodePath = path.getString(context.getNamespaceRegistry());
            Path lowestExisting = null;
            while (fqn != null) {
                node = cache.getNode(fqn = fqn.getParent());
                if (node == null) continue;
                lowestExisting = this.getPath(context.getValueFactories().getPathFactory(), fqn);
                fqn = null;
            }
            request.setError((Throwable)new PathNotFoundException(Location.create((Path)path), lowestExisting, JBossCacheConnectorI18n.nodeDoesNotExist.text(new Object[]{nodePath})));
            node = null;
        }
        return node;
    }

    protected Path.Segment copyNode(Cache<Name, Object> newCache, Node<Name, Object> original, Node<Name, Object> newParent, Name desiredName, boolean recursive, boolean reuseOriginalUuids, UUID uuidForCopyOfOriginal, AtomicInteger count, ExecutionContext context) {
        assert (original != null);
        assert (newParent != null);
        Path.Segment name = desiredName != null ? context.getValueFactories().getPathFactory().createSegment(desiredName) : (Path.Segment)original.getFqn().getLastElement();
        Path.Segment newSegment = this.updateChildList(newCache, newParent, name.getName(), context, true);
        Node copy = newParent.addChild(this.getFullyQualifiedName(newSegment));
        assert (this.checkChildren(newParent));
        copy.clearData();
        copy.putAll(original.getData());
        copy.remove((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        if (reuseOriginalUuids) {
            uuidForCopyOfOriginal = (UUID)this.uuidFactory.create(original.get((Object)DnaLexicon.UUID));
        }
        if (uuidForCopyOfOriginal == null) {
            uuidForCopyOfOriginal = this.uuidFactory.create();
        }
        copy.put((Object)DnaLexicon.UUID, (Object)uuidForCopyOfOriginal);
        if (count != null) {
            count.incrementAndGet();
        }
        if (recursive) {
            for (Node child : original.getChildren()) {
                this.copyNode(newCache, (Node<Name, Object>)child, (Node<Name, Object>)copy, null, true, reuseOriginalUuids, null, count, context);
            }
        }
        return newSegment;
    }

    protected Path.Segment updateChildList(Cache<Name, Object> cache, Node<Name, Object> parent, Name changedName, ExecutionContext context, boolean addChildWithName) {
        assert (parent != null);
        assert (changedName != null);
        assert (context != null);
        Set children = parent.getChildren();
        if (children.isEmpty() && !addChildWithName) {
            return null;
        }
        LinkedList<ChildInfo> childrenWithChangedName = new LinkedList<ChildInfo>();
        Path.Segment[] childNames = (Path.Segment[])parent.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        int index = 0;
        if (childNames != null) {
            for (Path.Segment childName : childNames) {
                if (childName.getName().equals(changedName)) {
                    ChildInfo info = new ChildInfo(childName, index);
                    childrenWithChangedName.add(info);
                }
                ++index;
            }
        }
        if (addChildWithName) {
            if (childNames == null) {
                childNames = new Path.Segment[1];
            } else {
                int numExisting = childNames.length;
                Path.Segment[] newChildNames = new Path.Segment[numExisting + 1];
                System.arraycopy(childNames, 0, newChildNames, 0, numExisting);
                childNames = newChildNames;
            }
            ChildInfo info = new ChildInfo(null, index);
            childrenWithChangedName.add(info);
            Path.Segment newSegment = context.getValueFactories().getPathFactory().createSegment(changedName);
            childNames[index++] = newSegment;
        }
        assert (childNames != null);
        assert (!childrenWithChangedName.isEmpty());
        if (childrenWithChangedName.size() == 1) {
            ChildInfo child = (ChildInfo)childrenWithChangedName.get(0);
            if (child.segment != null && child.segment.hasIndex()) {
                Path.Segment newSegment = context.getValueFactories().getPathFactory().createSegment(changedName);
                this.changeNodeName(cache, parent, child.segment, newSegment, context);
                childNames[child.childIndex] = newSegment;
            }
        } else {
            int i = 0;
            for (ChildInfo child : childrenWithChangedName) {
                Path.Segment newSegment;
                if (child.segment != null) {
                    newSegment = context.getValueFactories().getPathFactory().createSegment(changedName, i + 1);
                    this.changeNodeName(cache, parent, child.segment, newSegment, context);
                    childNames[child.childIndex] = newSegment;
                } else {
                    childNames[child.childIndex] = newSegment = context.getValueFactories().getPathFactory().createSegment(changedName, i + 1);
                }
                ++i;
            }
        }
        context.getLogger(((Object)((Object)this)).getClass()).trace("Updating child list of {0} to: {1}", new Object[]{parent.getFqn(), Arrays.asList(childNames)});
        parent.put((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST, (Object)childNames);
        if (addChildWithName) {
            return childNames[childNames.length - 1];
        }
        return null;
    }

    protected void removeFromChildList(Cache<Name, Object> cache, Node<Name, Object> parent, Path.Segment removedNode, ExecutionContext context) {
        assert (parent != null);
        assert (context != null);
        Set children = parent.getChildren();
        if (children.isEmpty()) {
            parent.put((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST, null);
            return;
        }
        Path.Segment[] childNames = (Path.Segment[])parent.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        assert (childNames != null);
        int snsIndex = removedNode.getIndex();
        int index = 0;
        Path.Segment[] newChildNames = new Path.Segment[childNames.length - 1];
        for (Path.Segment childName : childNames) {
            Path.Segment newSegment;
            if (!childName.getName().equals(removedNode.getName())) {
                newChildNames[index] = childName;
                ++index;
                continue;
            }
            if (childName.getIndex() < snsIndex) {
                newChildNames[index] = childName;
                ++index;
                continue;
            }
            if (childName.getIndex() == snsIndex) continue;
            newChildNames[index] = newSegment = context.getValueFactories().getPathFactory().createSegment(childName.getName(), childName.getIndex() - 1);
            this.changeNodeName(cache, parent, childName, newSegment, context);
            ++index;
        }
        parent.put((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST, (Object)newChildNames);
    }

    protected boolean checkChildren(Node<Name, Object> parent) {
        Path.Segment[] childNamesProperty = (Path.Segment[])parent.get((Object)JBossCacheLexicon.CHILD_PATH_SEGMENT_LIST);
        Set childNames = parent.getChildrenNames();
        boolean result = true;
        if (childNamesProperty.length != childNames.size()) {
            result = false;
        }
        for (int i = 0; i != childNamesProperty.length; ++i) {
            if (childNames.contains(childNamesProperty[i])) continue;
            result = false;
        }
        if (!result) {
            ArrayList<Path.Segment> names = new ArrayList<Path.Segment>();
            for (Object name : childNames) {
                names.add((Path.Segment)name);
            }
            Collections.sort(names);
            Logger.getLogger(((Object)((Object)this)).getClass()).trace("Child list on {0} is: {1}", new Object[]{parent.getFqn(), childNamesProperty});
            Logger.getLogger(((Object)((Object)this)).getClass()).trace("Children of {0} is: {1}", new Object[]{parent.getFqn(), names});
        }
        return result;
    }

    protected void changeNodeName(Cache<Name, Object> cache, Node<Name, Object> parent, Path.Segment existing, Path.Segment newSegment, ExecutionContext context) {
        assert (parent != null);
        assert (existing != null);
        assert (newSegment != null);
        assert (context != null);
        if (existing.equals(newSegment)) {
            return;
        }
        context.getLogger(((Object)((Object)this)).getClass()).trace("Renaming {0} to {1} under {2}", new Object[]{existing, newSegment, parent.getFqn()});
        Node existingChild = parent.getChild((Object)existing);
        assert (existingChild != null);
        Node newChild = parent.addChild(Fqn.fromElements((Object[])new Path.Segment[]{newSegment}));
        Fqn newChildFqn = newChild.getFqn();
        newChild.putAll(existingChild.getData());
        for (Node grandChild : existingChild.getChildren()) {
            cache.move(grandChild.getFqn(), newChildFqn);
        }
        parent.removeChild((Object)existing);
    }

    private static class ChildInfo {
        protected final Path.Segment segment;
        protected final int childIndex;

        protected ChildInfo(Path.Segment childSegment, int childIndex) {
            this.segment = childSegment;
            this.childIndex = childIndex;
        }
    }
}

