/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.Context;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.jbosscache.JBossCacheConnectorI18n;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JBossCacheWorkspaces {
    private final String sourceName;
    private final ConcurrentHashMap<String, Cache<Name, Object>> caches = new ConcurrentHashMap();
    private final Set<String> initialNames;
    private final CacheFactory<Name, Object> cacheFactory;
    private final String defaultCacheFactoryConfigurationName;
    private final Context jndi;
    private final Set<String> workspaceNamesForJndiClassCastProblems = new HashSet<String>();
    private final Set<String> workspaceNamesForConfigurationNameProblems = new HashSet<String>();
    private final Lock writeLock = new ReentrantLock();

    public JBossCacheWorkspaces(String sourceName, CacheFactory<Name, Object> cacheFactory, String defaultCacheFactoryConfigurationName, Set<String> initialNames, Context jndiContext) {
        assert (sourceName != null);
        this.sourceName = sourceName;
        if (initialNames == null) {
            initialNames = Collections.emptySet();
        }
        this.initialNames = initialNames;
        this.cacheFactory = cacheFactory;
        this.defaultCacheFactoryConfigurationName = defaultCacheFactoryConfigurationName;
        this.jndi = jndiContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<Name, Object> createWorkspace(String workspaceName) {
        try {
            Cache<Name, Object> existing;
            this.writeLock.lock();
            Cache<Name, Object> cache = this.caches.get(workspaceName);
            if (cache != null) {
                Cache<Name, Object> cache2 = null;
                return cache2;
            }
            if (this.initialNames.contains(workspaceName)) {
                Cache<Name, Object> cache3 = null;
                return cache3;
            }
            cache = this.findCacheInJndi(workspaceName);
            if (cache == null) {
                cache = this.createNewCache(workspaceName);
            }
            if (cache != null && (existing = this.caches.putIfAbsent(workspaceName, cache)) != null) {
                cache = existing;
            }
            Cache<Name, Object> cache4 = cache;
            return cache4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<Name, Object> getWorkspace(String workspaceName, boolean createIfMissing) {
        Cache<Name, Object> cache = this.caches.get(workspaceName);
        if (cache != null) {
            return cache;
        }
        try {
            Cache<Name, Object> existing;
            this.writeLock.lock();
            cache = this.caches.get(workspaceName);
            if (cache != null) {
                Cache<Name, Object> cache2 = cache;
                return cache2;
            }
            if (this.initialNames.contains(workspaceName)) {
                createIfMissing = true;
            }
            if (!createIfMissing) {
                Cache<Name, Object> cache3 = null;
                return cache3;
            }
            cache = this.findCacheInJndi(workspaceName);
            if (cache == null) {
                cache = this.createNewCache(workspaceName);
            }
            if (cache != null && (existing = this.caches.putIfAbsent(workspaceName, cache)) != null) {
                cache = existing;
            }
            Cache<Name, Object> cache4 = cache;
            return cache4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @GuardedBy(value="writeLock")
    protected Cache<Name, Object> findCacheInJndi(String workspaceName) {
        assert (workspaceName != null);
        if (this.jndi == null) {
            return null;
        }
        if ((workspaceName = workspaceName.trim()).length() != 0) {
            try {
                new URI(workspaceName.trim());
                Object object = null;
                try {
                    object = this.jndi.lookup(workspaceName);
                    if (object != null && object instanceof Cache) {
                        return (Cache)object;
                    }
                }
                catch (ClassCastException err) {
                    if (this.workspaceNamesForJndiClassCastProblems.add(workspaceName)) {
                        String className = object != null ? object.getClass().getName() : "null";
                        I18n msg = JBossCacheConnectorI18n.objectFoundInJndiWasNotCache;
                        Logger.getLogger(this.getClass()).warn(msg, new Object[]{workspaceName, this.sourceName, className});
                    }
                }
                catch (Throwable error) {
                    if (error instanceof RuntimeException) {
                        throw (RuntimeException)error;
                    }
                    throw new RepositorySourceException(this.sourceName, error);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @GuardedBy(value="writeLock")
    protected Cache<Name, Object> createNewCache(String workspaceName) {
        assert (workspaceName != null);
        if (this.cacheFactory == null) {
            return null;
        }
        try {
            return this.cacheFactory.createCache(workspaceName);
        }
        catch (ConfigurationException error) {
            block7: {
                I18n msg = JBossCacheConnectorI18n.workspaceNameWasNotValidConfiguration;
                Logger.getLogger(this.getClass()).debug(msg.text(new Object[]{workspaceName, error.getMessage()}), new Object[0]);
                if (this.defaultCacheFactoryConfigurationName != null) {
                    try {
                        return this.cacheFactory.createCache(this.defaultCacheFactoryConfigurationName);
                    }
                    catch (ConfigurationException error2) {
                        if (!this.workspaceNamesForConfigurationNameProblems.add(workspaceName)) break block7;
                        msg = JBossCacheConnectorI18n.defaultCacheFactoryConfigurationNameWasNotValidConfiguration;
                        Logger.getLogger(this.getClass()).debug(msg.text(new Object[]{workspaceName}), new Object[0]);
                    }
                }
            }
            return this.cacheFactory.createCache();
        }
    }

    public Set<String> getWorkspaceNames() {
        HashSet<String> names = new HashSet<String>();
        if (!this.initialNames.isEmpty()) {
            names.addAll(this.initialNames);
        }
        names.addAll(this.caches.keySet());
        return Collections.unmodifiableSet(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWorkspace(String workspaceName) {
        try {
            this.writeLock.lock();
            boolean removed = this.initialNames.remove(workspaceName);
            if (this.caches.remove(workspaceName) != null) {
                removed = true;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

