/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.jboss.dna.connector.jbosscache.JBossCacheRequestProcessor;
import org.jboss.dna.connector.jbosscache.JBossCacheSource;
import org.jboss.dna.connector.jbosscache.JBossCacheWorkspaces;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.request.Request;

public class JBossCacheConnection
implements RepositoryConnection {
    private final JBossCacheSource source;
    private final JBossCacheWorkspaces workspaces;

    JBossCacheConnection(JBossCacheSource source, JBossCacheWorkspaces workspaces) {
        assert (source != null);
        assert (workspaces != null);
        this.source = source;
        this.workspaces = workspaces;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Observer observer = this.source.getObserver();
        JBossCacheRequestProcessor processor = new JBossCacheRequestProcessor(this.getSourceName(), context, observer, this.workspaces, this.source.getNameOfDefaultWorkspace(), this.source.isCreatingWorkspacesAllowed());
        try {
            processor.process(request);
        }
        finally {
            processor.close();
        }
    }
}

