/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.util.UUID;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.map.AbstractMapWorkspace;
import org.jboss.dna.graph.connector.map.MapNode;
import org.jboss.dna.graph.connector.map.MapRepository;
import org.jboss.dna.graph.connector.map.MapWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheRepository
extends MapRepository {
    private final Cache<UUID, MapNode> cache;

    public JBossCacheRepository(String sourceName, UUID rootNodeUuid, Cache<UUID, MapNode> cache) {
        super(sourceName, rootNodeUuid, null);
        assert (cache != null);
        this.cache = cache;
        this.initialize();
    }

    public JBossCacheRepository(String sourceName, UUID rootNodeUuid, String defaultWorkspaceName, Cache<UUID, MapNode> cache) {
        super(sourceName, rootNodeUuid, defaultWorkspaceName);
        assert (cache != null);
        this.cache = cache;
        this.initialize();
    }

    protected MapWorkspace createWorkspace(ExecutionContext context, String name) {
        assert (name != null);
        assert (this.cache != null);
        Node newWorkspaceNode = this.cache.getRoot().addChild(Fqn.fromElements((Object[])new String[]{name}));
        return new Workspace(this, name, (Node<UUID, MapNode>)newWorkspaceNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Workspace
    extends AbstractMapWorkspace {
        private final Node<UUID, MapNode> workspaceNode;

        public Workspace(MapRepository repository, String name, Node<UUID, MapNode> workspaceNode) {
            super(repository, name);
            this.workspaceNode = workspaceNode;
            this.initialize();
        }

        protected void addNodeToMap(MapNode node) {
            assert (node != null);
            this.workspaceNode.put((Object)node.getUuid(), (Object)node);
        }

        protected MapNode removeNodeFromMap(UUID nodeUuid) {
            assert (nodeUuid != null);
            return (MapNode)this.workspaceNode.remove((Object)nodeUuid);
        }

        protected void removeAllNodesFromMap() {
            this.workspaceNode.clearData();
        }

        public MapNode getNode(UUID nodeUuid) {
            assert (nodeUuid != null);
            return (MapNode)this.workspaceNode.get((Object)nodeUuid);
        }
    }
}

