/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.jdbc.JdbcMetadataI18n;
import org.jboss.dna.connector.jdbc.JdbcRequestProcesor;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.connector.RepositorySourceListener;
import org.jboss.dna.graph.request.Request;

public class JdbcConnection
implements RepositoryConnection {
    protected Logger log = Logger.getLogger(this.getClass());
    private final String name;
    private final CachePolicy cachePolicy;
    private final CopyOnWriteArrayList<RepositorySourceListener> listeners = new CopyOnWriteArrayList();
    private final Connection connection;
    private final UUID rootNodeUuid;

    JdbcConnection(String sourceName, CachePolicy cachePolicy, Connection connection, UUID rootNodeUuid) {
        assert (sourceName != null);
        assert (connection != null);
        assert (rootNodeUuid != null);
        this.name = sourceName;
        this.cachePolicy = cachePolicy;
        this.connection = connection;
        this.rootNodeUuid = rootNodeUuid;
    }

    public String getSourceName() {
        return this.name;
    }

    public void setListener(RepositorySourceListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.cachePolicy;
    }

    public XAResource getXAResource() {
        if (this.connection instanceof XAConnection) {
            try {
                return ((XAConnection)((Object)this.connection)).getXAResource();
            }
            catch (SQLException e) {
                this.log.error((Throwable)e, JdbcMetadataI18n.unableToGetXAResource, new Object[]{this.getSourceName()});
                return null;
            }
        }
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Throwable)e, "{0}: Unable to check database connection due to error.", new Object[]{this.getSourceName()});
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        JdbcRequestProcesor proc = new JdbcRequestProcesor(this.getSourceName(), context, this.connection, this.rootNodeUuid);
        try {
            proc.process(request);
        }
        finally {
            proc.close();
        }
    }

    public void close() {
        block3: {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Throwable)e, "{0}: Unable to close database connection due to error.", new Object[]{this.getSourceName()});
            }
        }
    }
}

