/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.svn.SVNRepositoryRequestProcessor;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.connector.RepositorySourceListener;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.request.Request;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNRepositoryConnection
implements RepositoryConnection {
    protected static final RepositorySourceListener NO_OP_LISTENER = new RepositorySourceListener(){

        public void notify(String sourceName, Object ... events) {
        }
    };
    private final String sourceName;
    private final CachePolicy cachePolicy;
    private final SVNRepository repository;
    private final boolean updatesAllowed;
    private RepositorySourceListener listener = NO_OP_LISTENER;

    public SVNRepositoryConnection(String sourceName, CachePolicy cachePolicy, boolean updatesAllowed, SVNRepository repository) {
        CheckArg.isNotNull((Object)repository, (String)"repository");
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        SVNNodeKind nodeKind = null;
        try {
            nodeKind = repository.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                SVNErrorMessage error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"No entry at URL ''{0}''", (Object)repository.getLocation().getPath());
                throw new SVNException(error);
            }
            if (nodeKind == SVNNodeKind.UNKNOWN) {
                SVNErrorMessage error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)repository.getLocation().getPath());
                throw new SVNException(error);
            }
            if (nodeKind == SVNNodeKind.FILE) {
                SVNErrorMessage error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)repository.getLocation().getPath());
                throw new SVNException(error);
            }
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
        this.sourceName = sourceName;
        this.cachePolicy = cachePolicy;
        this.repository = repository;
        this.updatesAllowed = updatesAllowed;
    }

    SVNRepository getRepository() {
        return this.repository;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.cachePolicy;
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        try {
            this.repository.getRepositoryRoot(true);
        }
        catch (SVNException e) {
            return false;
        }
        return true;
    }

    public void setListener(RepositorySourceListener listener) {
        this.listener = listener != null ? listener : NO_OP_LISTENER;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propertyFactory = context.getPropertyFactory();
        SVNRepositoryRequestProcessor processor = new SVNRepositoryRequestProcessor(this.getSourceName(), context, this.repository, this.updatesAllowed);
        try {
            processor.process(request);
        }
        finally {
            processor.close();
        }
    }

    protected RepositorySourceListener getListener() {
        return this.listener;
    }
}

