/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.scm.ScmAction;
import org.jboss.dna.connector.scm.ScmActionFactory;
import org.jboss.dna.connector.svn.SVNActionExecutor;
import org.jboss.dna.connector.svn.SVNRepositoryConnectorI18n;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.JcrNtLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.Binary;
import org.jboss.dna.graph.property.DateTimeFactory;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.NameFactory;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidRequestException;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.RenameNodeRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositoryRequestProcessor
extends RequestProcessor
implements ScmActionFactory {
    protected static final String BACK_SLASH = "/";
    private final String defaultNamespaceUri = this.getExecutionContext().getNamespaceRegistry().getDefaultNamespaceUri();
    private final boolean updatesAllowed;
    private SVNRepository repository;
    protected final Logger logger;

    protected SVNRepositoryRequestProcessor(String sourceName, ExecutionContext context, SVNRepository repository, boolean updatesAllowed) {
        super(sourceName, context);
        this.updatesAllowed = updatesAllowed;
        this.repository = repository;
        this.logger = this.getExecutionContext().getLogger(this.getClass());
    }

    public void process(CopyBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        this.verifyUpdatesAllowed();
    }

    public void process(CreateNodeRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        this.verifyUpdatesAllowed();
        Location myLocation = request.under();
        Path parent = this.getPathFor(myLocation, (Request)request);
        try {
            String root = parent.getString(this.getExecutionContext().getNamespaceRegistry());
            SVNNodeKind rootKind = this.repository.checkPath(root, -1L);
            if (rootKind == SVNNodeKind.UNKNOWN) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is unknown in the repository", (Object)root);
                SVNException ex = new SVNException(err);
                request.setError((Throwable)ex);
            } else if (rootKind == SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is missing in the repository", (Object)root);
                SVNException ex = new SVNException(err);
                request.setError((Throwable)ex);
            } else if (rootKind == SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"pretended root item with name '{0}' is a file", (Object)root);
                SVNException ex = new SVNException(err);
                request.setError((Throwable)ex);
            } else if (rootKind == SVNNodeKind.DIR) {
                Object[] objs;
                Collection childNodeProperties = request.properties();
                for (Object object : objs = this.values(childNodeProperties)) {
                    if (object instanceof Name && ((Name)object).compareTo((Object)JcrNtLexicon.FOLDER) == 0) {
                        String folderName = request.named().getString(this.getExecutionContext().getNamespaceRegistry());
                        if (root.length() == 1 && root.charAt(0) == '/') {
                            this.mkdir("", folderName, request.toString());
                            continue;
                        }
                        if (root.length() <= 1 || root.charAt(0) != '/') continue;
                        this.mkdir(root.substring(1), folderName, request.toString());
                        continue;
                    }
                    if (!(object instanceof Name) || ((Name)object).compareTo((Object)JcrNtLexicon.FILE) != 0) continue;
                    String fileName = request.named().getString(this.getExecutionContext().getNamespaceRegistry());
                    byte[] content = this.getContent(objs);
                    this.newFile(root, fileName, content, request.toString());
                }
            }
        }
        catch (SVNException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(DeleteBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        this.verifyUpdatesAllowed();
    }

    public void process(MoveBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        this.verifyUpdatesAllowed();
    }

    public void process(ReadAllChildrenRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location myLocation = request.of();
        Path nodePath = this.getPathFor(myLocation, (Request)request);
        try {
            SVNNodeKind kind = this.validateNodeKind(nodePath);
            String requestedNodePath = nodePath.getString(this.getExecutionContext().getNamespaceRegistry());
            if (kind == SVNNodeKind.FILE) {
                SVNDirEntry entry = this.getEntryInfo(requestedNodePath);
                if (!nodePath.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                    String localName = entry.getName();
                    Name childName = this.nameFactory().create(this.defaultNamespaceUri, localName);
                    String url = entry.getURL().toString();
                    Property idProperty = this.propertyFactory().create(childName, new Object[]{url});
                    request.addChild(Location.create((Path)this.pathFactory().create(nodePath, new Name[]{JcrLexicon.CONTENT}), (Property)idProperty));
                }
            } else if (kind == SVNNodeKind.DIR) {
                Collection dirEntries = this.getRepository().getDir(requestedNodePath, -1L, null, (Collection)null);
                for (SVNDirEntry dirEntry : dirEntries) {
                    Property idProperty;
                    String url;
                    String localName;
                    if (dirEntry.getKind() == SVNNodeKind.FILE) {
                        localName = dirEntry.getName();
                        Path newPath = (Path)this.pathFactory().create(requestedNodePath + BACK_SLASH + localName);
                        if (newPath.getLastSegment().getName().equals(JcrLexicon.CONTENT)) continue;
                        Name childName = this.nameFactory().create(this.defaultNamespaceUri, localName);
                        url = dirEntry.getURL().toString();
                        idProperty = this.propertyFactory().create(childName, new Object[]{url});
                        Location location = Location.create((Path)this.pathFactory().create(newPath, new Name[]{JcrLexicon.CONTENT}), (Property)idProperty);
                        request.addChild(location);
                        continue;
                    }
                    if (dirEntry.getKind() != SVNNodeKind.DIR) continue;
                    localName = dirEntry.getName();
                    Name childName = this.nameFactory().create(this.defaultNamespaceUri, localName);
                    Path childPath = this.pathFactory().create(nodePath, new Name[]{childName});
                    url = dirEntry.getURL().toString();
                    idProperty = this.propertyFactory().create(childName, new Object[]{url});
                    request.addChild(childPath, idProperty);
                }
            }
            request.setActualLocationOfNode(myLocation);
        }
        catch (SVNException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(ReadAllPropertiesRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location myLocation = request.at();
        Path nodePath = this.getPathFor(myLocation, (Request)request);
        if (nodePath.isRoot()) {
            request.setActualLocationOfNode(myLocation);
            return;
        }
        try {
            if (nodePath.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                SVNDirEntry entry;
                Date lastModified;
                Path parent = nodePath.getParent();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                SVNProperties fileProperties = new SVNProperties();
                this.getData(parent.getString(this.getExecutionContext().getNamespaceRegistry()), fileProperties, os);
                Property ntResourceproperty = this.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE});
                request.addProperty(ntResourceproperty);
                String mimeType = fileProperties.getStringValue("svn:mime-type");
                if (mimeType != null) {
                    Property jcrMimeTypeProperty = this.propertyFactory().create(JcrLexicon.MIMETYPE, new Object[]{mimeType});
                    request.addProperty(jcrMimeTypeProperty);
                }
                if ((lastModified = (entry = this.getEntryInfo(parent.getString(this.getExecutionContext().getNamespaceRegistry()))).getDate()) != null) {
                    Property jcrLastModifiedProperty = this.propertyFactory().create(JcrLexicon.LAST_MODIFIED, new Object[]{this.dateFactory().create(lastModified)});
                    request.addProperty(jcrLastModifiedProperty);
                }
                if (os.toByteArray().length > 0) {
                    Property jcrDataProperty = this.propertyFactory().create(JcrLexicon.DATA, new Object[]{this.binaryFactory().create(os.toByteArray())});
                    request.addProperty(jcrDataProperty);
                }
            } else {
                SVNNodeKind kind = this.validateNodeKind(nodePath);
                if (kind == SVNNodeKind.FILE) {
                    Property ntFileProperty = this.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE});
                    request.addProperty(ntFileProperty);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    SVNProperties fileProperties = new SVNProperties();
                    this.getData(nodePath.getString(this.getExecutionContext().getNamespaceRegistry()), fileProperties, os);
                    String created = fileProperties.getStringValue("svn:entry:committed-date");
                    if (created != null) {
                        Property jcrCreatedProperty = this.propertyFactory().create(JcrLexicon.CREATED, new Object[]{created});
                        request.addProperty(jcrCreatedProperty);
                    }
                } else if (kind == SVNNodeKind.DIR) {
                    Property jcrPrimaryTypeProp = this.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER});
                    request.addProperty(jcrPrimaryTypeProp);
                    SVNDirEntry dirEntry = this.getEntryInfo(nodePath.getString(this.getExecutionContext().getNamespaceRegistry()));
                    Property jcrCreatedProp = this.propertyFactory().create(JcrLexicon.CREATED, new Object[]{this.dateFactory().create(dirEntry.getDate())});
                    request.addProperty(jcrCreatedProp);
                }
            }
            request.setActualLocationOfNode(myLocation);
        }
        catch (SVNException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(RenameNodeRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        this.verifyUpdatesAllowed();
        super.process(request);
    }

    public void process(UpdatePropertiesRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        this.verifyUpdatesAllowed();
    }

    public void process(VerifyWorkspaceRequest request) {
        String workspaceName = request.workspaceName();
        if (workspaceName == null) {
            workspaceName = "default";
        }
        request.setActualRootLocation(Location.create((Path)this.pathFactory().createRootPath()));
        request.setActualWorkspaceName(workspaceName);
    }

    public void process(GetWorkspacesRequest request) {
        request.setAvailableWorkspaceNames(Collections.singleton("default"));
    }

    public void process(CreateWorkspaceRequest request) {
        String msg = SVNRepositoryConnectorI18n.sourceDoesNotSupportCreatingWorkspaces.text(new Object[]{this.getSourceName()});
        request.setError((Throwable)new InvalidRequestException(msg));
    }

    public void process(CloneWorkspaceRequest request) {
        String msg = SVNRepositoryConnectorI18n.sourceDoesNotSupportCloningWorkspaces.text(new Object[]{this.getSourceName()});
        request.setError((Throwable)new InvalidRequestException(msg));
    }

    public void process(DestroyWorkspaceRequest request) {
        String msg = SVNRepositoryConnectorI18n.sourceDoesNotSupportDeletingWorkspaces.text(new Object[]{this.getSourceName()});
        request.setError((Throwable)new InvalidRequestException(msg));
    }

    protected void verifyUpdatesAllowed() {
        if (!this.updatesAllowed) {
            throw new InvalidRequestException(SVNRepositoryConnectorI18n.sourceIsReadOnly.text(new Object[]{this.getSourceName()}));
        }
    }

    protected NameFactory nameFactory() {
        return this.getExecutionContext().getValueFactories().getNameFactory();
    }

    protected PathFactory pathFactory() {
        return this.getExecutionContext().getValueFactories().getPathFactory();
    }

    protected PropertyFactory propertyFactory() {
        return this.getExecutionContext().getPropertyFactory();
    }

    protected DateTimeFactory dateFactory() {
        return this.getExecutionContext().getValueFactories().getDateFactory();
    }

    protected ValueFactory<Binary> binaryFactory() {
        return this.getExecutionContext().getValueFactories().getBinaryFactory();
    }

    protected Path getPathFor(Location location, Request request) {
        Path path = location.getPath();
        if (path == null) {
            I18n msg = SVNRepositoryConnectorI18n.locationInRequestMustHavePath;
            throw new RepositorySourceException(this.getSourceName(), msg.text(new Object[]{this.getSourceName(), request}));
        }
        return path;
    }

    protected void getData(String path, SVNProperties properties, OutputStream os) throws SVNException {
        this.getRepository().getFile(path, -1L, properties, os);
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    protected SVNNodeKind validateNodeKind(Path requestedPath) {
        String myPath = requestedPath.getString(this.getExecutionContext().getNamespaceRegistry());
        SVNNodeKind kind = null;
        try {
            kind = this.getRepository().checkPath(myPath, -1L);
            if (kind == SVNNodeKind.NONE) {
                throw new PathNotFoundException(Location.create((Path)requestedPath), null, SVNRepositoryConnectorI18n.nodeDoesNotExist.text(new Object[]{myPath}));
            }
            if (kind == SVNNodeKind.UNKNOWN) {
                throw new PathNotFoundException(Location.create((Path)requestedPath), null, SVNRepositoryConnectorI18n.nodeIsActuallyUnknow.text(new Object[]{myPath}));
            }
        }
        catch (SVNException e) {
            throw new RepositorySourceException(this.getSourceName(), SVNRepositoryConnectorI18n.connectingFailureOrUserAuthenticationProblem.text(new Object[]{this.getSourceName()}));
        }
        return kind;
    }

    protected SVNDirEntry getEntryInfo(String path) {
        assert (path != null);
        SVNDirEntry entry = null;
        try {
            entry = this.getRepository().info(path, -1L);
        }
        catch (SVNException e) {
            throw new RepositorySourceException(this.getSourceName(), SVNRepositoryConnectorI18n.connectingFailureOrUserAuthenticationProblem.text(new Object[]{this.getSourceName()}));
        }
        return entry;
    }

    protected static void openDirectories(ISVNEditor editor, String rootPath) throws SVNException {
        String dir;
        assert (rootPath != null);
        int pos = rootPath.indexOf(47, 0);
        while (pos != -1) {
            dir = rootPath.substring(0, pos);
            editor.openDir(dir, -1L);
            pos = rootPath.indexOf(47, pos + 1);
        }
        dir = rootPath.substring(0, rootPath.length());
        editor.openDir(dir, -1L);
    }

    protected static void closeDirectories(ISVNEditor editor, String path) throws SVNException {
        int length = path.length() - 1;
        int pos = path.lastIndexOf(47, length);
        editor.closeDir();
        while (pos != -1) {
            editor.closeDir();
            pos = path.lastIndexOf(47, pos - 1);
        }
    }

    public long getLatestRevision() throws Exception {
        try {
            return this.repository.getLatestRevision();
        }
        catch (SVNException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void addDirEntry(SVNRepository repository, String root, String child, String message) throws SVNException {
        assert (root.trim().length() != 0);
        SVNNodeKind rootKind = repository.checkPath(root, -1L);
        if (rootKind == SVNNodeKind.UNKNOWN) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is unknown in the repository", (Object)root);
            throw new SVNException(err);
        }
        if (rootKind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is missing in the repository", (Object)root);
            throw new SVNException(err);
        }
        if (rootKind == SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is a file, you need a directory", (Object)root);
            throw new SVNException(err);
        }
        if (rootKind == SVNNodeKind.DIR) {
            ISVNEditor editor = repository.getCommitEditor(message, null, true, null);
            if (root.length() == 1 && root.charAt(0) == '/') {
                this.addProcess(editor, root, "", child);
            } else {
                String rootPath = root.substring(1);
                this.addProcess(editor, rootPath, null, child);
            }
        }
    }

    private void addProcess(ISVNEditor editor, String rootPath, String editedRoot, String childSegmentName) throws SVNException {
        SVNRepositoryRequestProcessor.openDirectories(editor, editedRoot);
        SVNNodeKind childKind = this.repository.checkPath(childSegmentName, -1L);
        if (childKind == SVNNodeKind.NONE) {
            editor.addDir(childSegmentName, null, -1L);
            SVNRepositoryRequestProcessor.closeDirectories(editor, childSegmentName);
            if (editedRoot != null) {
                SVNRepositoryRequestProcessor.closeDirectories(editor, editedRoot);
            } else {
                SVNRepositoryRequestProcessor.closeDirectories(editor, rootPath);
            }
        } else {
            SVNRepositoryRequestProcessor.closeDirectories(editor, childSegmentName);
            if (editedRoot != null) {
                SVNRepositoryRequestProcessor.closeDirectories(editor, editedRoot);
            } else {
                SVNRepositoryRequestProcessor.closeDirectories(editor, rootPath);
            }
        }
    }

    private void mkdir(String root, String childName, String message) throws SVNException {
        SVNNodeKind childKind = this.repository.checkPath(childName, -1L);
        if (childKind != SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Item with name '{0}' can't be created", (Object)childName);
            throw new SVNException(err);
        }
        ScmAction addNodeAction = this.addDirectory(root, childName);
        SVNActionExecutor executor = new SVNActionExecutor(this.repository);
        executor.execute(addNodeAction, message);
    }

    private void newFile(String path, String file, byte[] content, String message) throws SVNException {
        SVNNodeKind childKind = this.repository.checkPath(file, -1L);
        if (childKind != SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Item with name '{0}' can't be created (already exist)", (Object)file);
            throw new SVNException(err);
        }
        ScmAction addFileNodeAction = this.addFile(path, file, content);
        SVNActionExecutor executor = new SVNActionExecutor(this.repository);
        executor.execute(addFileNodeAction, message);
    }

    @Override
    public ScmAction addDirectory(String root, String path) {
        return new AddDirectory(root, path);
    }

    @Override
    public ScmAction addFile(String path, String file, byte[] content) {
        return new AddFile(path, file, content);
    }

    @Override
    public ScmAction copyDirectory(String path, String newPath, long revision) {
        return null;
    }

    @Override
    public ScmAction deleteDirectory(String path) {
        return null;
    }

    @Override
    public ScmAction deleteFile(String path, String file) {
        return null;
    }

    private byte[] getContent(Object[] objs) {
        byte[] content = null;
        for (Object object : objs) {
            if (object == null || !(object instanceof Binary)) continue;
            Binary buf = (Binary)object;
            content = buf.getBytes();
        }
        return content;
    }

    private Object[] values(Collection<Property> childNodeProperties) {
        HashSet<Object> result = new HashSet<Object>();
        for (Property property : childNodeProperties) {
            result.add(property.getFirstValue());
        }
        return result.toArray();
    }

    public static class AddFile
    implements ScmAction {
        private String path;
        private String file;
        private byte[] content;

        public AddFile(String path, String file, byte[] content) {
            this.path = path;
            this.file = file;
            this.content = content;
        }

        public void applyAction(Object context) throws Exception {
            ISVNEditor editor = (ISVNEditor)context;
            SVNRepositoryRequestProcessor.openDirectories(editor, this.path);
            editor.addFile(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, null, -1L);
            editor.applyTextDelta(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String checksum = deltaGenerator.sendDelta(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, (InputStream)new ByteArrayInputStream(this.content), (ISVNDeltaConsumer)editor, true);
            editor.closeFile(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, checksum);
            SVNRepositoryRequestProcessor.closeDirectories(editor, this.path);
        }
    }

    public static class AddDirectory
    implements ScmAction {
        private String root;
        private String path;

        public AddDirectory(String root, String path) {
            this.root = root;
            this.path = path;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            SVNRepositoryRequestProcessor.openDirectories(editor, this.root);
            String[] paths = this.path.split(SVNRepositoryRequestProcessor.BACK_SLASH);
            String newPath = this.root;
            int length = paths.length;
            for (int i = 0; i < length; ++i) {
                newPath = newPath.length() != 0 ? newPath + SVNRepositoryRequestProcessor.BACK_SLASH + paths[i] : paths[i];
                editor.addDir(newPath, null, -1L);
            }
            SVNRepositoryRequestProcessor.closeDirectories(editor, this.path);
            SVNRepositoryRequestProcessor.closeDirectories(editor, this.root);
        }
    }
}

