/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.svn.SVNProtocol;
import org.jboss.dna.connector.svn.SVNRepositoryConnection;
import org.jboss.dna.connector.svn.SVNRepositoryConnectorI18n;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.RepositorySourceCapabilities;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = false;
    protected static final boolean SUPPORTS_CREATING_WORKSPACES = false;
    protected static final boolean SUPPORTS_REFERENCES = false;
    public static final boolean DEFAULT_SUPPORTS_UPDATES = true;
    public static final int DEFAULT_CACHE_TIME_TO_LIVE_IN_SECONDS = 300;
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String DEFAULT_CACHE_POLICY = "defaultCachePolicy";
    protected static final String SVN_REPOS_JNDI_NAME = "svnReposJndiName";
    protected static final String SVN_REPOS_FACTORY_JNDI_NAME = "svnReposFactoryJndiName";
    protected static final String SVN_URL = "svnURL";
    protected static final String SVN_USERNAME = "svnUsername";
    protected static final String SVN_PASSWORD = "svnPassword";
    protected static final String RETRY_LIMIT = "retryLimit";
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private String name;
    private String svnURL;
    private String svnUsername;
    private String svnPassword;
    private CachePolicy defaultCachePolicy;
    private RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(false, true, true, false, false);
    private transient Context jndiContext;
    private transient RepositoryContext repositoryContext;
    private transient SVNRepository svnRepository;

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public String getName() {
        return this.name;
    }

    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public synchronized void setName(String name) {
        if (this.name == name || this.name != null && this.name.equals(name)) {
            return;
        }
        this.name = name;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public synchronized void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        if (this.defaultCachePolicy == defaultCachePolicy || this.defaultCachePolicy != null && this.defaultCachePolicy.equals(defaultCachePolicy)) {
            return;
        }
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public String getSVNURL() {
        return this.svnURL;
    }

    public void setSVNURL(String url) {
        CheckArg.isNotEmpty((String)url, (String)"SVNURL");
        this.svnURL = url;
    }

    public String getSVNUsername() {
        return this.svnUsername;
    }

    public void setSVNUsername(String username) {
        this.svnUsername = username;
    }

    public String getSVNPassword() {
        return this.svnPassword;
    }

    public void setSVNPassword(String password) {
        this.svnPassword = password;
    }

    public boolean getSupportsUpdates() {
        return this.capabilities.supportsUpdates();
    }

    public synchronized void setSupportsUpdates(boolean supportsUpdates) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), supportsUpdates, this.capabilities.supportsEvents(), this.capabilities.supportsCreatingWorkspaces(), this.capabilities.supportsReferences());
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        block7: {
            if (this.getName() == null) {
                I18n msg = SVNRepositoryConnectorI18n.propertyIsRequired;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
            }
            SVNURL svnURL = null;
            if (this.svnRepository == null) {
                try {
                    svnURL = SVNURL.parseURIDecoded((String)this.getSVNURL());
                    String usedProtocol = this.getSVNURL().substring(0, this.getSVNURL().indexOf(":"));
                    if (usedProtocol.equals(SVNProtocol.SVN.value()) || usedProtocol.equals(SVNProtocol.SVN_SSH.value())) {
                        SVNRepositoryFactoryImpl.setup();
                        this.svnRepository = SVNRepositoryFactory.create((SVNURL)svnURL);
                        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)this.getSVNUsername(), (String)this.getSVNPassword());
                        this.svnRepository.setAuthenticationManager(authManager);
                        break block7;
                    }
                    if (usedProtocol.equals(SVNProtocol.HTTP.value()) || usedProtocol.equals(SVNProtocol.HTTPS.value())) {
                        DAVRepositoryFactory.setup();
                        this.svnRepository = DAVRepositoryFactory.create((SVNURL)svnURL);
                        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)this.getSVNUsername(), (String)this.getSVNPassword());
                        this.svnRepository.setAuthenticationManager(authManager);
                        break block7;
                    }
                    if (usedProtocol.equals(SVNProtocol.FILE.value())) {
                        FSRepositoryFactory.setup();
                        this.svnRepository = FSRepositoryFactory.create((SVNURL)svnURL);
                        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)this.getSVNUsername(), (String)this.getSVNPassword());
                        this.svnRepository.setAuthenticationManager(authManager);
                        break block7;
                    }
                    throw new RepositorySourceException(this.getSVNURL(), "Protocol is not supported by this connector or there is problem in the svn url");
                }
                catch (SVNException ex) {
                    I18n msg = SVNRepositoryConnectorI18n.propertyIsRequired;
                    throw new RepositorySourceException(this.getSVNURL(), msg.text(new Object[]{this.getSVNURL()}), (Throwable)ex);
                }
            }
        }
        boolean supportsUpdates = this.getSupportsUpdates();
        return new SVNRepositoryConnection(this.getName(), this.getDefaultCachePolicy(), supportsUpdates, this.svnRepository);
    }

    protected Context getContext() {
        return this.jndiContext;
    }

    protected synchronized void setContext(Context context) {
        this.jndiContext = context;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SVNRepositorySource) {
            SVNRepositorySource that = (SVNRepositorySource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        if (this.getSVNURL() != null) {
            ref.add(new StringRefAddr(SVN_URL, this.getSVNURL()));
        }
        if (this.getSVNUsername() != null) {
            ref.add(new StringRefAddr(SVN_USERNAME, this.getSVNUsername()));
        }
        if (this.getSVNPassword() != null) {
            ref.add(new StringRefAddr(SVN_PASSWORD, this.getSVNPassword()));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = SVNRepositoryConnectorI18n.errorSerializingCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String svnURL = (String)values.get(SVN_URL);
            String svnUsername = (String)values.get(SVN_USERNAME);
            String svnPassword = (String)values.get(SVN_PASSWORD);
            Object defaultCachePolicy = values.get(DEFAULT_CACHE_POLICY);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            SVNRepositorySource source = new SVNRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (svnURL != null) {
                source.setSVNURL(svnURL);
            }
            if (svnUsername != null) {
                source.setSVNUsername(svnUsername);
            }
            if (svnPassword != null) {
                source.setSVNPassword(svnPassword);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }
}

