/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.connector.svn.RepositoryAccessData;
import org.jboss.dna.connector.svn.SVNRepositoryConnection;
import org.jboss.dna.connector.svn.SVNRepositoryConnectorI18n;
import org.jboss.dna.connector.svn.SVNRepositoryUtil;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.RepositorySourceCapabilities;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.tmatesoft.svn.core.io.SVNRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SVNRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String SVN_REPOSITORY_ROOT_URL = "repositoryRootURL";
    protected static final String SVN_USERNAME = "username";
    protected static final String SVN_PASSWORD = "password";
    protected static final String CACHE_TIME_TO_LIVE_IN_MILLISECONDS = "cacheTimeToLiveInMilliseconds";
    protected static final String RETRY_LIMIT = "retryLimit";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = false;
    protected static final boolean DEFAULT_SUPPORTS_CREATING_WORKSPACES = true;
    public static final boolean DEFAULT_SUPPORTS_UPDATES = false;
    protected static final boolean SUPPORTS_REFERENCES = false;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final int DEFAULT_CACHE_TIME_TO_LIVE_IN_SECONDS = 300;
    private volatile String name;
    private volatile String repositoryRootURL;
    private volatile String username;
    private volatile String password;
    private volatile int retryLimit = 0;
    private volatile int cacheTimeToLiveInMilliseconds = 300000;
    private volatile String defaultWorkspace;
    private volatile String[] predefinedWorkspaces = new String[0];
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(false, false, true, true, false);
    private transient CachePolicy cachePolicy;
    private transient CopyOnWriteArraySet<String> availableWorspaceNames;

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        this.name = name;
    }

    public String getRepositoryRootURL() {
        return this.repositoryRootURL;
    }

    public void setRepositoryRootURL(String url) {
        CheckArg.isNotEmpty((String)url, (String)"RepositoryRootURL");
        this.repositoryRootURL = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean getSupportsUpdates() {
        return this.capabilities.supportsUpdates();
    }

    public String getDirectoryForDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public synchronized void setDirectoryForDefaultWorkspace(String pathToDirectoryForDefaultWorkspace) {
        this.defaultWorkspace = pathToDirectoryForDefaultWorkspace;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), this.capabilities.supportsUpdates(), this.capabilities.supportsEvents(), allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int limit) {
        this.retryLimit = limit < 0 ? 0 : limit;
    }

    public int getCacheTimeToLiveInMilliseconds() {
        return this.cacheTimeToLiveInMilliseconds;
    }

    public synchronized void setCacheTimeToLiveInMilliseconds(int cacheTimeToLive) {
        if (cacheTimeToLive < 0) {
            cacheTimeToLive = 300;
        }
        this.cacheTimeToLiveInMilliseconds = cacheTimeToLive;
        this.cachePolicy = this.cacheTimeToLiveInMilliseconds > 0 ? new SVNRepositoryCachePolicy(this.cacheTimeToLiveInMilliseconds) : null;
    }

    public synchronized void initialize(RepositoryContext context) throws RepositorySourceException {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SVNRepositorySource) {
            SVNRepositorySource that = (SVNRepositorySource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        if (this.getRepositoryRootURL() != null) {
            ref.add(new StringRefAddr(SVN_REPOSITORY_ROOT_URL, this.getRepositoryRootURL()));
        }
        if (this.getUsername() != null) {
            ref.add(new StringRefAddr(SVN_USERNAME, this.getUsername()));
        }
        if (this.getPassword() != null) {
            ref.add(new StringRefAddr(SVN_PASSWORD, this.getPassword()));
        }
        ref.add(new StringRefAddr(CACHE_TIME_TO_LIVE_IN_MILLISECONDS, Integer.toString(this.getCacheTimeToLiveInMilliseconds())));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDirectoryForDefaultWorkspace()));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, String> values = new HashMap<String, String>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                RefAddr subref = en.nextElement();
                if (!(subref instanceof StringRefAddr)) continue;
                String key = subref.getType();
                Object value = subref.getContent();
                if (value == null) continue;
                values.put(key, value.toString());
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String repositoryRootURL = (String)values.get(SVN_REPOSITORY_ROOT_URL);
            String username = (String)values.get(SVN_USERNAME);
            String password = (String)values.get(SVN_PASSWORD);
            String cacheTtlInMillis = (String)values.get(CACHE_TIME_TO_LIVE_IN_MILLISECONDS);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
            String createWorkspaces = (String)values.get(ALLOW_CREATING_WORKSPACES);
            String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            SVNRepositorySource source = new SVNRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (cacheTtlInMillis != null) {
                source.setCacheTimeToLiveInMilliseconds(Integer.parseInt(cacheTtlInMillis));
            }
            if (repositoryRootURL != null) {
                source.setRepositoryRootURL(repositoryRootURL);
            }
            if (username != null) {
                source.setUsername(username);
            }
            if (password != null) {
                source.setPassword(password);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            if (defaultWorkspace != null) {
                source.setDirectoryForDefaultWorkspace(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            return source;
        }
        return null;
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        String sourceName = this.getName();
        if (sourceName == null || sourceName.trim().length() == 0) {
            I18n msg = SVNRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        String sourceUsername = this.getUsername();
        if (sourceUsername == null || sourceUsername.trim().length() == 0) {
            I18n msg = SVNRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getUsername(), msg.text(new Object[]{SVN_USERNAME}));
        }
        String sourcePassword = this.getPassword();
        if (sourcePassword == null) {
            I18n msg = SVNRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getPassword(), msg.text(new Object[]{SVN_PASSWORD}));
        }
        String repositoryRootURL = this.getRepositoryRootURL();
        if (repositoryRootURL == null || repositoryRootURL.trim().length() == 0) {
            I18n msg = SVNRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getRepositoryRootURL(), msg.text(new Object[]{SVN_REPOSITORY_ROOT_URL}));
        }
        SVNRepository repos = null;
        boolean reportWarnings = false;
        if (this.availableWorspaceNames == null) {
            this.availableWorspaceNames = new CopyOnWriteArraySet();
            for (String predefined : this.predefinedWorkspaces) {
                this.availableWorspaceNames.add(predefined);
            }
            reportWarnings = true;
            for (String url : this.availableWorspaceNames) {
                if (repos != null) {
                    SVNRepositoryUtil.setNewSVNRepositoryLocation(repos, url, true, sourceName);
                } else {
                    repos = SVNRepositoryUtil.createRepository(url, sourceUsername, sourcePassword);
                }
                if (!SVNRepositoryUtil.exist(repos)) {
                    Logger.getLogger(this.getClass()).warn(SVNRepositoryConnectorI18n.pathForPredefinedWorkspaceDoesNotExist, new Object[]{url, this.name});
                }
                if (SVNRepositoryUtil.isDirectory(repos, "")) continue;
                Logger.getLogger(this.getClass()).warn(SVNRepositoryConnectorI18n.pathForPredefinedWorkspaceIsNotDirectory, new Object[]{url, this.name});
            }
        }
        boolean supportsUpdates = this.getSupportsUpdates();
        SVNRepository defaultWorkspace = null;
        if (repos != null) {
            SVNRepositoryUtil.setNewSVNRepositoryLocation(repos, this.getRepositoryRootURL(), true, sourceName);
            defaultWorkspace = repos;
        } else {
            defaultWorkspace = SVNRepositoryUtil.createRepository(this.getRepositoryRootURL(), sourceUsername, sourcePassword);
        }
        String defaultURL = this.getDirectoryForDefaultWorkspace();
        if (defaultURL != null) {
            SVNRepository repository = SVNRepositoryUtil.createRepository(defaultURL, sourceUsername, sourcePassword);
            I18n warning = null;
            if (!SVNRepositoryUtil.exist(repository)) {
                warning = SVNRepositoryConnectorI18n.pathForPredefinedWorkspaceDoesNotExist;
            } else if (!SVNRepositoryUtil.isDirectory(repository, "")) {
                warning = SVNRepositoryConnectorI18n.pathForPredefinedWorkspaceIsNotDirectory;
            } else {
                defaultWorkspace = repository;
            }
            if (reportWarnings && warning != null) {
                Logger.getLogger(this.getClass()).warn(warning, new Object[]{defaultURL, this.name});
            }
        }
        this.availableWorspaceNames.add(defaultWorkspace.getLocation().toDecodedString());
        return new SVNRepositoryConnection(this.name, defaultWorkspace, this.availableWorspaceNames, this.isCreatingWorkspacesAllowed(), this.cachePolicy, supportsUpdates, new RepositoryAccessData(this.getRepositoryRootURL(), sourceUsername, sourcePassword));
    }

    @Immutable
    class SVNRepositoryCachePolicy
    implements CachePolicy {
        private static final long serialVersionUID = 1L;
        private final int ttl;

        SVNRepositoryCachePolicy(int ttl) {
            this.ttl = ttl;
        }

        public long getTimeToLive() {
            return this.ttl;
        }
    }
}

