/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.security.AccessControlContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.ValueFactories;
import org.jboss.dna.graph.properties.basic.DelegatingValueFactories;

public class ExecutionContexts {
    public static ExecutionContext replace(ExecutionContext context, PathFactory pathFactory) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)pathFactory, (String)"pathFactory");
        return new DelegatingExecutionEnvironment(context, null, null, null, pathFactory);
    }

    public static ExecutionContext replace(ExecutionContext context, NameFactory nameFactory) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)nameFactory, (String)"nameFactory");
        return new DelegatingExecutionEnvironment(context, null, null, nameFactory, null);
    }

    public static ExecutionContext replace(ExecutionContext context, NameFactory nameFactory, PathFactory pathFactory) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)nameFactory, (String)"nameFactory");
        CheckArg.isNotNull((Object)pathFactory, (String)"pathFactory");
        return new DelegatingExecutionEnvironment(context, null, null, nameFactory, pathFactory);
    }

    public static ExecutionContext replace(ExecutionContext context, NamespaceRegistry namespaceRegistry) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return new DelegatingExecutionEnvironment(context, namespaceRegistry, null, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DelegatingExecutionEnvironment
    implements ExecutionContext {
        private final ExecutionContext delegate;
        private final NamespaceRegistry newNamespaceRegistry;
        private final PropertyFactory newPropertyFactory;
        private final ValueFactories newValueFactories;

        public DelegatingExecutionEnvironment(ExecutionContext delegate, NamespaceRegistry newRegistry, PropertyFactory newPropertyFactory, ValueFactories newValueFactories) {
            assert (delegate != null);
            this.delegate = delegate;
            this.newNamespaceRegistry = newRegistry;
            this.newPropertyFactory = newPropertyFactory;
            this.newValueFactories = newValueFactories;
        }

        public DelegatingExecutionEnvironment(ExecutionContext delegate, NamespaceRegistry newRegistry, PropertyFactory newPropertyFactory, NameFactory newNameFactory, PathFactory newPathFactory) {
            assert (delegate != null);
            this.delegate = delegate;
            this.newNamespaceRegistry = newRegistry;
            this.newPropertyFactory = newPropertyFactory;
            final PathFactory pathFactory = newPathFactory != null ? newPathFactory : delegate.getValueFactories().getPathFactory();
            final NameFactory nameFactory = newNameFactory != null ? newNameFactory : delegate.getValueFactories().getNameFactory();
            this.newValueFactories = newPathFactory == null ? null : new DelegatingValueFactories(delegate.getValueFactories()){

                public PathFactory getPathFactory() {
                    return pathFactory;
                }

                public NameFactory getNameFactory() {
                    return nameFactory;
                }
            };
        }

        public ClassLoader getClassLoader(String ... classpath) {
            return this.delegate.getClassLoader(classpath);
        }

        @Override
        public AccessControlContext getAccessControlContext() {
            return this.delegate.getAccessControlContext();
        }

        @Override
        public LoginContext getLoginContext() {
            return this.delegate.getLoginContext();
        }

        @Override
        public NamespaceRegistry getNamespaceRegistry() {
            if (this.newNamespaceRegistry != null) {
                return this.newNamespaceRegistry;
            }
            return this.delegate.getNamespaceRegistry();
        }

        @Override
        public PropertyFactory getPropertyFactory() {
            if (this.newPropertyFactory != null) {
                return this.newPropertyFactory;
            }
            return this.delegate.getPropertyFactory();
        }

        @Override
        public ValueFactories getValueFactories() {
            if (this.newValueFactories != null) {
                return this.newValueFactories;
            }
            return this.delegate.getValueFactories();
        }

        @Override
        public Subject getSubject() {
            return this.delegate.getSubject();
        }

        @Override
        public Logger getLogger(Class<?> clazz) {
            return this.delegate.getLogger(clazz);
        }

        @Override
        public Logger getLogger(String name) {
            return this.delegate.getLogger(name);
        }

        protected ExecutionContext getDelegate() {
            return this.delegate;
        }
    }
}

