/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.basic;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.graph.commands.GetNodeCommand;
import org.jboss.dna.graph.commands.basic.BasicGetChildrenCommand;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BasicGetNodeCommand
extends BasicGetChildrenCommand
implements GetNodeCommand {
    private static final long serialVersionUID = 5355669032301356873L;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();

    public BasicGetNodeCommand(Path path) {
        super(path);
    }

    @Override
    public void setProperty(Property property) {
        if (property != null) {
            this.properties.put(property.getName(), property);
        }
    }

    public void setProperties(Map<Name, Property> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Map<Name, Property> getPropertiesByName() {
        return this.properties;
    }

    @Override
    public String toString() {
        List<Path.Segment> children;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" at ");
        sb.append(this.getPath());
        boolean firstProperty = true;
        for (Property property : this.getProperties()) {
            if (property.isEmpty()) continue;
            if (firstProperty) {
                sb.append(" { ");
                firstProperty = false;
            } else {
                sb.append("; ");
            }
            sb.append(property.getName());
            sb.append("=");
            if (property.isSingle()) {
                sb.append(StringUtil.readableString(property.getValues().next()));
                continue;
            }
            sb.append(StringUtil.readableString((Object)property.getValuesAsArray()));
        }
        if (!firstProperty) {
            sb.append(" }");
        }
        if ((children = this.getChildren()) != null && children.size() > 0) {
            sb.append(" with ").append(children.size()).append(" children: ");
            sb.append(StringUtil.readableString(children));
        }
        return sb.toString();
    }
}

