/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.basic;

import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.commands.GetPropertiesCommand;
import org.jboss.dna.graph.commands.basic.BasicGraphCommand;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BasicGetPropertiesCommand
extends BasicGraphCommand
implements GetPropertiesCommand {
    private static final long serialVersionUID = -7816393217506909521L;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();
    private final Path path;
    private CachePolicy cachePolicy;
    private DateTime timeLoaded;

    public BasicGetPropertiesCommand(Path path) {
        assert (path != null);
        this.path = path;
    }

    @Override
    public void setProperty(Property property) {
        if (property != null) {
            this.properties.put(property.getName(), property);
        }
    }

    public void setProperties(Map<Name, Property> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public Iterable<Property> getProperties() {
        return this.properties.values();
    }

    public Map<Name, Property> getPropertiesByName() {
        return this.properties;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    @Override
    public DateTime getTimeLoaded() {
        return this.timeLoaded;
    }

    public void setTimeLoaded(DateTime timeLoaded) {
        this.timeLoaded = timeLoaded;
    }

    @Override
    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" at ");
        sb.append(this.getPath());
        boolean firstProperty = true;
        for (Property property : this.getProperties()) {
            if (property.isEmpty()) continue;
            if (firstProperty) {
                sb.append(" { ");
                firstProperty = false;
            } else {
                sb.append("; ");
            }
            sb.append(property.getName());
            sb.append("=");
            if (property.isSingle()) {
                sb.append(StringUtil.readableString(property.getValues().next()));
                continue;
            }
            sb.append(StringUtil.readableString((Object)property.getValuesAsArray()));
        }
        if (!firstProperty) {
            sb.append(" }");
        }
        return sb.toString();
    }
}

