/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.basic.BasicPathSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class BasicGraphCommand
implements GraphCommand {
    private boolean cancelled = false;
    private Throwable error;

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public void setError(Throwable t) {
        this.error = t;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public boolean hasNoError() {
        return this.error == null;
    }

    protected List<Path.Segment> createChildrenList(Name nameOfChild) {
        if (nameOfChild == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new BasicPathSegment(nameOfChild));
    }

    protected List<Path.Segment> createChildrenList(Iterator<Path.Segment> namesOfChildren) {
        if (namesOfChildren == null) {
            return Collections.emptyList();
        }
        ArrayList<Path.Segment> children = new ArrayList<Path.Segment>();
        while (namesOfChildren.hasNext()) {
            children.add(namesOfChildren.next());
        }
        return children;
    }

    protected List<Path.Segment> createChildrenList(Iterable<Path.Segment> namesOfChildren) {
        if (namesOfChildren == null) {
            return Collections.emptyList();
        }
        ArrayList<Path.Segment> children = new ArrayList<Path.Segment>();
        for (Path.Segment childSegment : namesOfChildren) {
            children.add(childSegment);
        }
        return children;
    }

    protected static List<Path.Segment> createChildrenList(Path.Segment ... namesOfChildren) {
        if (namesOfChildren == null || namesOfChildren.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Path.Segment> children = new ArrayList<Path.Segment>();
        for (Path.Segment childSegment : namesOfChildren) {
            children.add(childSegment);
        }
        return children;
    }

    protected static void setProperty(Map<Name, List<Object>> propertyValues, Name propertyName, Object ... values) {
        if (values == null || values.length == 0) {
            propertyValues.remove(propertyName);
        } else {
            List<Object> valuesList = null;
            if (values.length == 1) {
                Object value = values[0];
                if (value instanceof Collection) {
                    BasicGraphCommand.setProperty(propertyValues, propertyName, ((Collection)value).iterator());
                    return;
                }
                if (value instanceof Iterable) {
                    BasicGraphCommand.setProperty(propertyValues, propertyName, (Iterable)value);
                    return;
                }
                if (value instanceof Iterator) {
                    BasicGraphCommand.setProperty(propertyValues, propertyName, (Iterator)value);
                    return;
                }
                valuesList = Collections.singletonList(value);
            } else {
                assert (values.length > 1);
                valuesList = new ArrayList(values.length);
                for (Object arrayValue : values) {
                    valuesList.add(arrayValue);
                }
            }
            propertyValues.put(propertyName, valuesList);
        }
    }

    protected static void setProperty(Map<Name, List<Object>> propertyValues, Name propertyName, Iterable<?> values) {
        if (values == null) {
            propertyValues.remove(propertyName);
        } else {
            ArrayList valuesList = new ArrayList();
            for (Object value : values) {
                valuesList.add(value);
            }
            propertyValues.put(propertyName, valuesList);
        }
    }

    protected static void setProperty(Map<Name, List<Object>> propertyValues, Name propertyName, Iterator<?> values) {
        if (values == null) {
            propertyValues.remove(propertyName);
        } else {
            ArrayList valuesList = new ArrayList();
            while (values.hasNext()) {
                Object value = values.next();
                valuesList.add(value);
            }
            propertyValues.put(propertyName, valuesList);
        }
    }
}

