/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.NodeConflictBehavior;
import org.jboss.dna.graph.commands.RecordBranchCommand;
import org.jboss.dna.graph.commands.basic.BasicCreateNodeCommand;
import org.jboss.dna.graph.commands.basic.BasicGraphCommand;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BasicRecordBranchCommand
extends BasicGraphCommand
implements RecordBranchCommand {
    private final int maxDepth;
    private final Path topOfBranch;
    private final List<CreateNodeCommand> commands;
    private final NodeConflictBehavior conflictBehavior;

    public BasicRecordBranchCommand(Path topOfBranch, NodeConflictBehavior conflictBehavior) {
        this(topOfBranch, conflictBehavior, null, Integer.MAX_VALUE);
    }

    public BasicRecordBranchCommand(Path topOfBranch, NodeConflictBehavior conflictBehavior, List<CreateNodeCommand> commands) {
        this(topOfBranch, conflictBehavior, commands, Integer.MAX_VALUE);
    }

    public BasicRecordBranchCommand(Path topOfBranch, NodeConflictBehavior conflictBehavior, List<CreateNodeCommand> commands, int maxDepthOfBranch) {
        assert (topOfBranch != null);
        assert (conflictBehavior != null);
        assert (maxDepthOfBranch > 0);
        this.topOfBranch = topOfBranch;
        this.maxDepth = maxDepthOfBranch;
        this.conflictBehavior = conflictBehavior;
        this.commands = commands != null ? commands : new LinkedList();
    }

    @Override
    public Path getPath() {
        return this.topOfBranch;
    }

    @Override
    public boolean record(Path path, Iterable<Property> properties) {
        int numberOfLevelsLeft;
        if (path.isAbsolute()) {
            if (!path.isDecendantOf(this.topOfBranch)) {
                return false;
            }
            path = path.relativeTo(this.topOfBranch);
        }
        if ((numberOfLevelsLeft = this.maxDepth - path.size()) < 0) {
            return false;
        }
        LinkedList<Property> propertyList = Collections.emptyList();
        if (properties != null) {
            if (properties instanceof List) {
                propertyList = (LinkedList<Property>)properties;
            } else {
                propertyList = new LinkedList<Property>();
                for (Property property : properties) {
                    propertyList.add(property);
                }
            }
        }
        this.record(new BasicCreateNodeCommand(path, propertyList, this.conflictBehavior));
        return numberOfLevelsLeft > 0;
    }

    @Override
    public boolean record(Path path, Iterator<Property> properties) {
        int numberOfLevelsLeft = this.maxDepth - path.size();
        if (numberOfLevelsLeft < 0) {
            return false;
        }
        List<Property> propertyList = Collections.emptyList();
        if (properties != null) {
            propertyList = new LinkedList();
            while (properties.hasNext()) {
                Property property = properties.next();
                propertyList.add(property);
            }
        }
        this.record(new BasicCreateNodeCommand(path, propertyList, this.conflictBehavior));
        return numberOfLevelsLeft > 0;
    }

    @Override
    public boolean record(Path path, Property ... properties) {
        int numberOfLevelsLeft = this.maxDepth - path.size();
        if (numberOfLevelsLeft < 0) {
            return false;
        }
        List<Property> propertyList = Collections.emptyList();
        if (properties != null) {
            propertyList = new ArrayList(properties.length);
            for (Property property : properties) {
                propertyList.add(property);
            }
        }
        this.record(new BasicCreateNodeCommand(path, propertyList, this.conflictBehavior));
        return numberOfLevelsLeft > 0;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    protected void record(CreateNodeCommand command) {
        this.commands.add(command);
    }

    public List<CreateNodeCommand> getCreateNodeCommands() {
        return this.commands;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " at " + this.getPath();
    }
}

