/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.basic;

import java.util.Collection;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.graph.commands.SetPropertiesCommand;
import org.jboss.dna.graph.commands.basic.BasicGraphCommand;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BasicSetPropertiesCommand
extends BasicGraphCommand
implements SetPropertiesCommand {
    private static final long serialVersionUID = -2693642411179501304L;
    private final Path path;
    private final List<Property> properties;

    public BasicSetPropertiesCommand(Path path, List<Property> properties) {
        assert (path != null);
        assert (properties != null);
        this.properties = properties;
        this.path = path;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" at ");
        sb.append(this.getPath());
        boolean firstProperty = true;
        for (Property property : this.getProperties()) {
            if (property.isEmpty()) continue;
            if (firstProperty) {
                sb.append(" { ");
                firstProperty = false;
            } else {
                sb.append("; ");
            }
            sb.append(property.getName());
            sb.append("=");
            if (property.isSingle()) {
                sb.append(StringUtil.readableString(property.getValues().next()));
                continue;
            }
            sb.append(StringUtil.readableString((Object)property.getValuesAsArray()));
        }
        if (!firstProperty) {
            sb.append(" }");
        }
        return sb.toString();
    }
}

