/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.executor;

import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.commands.CompositeCommand;
import org.jboss.dna.graph.commands.CopyBranchCommand;
import org.jboss.dna.graph.commands.CopyNodeCommand;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.DeleteBranchCommand;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.GetNodeCommand;
import org.jboss.dna.graph.commands.GetPropertiesCommand;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.MoveBranchCommand;
import org.jboss.dna.graph.commands.RecordBranchCommand;
import org.jboss.dna.graph.commands.SetPropertiesCommand;
import org.jboss.dna.graph.commands.executor.CommandExecutor;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.DateTime;

public abstract class AbstractCommandExecutor
implements CommandExecutor {
    private final ExecutionContext context;
    private final String sourceName;
    private final DateTime nowInUtc;

    protected AbstractCommandExecutor(ExecutionContext context, String sourceName) {
        this(context, sourceName, null);
    }

    protected AbstractCommandExecutor(ExecutionContext context, String sourceName, DateTime now) {
        assert (context != null);
        assert (sourceName != null && sourceName.trim().length() != 0);
        this.context = context;
        this.sourceName = sourceName;
        this.nowInUtc = now != null ? now.toUtcTimeZone() : context.getValueFactories().getDateFactory().createUtc();
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public DateTime getCurrentTimeInUtc() {
        return this.nowInUtc;
    }

    public void execute(GraphCommand command) throws RepositorySourceException {
        if (command == null) {
            return;
        }
        if (command instanceof CompositeCommand) {
            this.execute((CompositeCommand)command);
            return;
        }
        if (command instanceof GetNodeCommand) {
            this.execute((GetNodeCommand)command);
        } else if (command instanceof GetPropertiesCommand) {
            this.execute((GetPropertiesCommand)command);
        } else if (command instanceof GetChildrenCommand) {
            this.execute((GetChildrenCommand)command);
        }
        if (command instanceof RecordBranchCommand) {
            this.execute((RecordBranchCommand)command);
        }
        if (command instanceof CreateNodeCommand) {
            this.execute((CreateNodeCommand)command);
        } else if (command instanceof SetPropertiesCommand) {
            this.execute((SetPropertiesCommand)command);
        }
        if (command instanceof CopyBranchCommand) {
            this.execute((CopyBranchCommand)command);
        } else if (command instanceof CopyNodeCommand) {
            this.execute((CopyNodeCommand)command);
        }
        if (command instanceof DeleteBranchCommand) {
            this.execute((DeleteBranchCommand)command);
        } else if (command instanceof MoveBranchCommand) {
            this.execute((MoveBranchCommand)command);
        }
    }

    public void execute(CompositeCommand command) throws RepositorySourceException {
        assert (command != null);
        for (GraphCommand nestedCommand : command) {
            this.execute(nestedCommand);
        }
    }

    public void execute(GetNodeCommand command) throws RepositorySourceException {
        this.execute((GetPropertiesCommand)command);
        this.execute((GetChildrenCommand)command);
    }

    public void execute(GetPropertiesCommand command) throws RepositorySourceException {
    }

    public void execute(GetChildrenCommand command) throws RepositorySourceException {
    }

    public void execute(CreateNodeCommand command) throws RepositorySourceException {
    }

    public void execute(SetPropertiesCommand command) throws RepositorySourceException {
    }

    public void execute(CopyNodeCommand command) throws RepositorySourceException {
    }

    public void execute(CopyBranchCommand command) throws RepositorySourceException {
    }

    public void execute(DeleteBranchCommand command) throws RepositorySourceException {
    }

    public void execute(MoveBranchCommand command) throws RepositorySourceException {
    }

    public void execute(RecordBranchCommand command) throws RepositorySourceException {
    }

    public void close() {
    }
}

