/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.executor;

import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.commands.CopyBranchCommand;
import org.jboss.dna.graph.commands.CopyNodeCommand;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.DeleteBranchCommand;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.GetPropertiesCommand;
import org.jboss.dna.graph.commands.MoveBranchCommand;
import org.jboss.dna.graph.commands.RecordBranchCommand;
import org.jboss.dna.graph.commands.SetPropertiesCommand;
import org.jboss.dna.graph.commands.executor.AbstractCommandExecutor;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.DateTime;

public class SingleSourceCommandExecutor
extends AbstractCommandExecutor {
    private RepositoryConnection connection;
    private final RepositoryConnectionFactory connectionFactory;

    public SingleSourceCommandExecutor(ExecutionContext context, String sourceName, RepositoryConnectionFactory connectionFactory) {
        this(context, sourceName, null, connectionFactory);
    }

    public SingleSourceCommandExecutor(ExecutionContext context, String sourceName, DateTime now, RepositoryConnectionFactory connectionFactory) {
        super(context, sourceName, now);
        assert (connectionFactory != null);
        this.connectionFactory = connectionFactory;
    }

    protected RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.connection == null) {
            this.connection = this.connectionFactory.createConnection(this.getSourceName());
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                Object var2_1 = null;
                this.connection = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.connection = null;
                throw throwable;
            }
        }
        super.close();
    }

    public void execute(CopyBranchCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(CopyNodeCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(CreateNodeCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(DeleteBranchCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(GetChildrenCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(GetPropertiesCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(MoveBranchCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(RecordBranchCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }

    public void execute(SetPropertiesCommand command) throws RepositorySourceException {
        this.getConnection().execute(this.getExecutionContext(), command);
    }
}

