/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connectors;

import java.security.AccessControlContext;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.ValueFactories;
import org.jboss.dna.graph.properties.basic.BasicNamespaceRegistry;
import org.jboss.dna.graph.properties.basic.BasicPropertyFactory;
import org.jboss.dna.graph.properties.basic.StandardValueFactories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicExecutionContext
implements ExecutionContext {
    private final ClassLoaderFactory classLoaderFactory;
    private final LoginContext loginContext;
    private final AccessControlContext accessControlContext;
    private final Subject subject;
    private final PropertyFactory propertyFactory;
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaceRegistry;

    public BasicExecutionContext() {
        this(new BasicNamespaceRegistry());
    }

    public BasicExecutionContext(NamespaceRegistry namespaceRegistry) {
        this(namespaceRegistry, null, null);
    }

    public BasicExecutionContext(LoginContext loginContext) {
        this(loginContext, (NamespaceRegistry)new BasicNamespaceRegistry());
    }

    public BasicExecutionContext(AccessControlContext accessControlContext) {
        this(accessControlContext, (NamespaceRegistry)new BasicNamespaceRegistry());
    }

    public BasicExecutionContext(LoginContext loginContext, NamespaceRegistry namespaceRegistry) {
        this(loginContext, namespaceRegistry, null, null);
    }

    public BasicExecutionContext(AccessControlContext accessControlContext, NamespaceRegistry namespaceRegistry) {
        this(accessControlContext, namespaceRegistry, null, null);
    }

    public BasicExecutionContext(NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory) {
        this(null, null, namespaceRegistry, valueFactories, propertyFactory);
    }

    public BasicExecutionContext(LoginContext loginContext, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory) {
        this(loginContext, null, namespaceRegistry, valueFactories, propertyFactory);
    }

    public BasicExecutionContext(AccessControlContext accessControlContext, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory) {
        this(null, accessControlContext, namespaceRegistry, valueFactories, propertyFactory);
    }

    private BasicExecutionContext(LoginContext loginContext, AccessControlContext accessControlContext, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        this.loginContext = loginContext;
        this.accessControlContext = accessControlContext;
        this.subject = loginContext == null ? Subject.getSubject(accessControlContext == null ? AccessController.getContext() : accessControlContext) : loginContext.getSubject();
        this.namespaceRegistry = namespaceRegistry;
        this.valueFactories = valueFactories != null ? valueFactories : new StandardValueFactories(this.namespaceRegistry);
        this.propertyFactory = propertyFactory != null ? propertyFactory : new BasicPropertyFactory(this.valueFactories);
        this.classLoaderFactory = new StandardClassLoaderFactory();
    }

    public ClassLoader getClassLoader(String ... classpath) {
        return this.classLoaderFactory.getClassLoader(classpath);
    }

    @Override
    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    @Override
    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    @Override
    public PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    @Override
    public Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz);
    }

    @Override
    public Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }
}

