/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Reference;
import org.jboss.dna.graph.properties.ValueComparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public enum PropertyType {
    STRING("String", ValueComparators.STRING_COMPARATOR, String.class),
    BINARY("Binary", ValueComparators.BINARY_COMPARATOR, Binary.class),
    LONG("Long", ValueComparators.LONG_COMPARATOR, Long.class),
    DOUBLE("Double", ValueComparators.DOUBLE_COMPARATOR, Double.class),
    DECIMAL("Decimal", ValueComparators.DECIMAL_COMPARATOR, BigDecimal.class),
    DATE("Date", ValueComparators.DATE_TIME_COMPARATOR, DateTime.class),
    BOOLEAN("Boolean", ValueComparators.BOOLEAN_COMPARATOR, Boolean.class),
    NAME("Name", ValueComparators.NAME_COMPARATOR, Name.class),
    PATH("Path", ValueComparators.PATH_COMPARATOR, Path.class),
    UUID("UUID", ValueComparators.UUID_COMPARATOR, UUID.class),
    REFERENCE("Reference", ValueComparators.REFERENCE_COMPARATOR, Reference.class),
    URI("URI", ValueComparators.URI_COMPARATOR, URI.class),
    OBJECT("Object", ValueComparators.OBJECT_COMPARATOR, Object.class);

    private static final List<PropertyType> ALL_PROPERTY_TYPES;
    private final String name;
    private final Comparator<?> comparator;
    private final Class<?> valueClass;

    private PropertyType(String name, Comparator<?> comparator, Class<?> valueClass) {
        this.name = name;
        this.comparator = comparator;
        this.valueClass = valueClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getName() {
        return this.name;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public boolean isTypeFor(Object value) {
        return this.valueClass.isInstance(value);
    }

    public boolean isTypeForEach(Iterable<?> values) {
        for (Object value : values) {
            if (this.valueClass.isInstance(value)) continue;
            return false;
        }
        return true;
    }

    public boolean isTypeForEach(Iterator<?> values) {
        while (values.hasNext()) {
            Object value = values.next();
            if (this.valueClass.isInstance(value)) continue;
            return false;
        }
        return true;
    }

    public static PropertyType discoverType(Object value) {
        if (value == null) {
            throw new IllegalArgumentException(GraphI18n.unableToDiscoverPropertyTypeForNullValue.text(new Object[0]));
        }
        for (PropertyType type : PropertyType.values()) {
            if (type == OBJECT || !type.isTypeFor(value)) continue;
            return type;
        }
        return OBJECT;
    }

    public static Iterator<PropertyType> iterator() {
        return ALL_PROPERTY_TYPES.iterator();
    }

    static {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        for (PropertyType type : PropertyType.values()) {
            types.add(type);
        }
        ALL_PROPERTY_TYPES = Collections.unmodifiableList(types);
    }
}

