/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.IoException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PropertyType;
import org.jboss.dna.graph.properties.Reference;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.graph.properties.ValueFormatException;
import org.jboss.dna.graph.properties.basic.AbstractValueFactory;
import org.jboss.dna.graph.properties.basic.InMemoryBinary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class InMemoryBinaryValueFactory
extends AbstractValueFactory<Binary> {
    private static final String CHAR_SET_NAME = "UTF-8";

    public InMemoryBinaryValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.BINARY, decoder, stringValueFactory);
    }

    @Override
    public Binary create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.create(value.getBytes(CHAR_SET_NAME));
        }
        catch (UnsupportedEncodingException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Binary.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public Binary create(String value, TextDecoder decoder) {
        if (value == null) {
            return null;
        }
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public Binary create(int value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(long value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(boolean value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(float value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(double value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(BigDecimal value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Calendar value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Date value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(DateTime value) throws ValueFormatException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Name value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Path value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Reference value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(URI value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(UUID value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(byte[] value) {
        return new InMemoryBinary(value);
    }

    @Override
    public Binary create(Binary value) throws ValueFormatException, IoException {
        return value;
    }

    @Override
    public Binary create(InputStream stream, long approximateLength) throws IoException {
        if (stream == null) {
            return null;
        }
        try {
            byte[] value = IoUtil.readBytes((InputStream)stream);
            return this.create(value);
        }
        catch (IOException err) {
            throw new IoException(GraphI18n.errorConvertingIo.text(new Object[]{InputStream.class.getSimpleName(), Binary.class.getSimpleName()}), err);
        }
    }

    @Override
    public Binary create(Reader reader, long approximateLength) throws IoException {
        if (reader == null) {
            return null;
        }
        try {
            String value = IoUtil.read((Reader)reader);
            return this.create(this.getStringValueFactory().create(value));
        }
        catch (IOException err) {
            throw new IoException(GraphI18n.errorConvertingIo.text(new Object[]{Reader.class.getSimpleName(), Binary.class.getSimpleName()}), err);
        }
    }

    protected Binary[] createEmptyArray(int length) {
        return new Binary[length];
    }
}

