/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.DateTimeFactory;
import org.jboss.dna.graph.properties.IoException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PropertyType;
import org.jboss.dna.graph.properties.Reference;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.graph.properties.ValueFormatException;
import org.jboss.dna.graph.properties.basic.AbstractValueFactory;
import org.jboss.dna.graph.properties.basic.JodaDateTime;
import org.joda.time.DateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class JodaDateTimeValueFactory
extends AbstractValueFactory<DateTime>
implements DateTimeFactory {
    public JodaDateTimeValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.DATE, decoder, stringValueFactory);
    }

    @Override
    public DateTime create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new JodaDateTime(value.trim());
        }
        catch (IllegalArgumentException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), DateTime.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public DateTime create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public DateTime create(int value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(long value) {
        return new JodaDateTime(value);
    }

    @Override
    public DateTime create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(float value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(double value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return this.create(value.longValue());
    }

    @Override
    public DateTime create(Calendar value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value);
    }

    @Override
    public DateTime create(Date value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value);
    }

    @Override
    public DateTime create(DateTime value) throws ValueFormatException {
        return value;
    }

    @Override
    public DateTime create(Name value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(Path value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(Reference value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(URI value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(UUID value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public DateTime create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public DateTime create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public DateTime create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    @Override
    public DateTime create() {
        return new JodaDateTime();
    }

    @Override
    public DateTime createUtc() {
        return new JodaDateTime(DateTimeZone.UTC);
    }

    @Override
    public DateTime create(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond) {
        return new JodaDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond);
    }

    @Override
    public DateTime create(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, int timeZoneOffsetHours) {
        return new JodaDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, timeZoneOffsetHours);
    }

    @Override
    public DateTime create(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, String timeZoneId) {
        return new JodaDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, timeZoneId);
    }

    @Override
    public DateTime create(DateTime original, long offsetInMillis) {
        assert (original != null);
        if (offsetInMillis == 0L) {
            return original;
        }
        long newMillis = original.getMilliseconds() + offsetInMillis;
        return new JodaDateTime(newMillis, original.getTimeZoneId());
    }

    protected DateTime[] createEmptyArray(int length) {
        return new DateTime[length];
    }
}

