/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.UUID;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.IoException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PropertyType;
import org.jboss.dna.graph.properties.Reference;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.graph.properties.ValueFormatException;
import org.jboss.dna.graph.properties.basic.AbstractValueFactory;
import org.jboss.dna.graph.properties.basic.BasicPath;
import org.jboss.dna.graph.properties.basic.BasicPathSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class PathValueFactory
extends AbstractValueFactory<Path>
implements PathFactory {
    protected static final Pattern DELIMITER_PATTERN = Pattern.compile("/");
    protected static final Pattern SEGMENT_PATTERN = Pattern.compile("([^:/]+)(:([^/\\[\\]]+))?(\\[(\\d+)])?");
    private final ValueFactory<Name> nameValueFactory;

    public PathValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory, ValueFactory<Name> nameValueFactory) {
        super(PropertyType.PATH, decoder, stringValueFactory);
        CheckArg.isNotNull(nameValueFactory, (String)"nameValueFactory");
        this.nameValueFactory = nameValueFactory;
    }

    protected ValueFactory<Name> getNameValueFactory() {
        return this.nameValueFactory;
    }

    @Override
    public Path createRootPath() {
        return BasicPath.ROOT;
    }

    @Override
    public Path create(String value) {
        return this.create(value, this.getDecoder());
    }

    @Override
    public Path create(String value, TextDecoder decoder) {
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        int length = trimmedValue.length();
        boolean absolute = false;
        if (length == 0) {
            return BasicPath.ROOT;
        }
        if (trimmedValue.charAt(0) == '/') {
            trimmedValue = length > 1 ? trimmedValue.substring(1) : "";
            --length;
            absolute = true;
        }
        if (length > 0 && trimmedValue.charAt(length - 1) == '/') {
            trimmedValue = length > 1 ? trimmedValue.substring(0, length - 1) : "";
            length = trimmedValue.length();
        }
        if (length == 0) {
            return BasicPath.ROOT;
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        String[] pathSegments = DELIMITER_PATTERN.split(trimmedValue);
        if (pathSegments.length == 0) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.validPathMayNotContainEmptySegment.text(new Object[]{value}));
        }
        if (decoder == null) {
            decoder = this.getDecoder();
        }
        assert (pathSegments.length != 0);
        assert (decoder != null);
        for (String segment : pathSegments) {
            assert (segment != null);
            if ((segment = segment.trim()).length() == 0) {
                throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.validPathMayNotContainEmptySegment.text(new Object[]{value}));
            }
            segments.add(this.createSegment(segment, decoder));
        }
        return new BasicPath(segments, absolute);
    }

    @Override
    public Path create(int value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public Path create(long value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public Path create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public Path create(float value) {
        throw new ValueFormatException((Object)Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public Path create(double value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public Path create(BigDecimal value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public Path create(Calendar value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public Path create(Date value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public Path create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public Path create(Name value) {
        if (value == null) {
            return null;
        }
        try {
            ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(1);
            segments.add(new BasicPathSegment(value));
            return new BasicPath(segments, true);
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), e);
        }
    }

    @Override
    public Path create(Path value) {
        return value;
    }

    @Override
    public Path createAbsolutePath(Name ... segmentNames) {
        if (segmentNames == null || segmentNames.length == 0) {
            return BasicPath.ROOT;
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(segmentNames.length);
        for (Name segmentName : segmentNames) {
            if (segmentName == null) {
                CheckArg.containsNoNulls((Object[])segmentNames, (String)"segment names");
            }
            segments.add(new BasicPathSegment(segmentName));
        }
        return new BasicPath(segments, true);
    }

    @Override
    public Path createAbsolutePath(Path.Segment ... segments) {
        if (segments == null || segments.length == 0) {
            return BasicPath.ROOT;
        }
        ArrayList<Path.Segment> segmentsList = new ArrayList<Path.Segment>(segments.length);
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls((Object[])segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        return new BasicPath(segmentsList, true);
    }

    @Override
    public Path createAbsolutePath(Iterable<Path.Segment> segments) {
        LinkedList<Path.Segment> segmentsList = new LinkedList<Path.Segment>();
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls(segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        if (segmentsList.isEmpty()) {
            return BasicPath.ROOT;
        }
        return new BasicPath(segmentsList, true);
    }

    @Override
    public Path createRelativePath() {
        return BasicPath.SELF_PATH;
    }

    @Override
    public Path createRelativePath(Name ... segmentNames) {
        if (segmentNames == null || segmentNames.length == 0) {
            return BasicPath.SELF_PATH;
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(segmentNames.length);
        for (Name segmentName : segmentNames) {
            if (segmentName == null) {
                CheckArg.containsNoNulls((Object[])segmentNames, (String)"segment names");
            }
            segments.add(new BasicPathSegment(segmentName));
        }
        return new BasicPath(segments, false);
    }

    @Override
    public Path createRelativePath(Path.Segment ... segments) {
        if (segments == null || segments.length == 0) {
            return BasicPath.SELF_PATH;
        }
        ArrayList<Path.Segment> segmentsList = new ArrayList<Path.Segment>(segments.length);
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls((Object[])segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        return new BasicPath(segmentsList, false);
    }

    @Override
    public Path createRelativePath(Iterable<Path.Segment> segments) {
        LinkedList<Path.Segment> segmentsList = new LinkedList<Path.Segment>();
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls(segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        if (segmentsList.isEmpty()) {
            return BasicPath.SELF_PATH;
        }
        return new BasicPath(segmentsList, false);
    }

    @Override
    public Path create(Path parentPath, Path childPath) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        CheckArg.isNotNull((Object)childPath, (String)"child path");
        if (childPath.size() == 0) {
            return parentPath;
        }
        if (parentPath.size() == 0) {
            if (childPath.isAbsolute() == parentPath.isAbsolute()) {
                return childPath;
            }
            return new BasicPath(childPath.getSegmentsList(), parentPath.isAbsolute());
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(parentPath.size() + childPath.size());
        segments.addAll(parentPath.getSegmentsList());
        segments.addAll(childPath.getSegmentsList());
        return new BasicPath(segments, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, Name segmentName, int index) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(parentPath.size() + 1);
        segments.addAll(parentPath.getSegmentsList());
        segments.add(new BasicPathSegment(segmentName, index));
        return new BasicPath(segments, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, Name ... segmentNames) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        if (segmentNames == null || segmentNames.length == 0) {
            return parentPath;
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(parentPath.size() + 1);
        segments.addAll(parentPath.getSegmentsList());
        for (Name segmentName : segmentNames) {
            if (segmentName == null) {
                CheckArg.containsNoNulls((Object[])segmentNames, (String)"segment names");
            }
            segments.add(new BasicPathSegment(segmentName));
        }
        return new BasicPath(segments, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, Path.Segment ... segments) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        if (segments == null || segments.length == 0) {
            return BasicPath.ROOT;
        }
        ArrayList<Path.Segment> segmentsList = new ArrayList<Path.Segment>(parentPath.size() + 1);
        segmentsList.addAll(parentPath.getSegmentsList());
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls((Object[])segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        return new BasicPath(segmentsList, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, Iterable<Path.Segment> segments) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        LinkedList<Path.Segment> segmentsList = new LinkedList<Path.Segment>();
        segmentsList.addAll(parentPath.getSegmentsList());
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls(segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        if (segmentsList.isEmpty()) {
            return BasicPath.ROOT;
        }
        return new BasicPath(segmentsList, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, String subpath) {
        Path relativeSubpath = this.create(subpath);
        return this.create(parentPath, relativeSubpath);
    }

    @Override
    public Path.Segment createSegment(Name segmentName) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (Path.SELF_NAME.equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if (Path.PARENT_NAME.equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        return new BasicPathSegment(segmentName);
    }

    @Override
    public Path.Segment createSegment(Name segmentName, int index) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (Path.SELF_NAME.equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if (Path.PARENT_NAME.equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        return new BasicPathSegment(segmentName, index);
    }

    @Override
    public Path.Segment createSegment(String segmentName) {
        return this.createSegment(segmentName, this.getDecoder());
    }

    @Override
    public Path.Segment createSegment(String segmentName, TextDecoder decoder) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (".".equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if ("..".equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        int startBracketNdx = segmentName.indexOf(91);
        if (startBracketNdx < 0) {
            return new BasicPathSegment(this.nameValueFactory.create(segmentName, decoder));
        }
        int endBracketNdx = segmentName.indexOf(93, startBracketNdx);
        if (endBracketNdx < 0) {
            throw new IllegalArgumentException(GraphI18n.missingEndBracketInSegmentName.text(new Object[]{segmentName}));
        }
        String ndx = segmentName.substring(startBracketNdx + 1, endBracketNdx);
        try {
            return new BasicPathSegment(this.nameValueFactory.create(segmentName.substring(0, startBracketNdx), decoder), Integer.parseInt(ndx));
        }
        catch (NumberFormatException err) {
            throw new ValueFormatException((Object)segmentName, this.getPropertyType(), GraphI18n.invalidIndexInSegmentName.text(new Object[]{ndx, segmentName}));
        }
    }

    @Override
    public Path.Segment createSegment(String segmentName, int index) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (".".equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if ("..".equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        return new BasicPathSegment(this.nameValueFactory.create(segmentName), index);
    }

    @Override
    public Path create(Reference value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public Path create(URI value) {
        if (value == null) {
            return null;
        }
        String asciiString = value.toASCIIString();
        if (asciiString.startsWith("./") && asciiString.length() > 2) {
            asciiString = asciiString.substring(2);
        }
        if (asciiString.indexOf(47) == -1) {
            return this.create(asciiString);
        }
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{URI.class.getSimpleName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Path create(UUID value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public Path create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Path create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Path create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public Path create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    protected Path[] createEmptyArray(int length) {
        return new Path[length];
    }
}

