/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.monitor.SimpleProgressMonitor;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.commands.CompositeCommand;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.NodeConflictBehavior;
import org.jboss.dna.graph.commands.basic.BasicCreateNodeCommand;
import org.jboss.dna.graph.commands.basic.BasicGraphCommand;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySource;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.Reference;
import org.jboss.dna.graph.properties.ValueFactories;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.graph.properties.ValueFormatException;
import org.jboss.dna.graph.sequencers.SequencerContext;
import org.jboss.dna.graph.sequencers.SequencerOutput;
import org.jboss.dna.graph.sequencers.StreamSequencer;
import org.jboss.dna.graph.xml.DnaXmlLexicon;
import org.jboss.dna.graph.xml.XmlSequencer;

public class GraphImporter {
    private final RepositoryConnectionFactory sources;
    private final ExecutionContext context;

    public GraphImporter(RepositoryConnectionFactory sources, ExecutionContext context) {
        CheckArg.isNotNull((Object)sources, (String)"sources");
        CheckArg.isNotNull((Object)context, (String)"context");
        this.sources = sources;
        this.context = context;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public ImportSpecification importXml(URI uri) {
        CheckArg.isNotNull((Object)uri, (String)"uri");
        XmlSequencer sequencer = new XmlSequencer();
        return new UriImportedContent(sequencer, uri, "text/xml");
    }

    public ImportSpecification importXml(String pathToFile) {
        CheckArg.isNotNull((Object)pathToFile, (String)"pathToFile");
        return this.importXml(new File(pathToFile).toURI());
    }

    public ImportSpecification importXml(File file) {
        CheckArg.isNotNull((Object)file, (String)"file");
        return this.importXml(file.toURI());
    }

    public void importXml(URI uri, String sourceName, Path destinationPathInSource) throws IOException, RepositorySourceException {
        CheckArg.isNotNull((Object)uri, (String)"uri");
        CheckArg.isNotNull((Object)destinationPathInSource, (String)"destinationPathInSource");
        XmlSequencer sequencer = new XmlSequencer();
        this.importWithSequencer(sequencer, uri, "text/xml", sourceName, destinationPathInSource, NodeConflictBehavior.UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void importWithSequencer(StreamSequencer sequencer, URI contentUri, String mimeType, String sourceName, Path destinationPathInSource, NodeConflictBehavior conflictBehavior) throws IOException, RepositorySourceException {
        block23: {
            if (!GraphImporter.$assertionsDisabled && sequencer == null) {
                throw new AssertionError();
            }
            if (!GraphImporter.$assertionsDisabled && contentUri == null) {
                throw new AssertionError();
            }
            if (!GraphImporter.$assertionsDisabled && mimeType == null) {
                throw new AssertionError();
            }
            if (!GraphImporter.$assertionsDisabled && sourceName == null) {
                throw new AssertionError();
            }
            if (!GraphImporter.$assertionsDisabled && destinationPathInSource == null) {
                throw new AssertionError();
            }
            conflictBehavior = conflictBehavior != null ? conflictBehavior : NodeConflictBehavior.UPDATE;
            inputPath = this.extractInputPathFrom(contentUri);
            if (!GraphImporter.$assertionsDisabled && inputPath == null) {
                throw new AssertionError();
            }
            propertyFactory = this.getContext().getPropertyFactory();
            nameFactory = this.getContext().getValueFactories().getNameFactory();
            inputProperties = new HashSet<Property>();
            inputProperties.add(propertyFactory.create((Name)nameFactory.create("jcr:mimeType"), new Object[]{mimeType}));
            importerContext = new ImporterContext(inputPath, inputProperties, "text/xml");
            activity = GraphI18n.errorImportingContent.text(new Object[]{destinationPathInSource, contentUri});
            progressMonitor = new SimpleProgressMonitor(activity);
            commands = new ImporterCommands(destinationPathInSource, conflictBehavior);
            stream = null;
            try {
                stream = contentUri.toURL().openStream();
                sequencer.sequence(stream, commands, importerContext, (ProgressMonitor)progressMonitor);
                var18_16 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var17_24) {
                var18_17 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        msg = GraphI18n.errorImportingContent;
                        this.context.getLogger(this.getClass()).error((Throwable)e, msg, new Object[]{mimeType, contentUri});
                    }
                }
                throw var17_24;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    msg = GraphI18n.errorImportingContent;
                    this.context.getLogger(this.getClass()).error((Throwable)e, msg, new Object[]{mimeType, contentUri});
                }
            }
lbl-1000:
            // 2 sources

            {
                break block23;
                catch (MalformedURLException err) {
                    throw new IOException(err.getMessage());
                }
            }
        }
        connection = null;
        try {
            connection = this.sources.createConnection(sourceName);
            if (connection == null) {
                msg = GraphI18n.unableToFindRepositorySourceWithName;
                throw new RepositorySourceException(msg.text(new Object[]{sourceName}));
            }
            connection.execute(this.context, new GraphCommand[]{commands});
            var22_26 = null;
            ** if (connection == null) goto lbl-1000
        }
        catch (Throwable var21_32) {
            var22_27 = null;
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (RepositorySourceException e) {
                    msg = GraphI18n.errorImportingContent;
                    this.context.getLogger(this.getClass()).error((Throwable)e, msg, new Object[]{mimeType, contentUri});
                }
            }
            throw var21_32;
        }
lbl-1000:
        // 1 sources

        {
            try {
                connection.close();
            }
            catch (RepositorySourceException e) {
                msg = GraphI18n.errorImportingContent;
                this.context.getLogger(this.getClass()).error((Throwable)e, msg, new Object[]{mimeType, contentUri});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    protected Path extractInputPathFrom(URI contentUri) {
        try {
            return (Path)this.getContext().getValueFactories().getPathFactory().create(contentUri);
        }
        catch (ValueFormatException e) {
            String path = contentUri.getPath();
            return (Path)this.getContext().getValueFactories().getPathFactory().create(path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImporterContext
    implements SequencerContext {
        private final Path inputPath;
        private final Set<Property> inputProperties;
        private final String mimeType;

        protected ImporterContext(Path inputPath, Set<Property> inputProperties, String mimeType) {
            this.inputPath = inputPath;
            this.inputProperties = inputProperties;
            this.mimeType = mimeType;
        }

        @Override
        public ValueFactories getFactories() {
            return GraphImporter.this.getContext().getValueFactories();
        }

        @Override
        public Path getInputPath() {
            return this.inputPath;
        }

        @Override
        public Set<Property> getInputProperties() {
            return this.inputProperties;
        }

        @Override
        public Property getInputProperty(Name name) {
            for (Property property : this.inputProperties) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }

        @Override
        public Logger getLogger(Class<?> clazz) {
            return GraphImporter.this.getContext().getLogger(clazz);
        }

        @Override
        public Logger getLogger(String name) {
            return GraphImporter.this.getContext().getLogger(name);
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public NamespaceRegistry getNamespaceRegistry() {
            return GraphImporter.this.getContext().getNamespaceRegistry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImporterCommands
    extends BasicGraphCommand
    implements SequencerOutput,
    CompositeCommand {
        private final List<GraphCommand> commands = new ArrayList<GraphCommand>();
        private final Map<Path, BasicCreateNodeCommand> createNodeCommands = new HashMap<Path, BasicCreateNodeCommand>();
        private final NodeConflictBehavior conflictBehavior;
        private final Path destinationPath;
        private final NameFactory nameFactory;
        private final Name primaryTypeName;

        protected ImporterCommands(Path destinationPath, NodeConflictBehavior conflictBehavior) {
            CheckArg.isNotNull((Object)destinationPath, (String)"destinationPath");
            CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
            this.conflictBehavior = conflictBehavior;
            this.destinationPath = destinationPath;
            this.nameFactory = GraphImporter.this.getContext().getValueFactories().getNameFactory();
            this.primaryTypeName = (Name)this.nameFactory.create("jcr:primaryType");
        }

        @Override
        public ValueFactories getFactories() {
            return GraphImporter.this.getContext().getValueFactories();
        }

        @Override
        public NamespaceRegistry getNamespaceRegistry() {
            return GraphImporter.this.getContext().getNamespaceRegistry();
        }

        @Override
        public void setProperty(String nodePath, String propertyName, Object ... values) {
            Path path = (Path)this.getFactories().getPathFactory().create(nodePath);
            Name name = (Name)this.getFactories().getNameFactory().create(propertyName);
            this.setProperty(path, name, values);
        }

        @Override
        public void setProperty(Path nodePath, Name propertyName, Object ... values) {
            Name typeName;
            if (this.primaryTypeName.equals(propertyName) && values.length == 1 && DnaXmlLexicon.DOCUMENT.equals(typeName = (Name)this.nameFactory.create(values[0]))) {
                return;
            }
            PathFactory pathFactory = this.getFactories().getPathFactory();
            if (nodePath.isAbsolute()) {
                nodePath.relativeTo(pathFactory.createRootPath());
            }
            nodePath = pathFactory.create(this.destinationPath, nodePath).getNormalizedPath();
            Property property = GraphImporter.this.getContext().getPropertyFactory().create(propertyName, values);
            BasicCreateNodeCommand command = this.createNodeCommands.get(nodePath);
            if (command != null) {
                Collection<Property> properties = command.getProperties();
                Iterator<Property> iter = properties.iterator();
                while (iter.hasNext()) {
                    Property existingProperty = iter.next();
                    if (!existingProperty.getName().equals(propertyName)) continue;
                    iter.remove();
                    break;
                }
                command.getProperties().add(property);
            } else {
                ArrayList<Property> properties = new ArrayList<Property>();
                properties.add(property);
                command = new BasicCreateNodeCommand(nodePath, properties, this.conflictBehavior);
                this.createNodeCommands.put(nodePath, command);
                this.commands.add(command);
            }
        }

        @Override
        public void setReference(String nodePath, String propertyName, String ... paths) {
            Path path = (Path)this.getFactories().getPathFactory().create(nodePath);
            Name name = (Name)this.getFactories().getNameFactory().create(propertyName);
            ValueFactory<Reference> factory = this.getFactories().getReferenceFactory();
            Object[] values = new Object[paths.length];
            int i = 0;
            for (String referencedPath : paths) {
                values[i++] = factory.create(referencedPath);
            }
            this.setProperty(path, name, values);
        }

        @Override
        public Iterator<GraphCommand> iterator() {
            return this.commands.iterator();
        }
    }

    protected class SingleRepositorySourceConnectionFactory
    implements RepositoryConnectionFactory {
        private final RepositorySource source;

        protected SingleRepositorySourceConnectionFactory(RepositorySource source) {
            CheckArg.isNotNull((Object)source, (String)"source");
            this.source = source;
        }

        public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
            if (this.source.getName().equals(sourceName)) {
                return this.source.getConnection();
            }
            return null;
        }
    }

    @Immutable
    protected class UriImportedContent
    extends ImportedContentUsingSequencer {
        private final URI uri;
        private final String mimeType;

        protected UriImportedContent(StreamSequencer sequencer, URI uri, String mimeType) {
            super(sequencer);
            this.uri = uri;
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public URI getUri() {
            return this.uri;
        }

        public void into(String sourceName, Path pathInSource) throws IOException, RepositorySourceException {
            CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
            CheckArg.isNotNull((Object)pathInSource, (String)"pathInSource");
            GraphImporter.this.importWithSequencer(this.getSequencer(), this.uri, this.mimeType, sourceName, pathInSource, this.getConflictBehavior());
        }
    }

    @Immutable
    protected abstract class ImportedContentUsingSequencer
    implements ImportSpecification {
        private final StreamSequencer sequencer;

        protected ImportedContentUsingSequencer(StreamSequencer sequencer) {
            this.sequencer = sequencer;
        }

        protected StreamSequencer getSequencer() {
            return this.sequencer;
        }

        protected NodeConflictBehavior getConflictBehavior() {
            return NodeConflictBehavior.UPDATE;
        }

        public void into(String sourceName) throws IOException, RepositorySourceException {
            Path root = GraphImporter.this.getContext().getValueFactories().getPathFactory().createRootPath();
            this.into(sourceName, root);
        }
    }

    public static interface ImportSpecification {
        public void into(String var1) throws IOException, RepositorySourceException;

        public void into(String var1, Path var2) throws IOException, RepositorySourceException;
    }
}

