/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.sequencers.SequencerContext;
import org.jboss.dna.graph.sequencers.SequencerOutput;
import org.jboss.dna.graph.sequencers.StreamSequencer;
import org.jboss.dna.graph.xml.DnaDtdLexicon;
import org.jboss.dna.graph.xml.DnaXmlLexicon;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlSequencer
implements StreamSequencer {
    private static final String DEFAULT_PRIMARY_TYPE = "nt:unstructured";
    private static final String DECL_HANDLER_FEATURE = "http://xml.org/sax/properties/declaration-handler";
    private static final String ENTITY_RESOLVER_2_FEATURE = "http://xml.org/sax/features/use-entity-resolver2";
    private static final String LEXICAL_HANDLER_FEATURE = "http://xml.org/sax/properties/lexical-handler";
    private static final String RESOLVE_DTD_URIS_FEATURE = "http://xml.org/sax/features/resolve-dtd-uris";
    private static final String LOAD_EXTERNAL_DTDS_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequence(InputStream stream, SequencerOutput output, SequencerContext context, ProgressMonitor monitor) {
        monitor.beginTask(100.0, GraphI18n.sequencingXmlDocument, new Object[0]);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            Handler handler = new Handler(output, context, monitor);
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setProperty(DECL_HANDLER_FEATURE, handler);
            reader.setProperty(LEXICAL_HANDLER_FEATURE, handler);
            this.setFeature(reader, ENTITY_RESOLVER_2_FEATURE, true);
            this.setFeature(reader, LOAD_EXTERNAL_DTDS_FEATURE, false);
            this.setFeature(reader, RESOLVE_DTD_URIS_FEATURE, false);
            reader.parse(new InputSource(stream));
        }
        catch (Exception error) {
            context.getLogger(this.getClass()).error((Throwable)error, GraphI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
            monitor.getProblems().addError((Throwable)error, GraphI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
        }
        finally {
            monitor.done();
        }
    }

    private void setFeature(XMLReader reader, String featureName, boolean value) {
        try {
            if (reader.getFeature(featureName) != value) {
                reader.setFeature(featureName, value);
            }
        }
        catch (SAXNotRecognizedException meansFeatureNotRecognized) {
        }
        catch (SAXNotSupportedException meansFeatureNotSupported) {
            // empty catch block
        }
    }

    private class IndexedName {
        Map<Name, List<IndexedName>> nameToIndexedNamesMap = new HashMap<Name, List<IndexedName>>();

        IndexedName() {
        }
    }

    private final class Handler
    extends DefaultHandler2 {
        private final SequencerOutput output;
        private final SequencerContext context;
        private final ProgressMonitor monitor;
        private double progress;
        private Path path;
        private final NameFactory nameFactory;
        private Name primaryTypeName;
        private Name defaultPrimaryType;
        private Map<Name, List<IndexedName>> nameToIndexedNamesMap = new HashMap<Name, List<IndexedName>>();
        private final LinkedList<Map<Name, List<IndexedName>>> nameToIndexedNamesMapStack = new LinkedList();
        private final LinkedList<String> nsStack = new LinkedList();
        private StringBuilder cDataBuilder;
        private StringBuilder contentBuilder;
        private String entity;

        Handler(SequencerOutput output, SequencerContext context, ProgressMonitor monitor) {
            assert (output != null);
            assert (monitor != null);
            assert (context != null);
            this.output = output;
            this.context = context;
            this.monitor = monitor;
            this.path = context.getFactories().getPathFactory().createRelativePath();
            this.nameFactory = context.getFactories().getNameFactory();
        }

        public void attributeDecl(String name, String name2, String type, String mode, String value) throws SAXException {
            this.stopIfCancelled();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stopIfCancelled();
            String content = String.valueOf(ch, start, length);
            if (this.cDataBuilder == null) {
                if (this.entity != null) {
                    content = '&' + this.entity + ';';
                }
                if (this.contentBuilder == null) {
                    this.contentBuilder = new StringBuilder(content);
                } else {
                    if (this.entity == null) {
                        this.contentBuilder.append(' ');
                    }
                    this.contentBuilder.append(content);
                }
            } else {
                this.cDataBuilder.append(ch, start, length);
            }
            this.updateProgress();
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.stopIfCancelled();
            this.startElement(DnaXmlLexicon.COMMENT);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), DnaXmlLexicon.COMMENT);
            this.output.setProperty(this.path, DnaXmlLexicon.COMMENT_CONTENT, String.valueOf(ch, start, length));
            this.endElement();
            this.updateProgress();
        }

        public void elementDecl(String name, String model) throws SAXException {
            this.stopIfCancelled();
        }

        public void endCDATA() throws SAXException {
            this.stopIfCancelled();
            this.output.setProperty(this.path, DnaXmlLexicon.CDATA_CONTENT, this.cDataBuilder.toString());
            this.endElement();
            this.cDataBuilder = null;
            this.updateProgress();
        }

        private void endContent() {
            if (this.contentBuilder != null) {
                String content = StringUtil.normalize((String)this.contentBuilder.toString());
                this.contentBuilder = null;
                if (content.length() > 0) {
                    this.startElement(DnaXmlLexicon.ELEMENT_CONTENT);
                    this.output.setProperty(this.path, this.getPrimaryTypeName(), DnaXmlLexicon.ELEMENT_CONTENT);
                    this.output.setProperty(this.path, DnaXmlLexicon.ELEMENT_CONTENT, content);
                    this.endElement();
                }
            }
        }

        public void endDocument() throws SAXException {
            this.stopIfCancelled();
        }

        public void endDTD() throws SAXException {
            this.stopIfCancelled();
        }

        private void endElement() {
            this.path = this.path.getParent();
            this.nameToIndexedNamesMap.clear();
            this.nameToIndexedNamesMap = this.nameToIndexedNamesMapStack.removeFirst();
            this.nsStack.removeFirst();
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.stopIfCancelled();
            this.endContent();
            this.endElement();
            this.updateProgress();
        }

        public void endEntity(String name) throws SAXException {
            this.stopIfCancelled();
            this.entity = null;
            this.updateProgress();
        }

        public void error(SAXParseException error) {
            this.context.getLogger(XmlSequencer.class).error((Throwable)error, GraphI18n.errorSequencingXmlDocument, new Object[]{error});
            this.monitor.getProblems().addError((Throwable)error, GraphI18n.errorSequencingXmlDocument, new Object[]{error});
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            this.stopIfCancelled();
            Name entityName = DnaDtdLexicon.ENTITY;
            this.startElement(entityName);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), entityName);
            this.output.setProperty(this.path, (Name)this.nameFactory.create(DnaDtdLexicon.NAME), name);
            this.output.setProperty(this.path, (Name)this.nameFactory.create(DnaDtdLexicon.PUBLIC_ID), publicId);
            this.output.setProperty(this.path, (Name)this.nameFactory.create(DnaDtdLexicon.SYSTEM_ID), systemId);
            this.endElement();
            this.updateProgress();
        }

        public void fatalError(SAXParseException error) {
            this.context.getLogger(XmlSequencer.class).error((Throwable)error, GraphI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
            this.monitor.getProblems().addError((Throwable)error, GraphI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
        }

        private Name getPrimaryTypeName() {
            if (this.primaryTypeName == null) {
                this.primaryTypeName = (Name)this.nameFactory.create("jcr:primaryType");
            }
            return this.primaryTypeName;
        }

        private Name getDefaultPrimaryType() {
            if (this.defaultPrimaryType == null) {
                this.defaultPrimaryType = (Name)this.nameFactory.create(XmlSequencer.DEFAULT_PRIMARY_TYPE);
            }
            return this.defaultPrimaryType;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.stopIfCancelled();
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
            this.stopIfCancelled();
            Name entityName = DnaDtdLexicon.ENTITY;
            this.startElement(entityName);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), entityName);
            this.output.setProperty(this.path, DnaDtdLexicon.NAME, name);
            this.output.setProperty(this.path, DnaDtdLexicon.VALUE, value);
            this.endElement();
            this.updateProgress();
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.stopIfCancelled();
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.stopIfCancelled();
            Name name = DnaXmlLexicon.PROCESSING_INSTRUCTION;
            this.startElement(name);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), name);
            this.output.setProperty(this.path, DnaXmlLexicon.TARGET, target);
            this.output.setProperty(this.path, DnaXmlLexicon.PROCESSING_INSTRUCTION_CONTENT, data);
            this.endElement();
            this.updateProgress();
        }

        public void skippedEntity(String name) throws SAXException {
            this.stopIfCancelled();
        }

        public void startCDATA() throws SAXException {
            this.stopIfCancelled();
            this.startElement(DnaXmlLexicon.CDATA);
            this.cDataBuilder = new StringBuilder();
            this.updateProgress();
        }

        public void startDocument() throws SAXException {
            this.stopIfCancelled();
            this.output.setProperty(this.path, this.getPrimaryTypeName(), DnaXmlLexicon.DOCUMENT);
            this.updateProgress();
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.stopIfCancelled();
            this.output.setProperty(this.path, DnaDtdLexicon.NAME, name);
            this.output.setProperty(this.path, DnaDtdLexicon.PUBLIC_ID, publicId);
            this.output.setProperty(this.path, DnaDtdLexicon.SYSTEM_ID, systemId);
            this.updateProgress();
        }

        private void startElement(Name name) {
            this.endContent();
            List<IndexedName> indexedNames = this.nameToIndexedNamesMap.get(name);
            if (indexedNames == null) {
                indexedNames = new ArrayList<IndexedName>();
                this.nameToIndexedNamesMap.put(name, indexedNames);
            }
            IndexedName indexedName = new IndexedName();
            indexedNames.add(indexedName);
            this.path = this.context.getFactories().getPathFactory().create(this.path, name, indexedNames.size());
            this.path = this.path.getNormalizedPath();
            this.nameToIndexedNamesMapStack.addFirst(this.nameToIndexedNamesMap);
            this.nameToIndexedNamesMap = indexedName.nameToIndexedNamesMap;
            String ns = name.getNamespaceUri();
            if (ns.length() == 0) {
                this.nsStack.addFirst(this.nsStack.isEmpty() ? "" : this.nsStack.getFirst());
            } else {
                this.nsStack.addFirst(ns);
            }
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.stopIfCancelled();
            Name type = this.getDefaultPrimaryType();
            Name nameObj = (Name)this.nameFactory.create(name);
            int len = attributes.getLength();
            for (int ndx = 0; ndx < len; ++ndx) {
                String ns = attributes.getURI(ndx);
                String attrLocalName = attributes.getLocalName(ndx);
                String value = attributes.getValue(ndx);
                String jcrNsUri = this.context.getNamespaceRegistry().getNamespaceForPrefix("jcr");
                if (jcrNsUri == null || !jcrNsUri.equals(ns) || !attrLocalName.equals("name")) continue;
                nameObj = (Name)this.nameFactory.create((Object)value);
                break;
            }
            this.startElement(nameObj);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), type);
            String inheritedNs = this.nsStack.getFirst();
            int len2 = attributes.getLength();
            for (int ndx = 0; ndx < len2; ++ndx) {
                String ns = attributes.getURI(ndx);
                String attrLocalName = attributes.getLocalName(ndx);
                String value = attributes.getValue(ndx);
                String jcrNsUri = this.context.getNamespaceRegistry().getNamespaceForPrefix("jcr");
                if (jcrNsUri != null && jcrNsUri.equals(ns) && attrLocalName.equals("primaryType")) {
                    value = this.nameFactory.create((Object)value);
                }
                if (jcrNsUri != null && jcrNsUri.equals(ns) && attrLocalName.equals("name")) continue;
                this.output.setProperty(this.path, this.nameFactory.create(ns.length() == 0 ? inheritedNs : ns, attrLocalName), value);
            }
            this.updateProgress();
        }

        public void startEntity(String name) throws SAXException {
            this.stopIfCancelled();
            this.entity = name;
            this.updateProgress();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.stopIfCancelled();
            NamespaceRegistry registry = this.context.getNamespaceRegistry();
            if (!registry.isRegisteredNamespaceUri(uri)) {
                registry.register(prefix, uri);
            }
            this.updateProgress();
        }

        private void stopIfCancelled() throws SAXException {
            if (this.monitor.isCancelled()) {
                throw new SAXException(GraphI18n.canceledSequencingXmlDocument.text(new Object[0]));
            }
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            this.stopIfCancelled();
        }

        private void updateProgress() {
            this.progress = this.progress == 100.0 ? 1.0 : (this.progress += 1.0);
            this.monitor.worked(this.progress);
        }

        public void warning(SAXParseException warning) {
            this.context.getLogger(XmlSequencer.class).warn((Throwable)warning, GraphI18n.warningSequencingXmlDocument, new Object[0]);
            this.monitor.getProblems().addWarning((Throwable)warning, GraphI18n.warningSequencingXmlDocument, new Object[]{warning});
        }
    }
}

