/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.security.AccessControlContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.dna.graph.BasicExecutionContext;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.ExecutionContextFactory;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.basic.BasicNamespaceRegistry;

public class BasicExecutionContextFactory
implements ExecutionContextFactory {
    private final NamespaceRegistry defaultNamespaces = new BasicNamespaceRegistry();

    public BasicExecutionContextFactory() {
        this.defaultNamespaces.register("jcr", "http://www.jcp.org/jcr/1.0");
        this.defaultNamespaces.register("mix", "http://www.jcp.org/jcr/mix/1.0");
        this.defaultNamespaces.register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.defaultNamespaces.register("dna", "http://www.jboss.org/dna");
        this.defaultNamespaces.register("dnadtd", "http://www.jboss.org/dna/dtd/1.0");
        this.defaultNamespaces.register("dnaxml", "http://www.jboss.org/dna/xml/1.0");
    }

    public BasicExecutionContextFactory(String defaultNamespaceUri) {
        this();
        this.defaultNamespaces.register("", defaultNamespaceUri);
    }

    public NamespaceRegistry getDefaultNamespaces() {
        return this.defaultNamespaces;
    }

    public ExecutionContext create() {
        BasicExecutionContext context = new BasicExecutionContext();
        this.initialize(context);
        return context;
    }

    public ExecutionContext create(AccessControlContext accessControlContext) {
        BasicExecutionContext context = new BasicExecutionContext(accessControlContext);
        this.initialize(context);
        return context;
    }

    public ExecutionContext create(LoginContext loginContext) {
        BasicExecutionContext context = new BasicExecutionContext(loginContext);
        this.initialize(context);
        return context;
    }

    public ExecutionContext create(String name) throws LoginException {
        LoginContext loginContext = new LoginContext(name);
        BasicExecutionContext context = new BasicExecutionContext(loginContext);
        this.initialize(context);
        return context;
    }

    public ExecutionContext create(String name, Subject subject) throws LoginException {
        LoginContext loginContext = new LoginContext(name, subject);
        BasicExecutionContext context = new BasicExecutionContext(loginContext);
        this.initialize(context);
        return context;
    }

    public ExecutionContext create(String name, CallbackHandler callbackHandler) throws LoginException {
        LoginContext loginContext = new LoginContext(name, callbackHandler);
        BasicExecutionContext context = new BasicExecutionContext(loginContext);
        this.initialize(context);
        return context;
    }

    public ExecutionContext create(String name, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        LoginContext loginContext = new LoginContext(name, subject, callbackHandler);
        BasicExecutionContext context = new BasicExecutionContext(loginContext);
        this.initialize(context);
        return context;
    }

    protected synchronized void initialize(ExecutionContext context) {
        for (NamespaceRegistry.Namespace namespace : this.defaultNamespaces.getNamespaces()) {
            context.getNamespaceRegistry().register(namespace.getPrefix(), namespace.getNamespaceUri());
        }
    }
}

