/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.GraphImporter;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Locations;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.Results;
import org.jboss.dna.graph.Subgraph;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.requests.CacheableRequest;
import org.jboss.dna.graph.requests.CompositeRequest;
import org.jboss.dna.graph.requests.CopyBranchRequest;
import org.jboss.dna.graph.requests.CreateNodeRequest;
import org.jboss.dna.graph.requests.DeleteBranchRequest;
import org.jboss.dna.graph.requests.MoveBranchRequest;
import org.jboss.dna.graph.requests.ReadAllChildrenRequest;
import org.jboss.dna.graph.requests.ReadAllPropertiesRequest;
import org.jboss.dna.graph.requests.ReadBlockOfChildrenRequest;
import org.jboss.dna.graph.requests.ReadBranchRequest;
import org.jboss.dna.graph.requests.ReadNodeRequest;
import org.jboss.dna.graph.requests.ReadPropertyRequest;
import org.jboss.dna.graph.requests.RemovePropertiesRequest;
import org.jboss.dna.graph.requests.Request;
import org.jboss.dna.graph.requests.UpdatePropertiesRequest;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class Graph {
    private final String sourceName;
    private final RepositoryConnectionFactory connectionFactory;
    private final ExecutionContext context;
    private final RequestQueue requestQueue;
    private final Conjunction<Graph> nextGraph;

    public static Graph create(String sourceName, RepositoryConnectionFactory connectionFactory, ExecutionContext context) {
        return new Graph(sourceName, connectionFactory, context);
    }

    protected Graph(String sourceName, RepositoryConnectionFactory connectionFactory, ExecutionContext context) {
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        CheckArg.isNotNull((Object)context, (String)"context");
        this.sourceName = sourceName;
        this.connectionFactory = connectionFactory;
        this.context = context;
        this.requestQueue = new GraphRequestQueue();
        this.nextGraph = new Conjunction<Graph>(){

            @Override
            public Graph and() {
                return Graph.this;
            }
        };
    }

    public RepositoryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    RequestQueue queue() {
        return this.requestQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachePolicy getDefaultCachePolicy() {
        RepositoryConnection connection = this.connectionFactory.createConnection(this.getSourceName());
        if (connection == null) {
            throw new RepositorySourceException(GraphI18n.unableToFindRepositorySourceWithName.text(new Object[]{this.getSourceName()}));
        }
        try {
            CachePolicy cachePolicy = connection.getDefaultCachePolicy();
            return cachePolicy;
        }
        finally {
            connection.close();
        }
    }

    public Move<Conjunction<Graph>> move(Node from) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, this.requestQueue, from.getLocation());
    }

    public Move<Conjunction<Graph>> move(Location from) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, this.requestQueue, from);
    }

    public Move<Conjunction<Graph>> move(String fromPath) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, this.requestQueue, new Location(this.createPath(fromPath)));
    }

    public Move<Conjunction<Graph>> move(Path from) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, this.requestQueue, new Location(from));
    }

    public Move<Conjunction<Graph>> move(UUID from) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, this.requestQueue, new Location(from));
    }

    public Move<Conjunction<Graph>> move(Property idProperty) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, this.requestQueue, new Location(idProperty));
    }

    public Move<Conjunction<Graph>> move(Property firstIdProperty, Property ... additionalIdProperties) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, this.requestQueue, new Location(firstIdProperty, additionalIdProperties));
    }

    public Copy<Graph> copy(Node from) {
        return new CopyAction<Graph>(this, this.requestQueue, from.getLocation());
    }

    public Copy<Graph> copy(Location from) {
        return new CopyAction<Graph>(this, this.requestQueue, from);
    }

    public Copy<Graph> copy(String fromPath) {
        return new CopyAction<Graph>(this, this.requestQueue, new Location(this.createPath(fromPath)));
    }

    public Copy<Graph> copy(Path from) {
        return new CopyAction<Graph>(this, this.requestQueue, new Location(from));
    }

    public Copy<Graph> copy(UUID from) {
        return new CopyAction<Graph>(this, this.requestQueue, new Location(from));
    }

    public Copy<Graph> copy(Property idProperty) {
        return new CopyAction<Graph>(this, this.requestQueue, new Location(idProperty));
    }

    public Copy<Graph> copy(Property firstIdProperty, Property ... additionalIdProperties) {
        return new CopyAction<Graph>(this, this.requestQueue, new Location(firstIdProperty, additionalIdProperties));
    }

    public Conjunction<Graph> delete(Node at) {
        this.requestQueue.submit(new DeleteBranchRequest(at.getLocation()));
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(Location at) {
        this.requestQueue.submit(new DeleteBranchRequest(at));
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(String atPath) {
        this.requestQueue.submit(new DeleteBranchRequest(new Location(this.createPath(atPath))));
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(Path at) {
        this.requestQueue.submit(new DeleteBranchRequest(new Location(at)));
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(UUID at) {
        this.requestQueue.submit(new DeleteBranchRequest(new Location(at)));
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(Property idProperty) {
        this.requestQueue.submit(new DeleteBranchRequest(new Location(idProperty)));
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(Property firstIdProperty, Property ... additionalIdProperties) {
        this.requestQueue.submit(new DeleteBranchRequest(new Location(firstIdProperty, additionalIdProperties)));
        return this.nextGraph;
    }

    public Conjunction<Graph> create(String atPath) {
        this.requestQueue.submit(new CreateNodeRequest(new Location(this.createPath(atPath)), new Property[0]));
        return this.nextGraph;
    }

    public Conjunction<Graph> create(String atPath, Property ... properties) {
        this.requestQueue.submit(new CreateNodeRequest(new Location(this.createPath(atPath)), properties));
        return this.nextGraph;
    }

    public Conjunction<Graph> create(Path at) {
        this.requestQueue.submit(new CreateNodeRequest(new Location(at), new Property[0]));
        return this.nextGraph;
    }

    public Conjunction<Graph> create(Path at, Property ... properties) {
        this.requestQueue.submit(new CreateNodeRequest(new Location(at), properties));
        return this.nextGraph;
    }

    public Conjunction<Graph> create(Path at, Iterable<Property> properties) {
        this.requestQueue.submit(new CreateNodeRequest(new Location(at), properties));
        return this.nextGraph;
    }

    public On<Conjunction<Graph>> set(final Property ... properties) {
        return new On<Conjunction<Graph>>(){

            @Override
            public Conjunction<Graph> on(Location location) {
                UpdatePropertiesRequest request = new UpdatePropertiesRequest(location, properties);
                Graph.this.queue().submit(request);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> on(String path) {
                return this.on(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> on(Path path) {
                return this.on(new Location(path));
            }

            @Override
            public Conjunction<Graph> on(Property idProperty) {
                return this.on(new Location(idProperty));
            }

            @Override
            public Conjunction<Graph> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> on(UUID uuid) {
                return this.on(new Location(uuid));
            }
        };
    }

    public On<Conjunction<Graph>> remove(final Name ... propertyNames) {
        return new On<Conjunction<Graph>>(){

            @Override
            public Conjunction<Graph> on(Location location) {
                RemovePropertiesRequest request = new RemovePropertiesRequest(location, propertyNames);
                Graph.this.queue().submit(request);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> on(String path) {
                return this.on(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> on(Path path) {
                return this.on(new Location(path));
            }

            @Override
            public Conjunction<Graph> on(Property idProperty) {
                return this.on(new Location(idProperty));
            }

            @Override
            public Conjunction<Graph> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> on(UUID uuid) {
                return this.on(new Location(uuid));
            }
        };
    }

    public On<Conjunction<Graph>> remove(String ... propertyNames) {
        NameFactory nameFactory = this.getContext().getValueFactories().getNameFactory();
        final LinkedList names = new LinkedList();
        for (String propertyName : propertyNames) {
            names.add(nameFactory.create(propertyName));
        }
        return new On<Conjunction<Graph>>(){

            @Override
            public Conjunction<Graph> on(Location location) {
                RemovePropertiesRequest request = new RemovePropertiesRequest(location, names);
                Graph.this.queue().submit(request);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> on(String path) {
                return this.on(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> on(Path path) {
                return this.on(new Location(path));
            }

            @Override
            public Conjunction<Graph> on(Property idProperty) {
                return this.on(new Location(idProperty));
            }

            @Override
            public Conjunction<Graph> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> on(UUID uuid) {
                return this.on(new Location(uuid));
            }
        };
    }

    public On<Collection<Property>> getProperties() {
        return new On<Collection<Property>>(){

            @Override
            public Collection<Property> on(Location location) {
                ReadAllPropertiesRequest request = new ReadAllPropertiesRequest(location);
                Graph.this.queue().submit(request);
                return request.getProperties();
            }

            @Override
            public Collection<Property> on(String path) {
                return this.on(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Collection<Property> on(Path path) {
                return this.on(new Location(path));
            }

            @Override
            public Collection<Property> on(Property idProperty) {
                return this.on(new Location(idProperty));
            }

            @Override
            public Collection<Property> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Collection<Property> on(UUID uuid) {
                return this.on(new Location(uuid));
            }
        };
    }

    public On<Map<Name, Property>> getPropertiesByName() {
        return new On<Map<Name, Property>>(){

            @Override
            public Map<Name, Property> on(Location location) {
                ReadAllPropertiesRequest request = new ReadAllPropertiesRequest(location);
                Graph.this.queue().submit(request);
                return request.getPropertiesByName();
            }

            @Override
            public Map<Name, Property> on(String path) {
                return this.on(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Map<Name, Property> on(Path path) {
                return this.on(new Location(path));
            }

            @Override
            public Map<Name, Property> on(Property idProperty) {
                return this.on(new Location(idProperty));
            }

            @Override
            public Map<Name, Property> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Map<Name, Property> on(UUID uuid) {
                return this.on(new Location(uuid));
            }
        };
    }

    public Of<List<Location>> getChildren() {
        return new Of<List<Location>>(){

            @Override
            public List<Location> of(String path) {
                return this.of(new Location(Graph.this.createPath(path)));
            }

            @Override
            public List<Location> of(Path path) {
                return this.of(new Location(path));
            }

            @Override
            public List<Location> of(Property idProperty) {
                return this.of(new Location(idProperty));
            }

            @Override
            public List<Location> of(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.of(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public List<Location> of(UUID uuid) {
                return this.of(new Location(uuid));
            }

            @Override
            public List<Location> of(Location at) {
                ReadAllChildrenRequest request = new ReadAllChildrenRequest(at);
                Graph.this.queue().submit(request);
                return request.getChildren();
            }
        };
    }

    public Of<List<Location>> getChildrenInRange(int startingIndex, int endingIndex) {
        CheckArg.isNonNegative((int)startingIndex, (String)"startingIndex");
        CheckArg.isPositive((int)endingIndex, (String)"endingIndex");
        int count = endingIndex - startingIndex;
        return this.getChildrenInBlock(startingIndex, count);
    }

    public Of<List<Location>> getChildrenInBlock(final int startingIndex, final int blockSize) {
        CheckArg.isNonNegative((int)startingIndex, (String)"startingIndex");
        CheckArg.isPositive((int)blockSize, (String)"blockSize");
        return new Of<List<Location>>(){

            @Override
            public List<Location> of(String path) {
                return this.of(new Location(Graph.this.createPath(path)));
            }

            @Override
            public List<Location> of(Path path) {
                return this.of(new Location(path));
            }

            @Override
            public List<Location> of(Property idProperty) {
                return this.of(new Location(idProperty));
            }

            @Override
            public List<Location> of(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.of(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public List<Location> of(UUID uuid) {
                return this.of(new Location(uuid));
            }

            @Override
            public List<Location> of(Location at) {
                ReadBlockOfChildrenRequest request = new ReadBlockOfChildrenRequest(at, startingIndex, blockSize);
                Graph.this.queue().submit(request);
                return request.getChildren();
            }
        };
    }

    public On<Property> getProperty(String name) {
        Name nameObj = (Name)this.context.getValueFactories().getNameFactory().create(name);
        return this.getProperty(nameObj);
    }

    public On<Property> getProperty(final Name name) {
        return new On<Property>(){

            @Override
            public Property on(String path) {
                return this.on(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Property on(Path path) {
                return this.on(new Location(path));
            }

            @Override
            public Property on(Property idProperty) {
                return this.on(new Location(idProperty));
            }

            @Override
            public Property on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Property on(UUID uuid) {
                return this.on(new Location(uuid));
            }

            @Override
            public Property on(Location at) {
                ReadPropertyRequest request = new ReadPropertyRequest(at, name);
                Graph.this.queue().submit(request);
                return request.getProperty();
            }
        };
    }

    public Node getNodeAt(UUID uuid) {
        return this.getNodeAt(new Location(uuid));
    }

    public Node getNodeAt(Location location) {
        ReadNodeRequest request = new ReadNodeRequest(location);
        this.requestQueue.submit(request);
        return new GraphNode(request);
    }

    public Node getNodeAt(String path) {
        return this.getNodeAt(new Location(this.createPath(path)));
    }

    public Node getNodeAt(Path path) {
        return this.getNodeAt(new Location(path));
    }

    public Node getNodeAt(Property idProperty) {
        return this.getNodeAt(new Location(idProperty));
    }

    public Node getNodeAt(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.getNodeAt(new Location(firstIdProperty, additionalIdProperties));
    }

    public At<Subgraph> getSubgraphOfDepth(final int depth) {
        return new At<Subgraph>(){

            @Override
            public Subgraph at(Location location) {
                ReadBranchRequest request = new ReadBranchRequest(location, depth);
                Graph.this.queue().submit(request);
                return new SubgraphResults(request);
            }

            @Override
            public Subgraph at(String path) {
                return this.at(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Subgraph at(Path path) {
                return this.at(new Location(path));
            }

            @Override
            public Subgraph at(UUID uuid) {
                return this.at(new Location(uuid));
            }

            @Override
            public Subgraph at(Property idProperty) {
                return this.at(new Location(idProperty));
            }

            @Override
            public Subgraph at(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.at(new Location(firstIdProperty, additionalIdProperties));
            }
        };
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(final URI uri) {
        return new ImportInto<Conjunction<Graph>>(){
            private boolean skipRootElement = false;

            @Override
            public ImportInto<Conjunction<Graph>> skippingRootElement(boolean skipRootElement) {
                this.skipRootElement = skipRootElement;
                return this;
            }

            @Override
            public Conjunction<Graph> into(String path) throws IOException, SAXException {
                return this.into(new Location(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> into(Path path) throws IOException, SAXException {
                return this.into(new Location(path));
            }

            @Override
            public Conjunction<Graph> into(Property idProperty) throws IOException, SAXException {
                return this.into(new Location(idProperty));
            }

            @Override
            public Conjunction<Graph> into(Property firstIdProperty, Property ... additionalIdProperties) throws IOException, SAXException {
                return this.into(new Location(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> into(UUID uuid) throws IOException, SAXException {
                return this.into(new Location(uuid));
            }

            @Override
            public Conjunction<Graph> into(Location at) throws IOException, SAXException {
                GraphImporter importer = new GraphImporter(Graph.this);
                importer.importXml(uri, at, this.skipRootElement).execute();
                return Graph.this.nextGraph;
            }
        };
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(String pathToFile) {
        CheckArg.isNotNull((Object)pathToFile, (String)"pathToFile");
        return this.importXmlFrom(new File(pathToFile).toURI());
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(File file) {
        CheckArg.isNotNull((Object)file, (String)"file");
        return this.importXmlFrom(file.toURI());
    }

    Path createPath(String path) {
        return (Path)this.getContext().getValueFactories().getPathFactory().create(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Request request) {
        RepositoryConnection connection = this.getConnectionFactory().createConnection(this.getSourceName());
        if (connection == null) {
            throw new RepositorySourceException(GraphI18n.unableToFindRepositorySourceWithName.text(new Object[]{this.getSourceName()}));
        }
        try {
            connection.execute(this.getContext(), request);
        }
        finally {
            connection.close();
        }
        if (request.hasError()) {
            Throwable error = request.getError();
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RepositorySourceException(this.getSourceName(), error);
        }
    }

    List<Path.Segment> getSegments(List<Location> locations) {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(locations.size());
        for (Location location : locations) {
            segments.add(location.getPath().getLastSegment());
        }
        return segments;
    }

    public Batch batch() {
        return new Batch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    static class CreateAction<T>
    extends AbstractAction<T>
    implements Create<T> {
        private final Location at;
        private final List<Property> properties = new LinkedList<Property>();

        CreateAction(T afterConjunction, RequestQueue queue, Location at) {
            super(afterConjunction, queue);
            this.at = at;
        }

        @Override
        public Create<T> and(UUID uuid) {
            PropertyFactory factory = this.queue().getGraph().getContext().getPropertyFactory();
            this.properties.add(factory.create(DnaLexicon.UUID, uuid));
            return this;
        }

        @Override
        public Create<T> and(Property property) {
            this.properties.add(property);
            return this;
        }

        @Override
        public Create<T> and(String name, Object ... values) {
            ExecutionContext context = this.queue().getGraph().getContext();
            PropertyFactory factory = context.getPropertyFactory();
            NameFactory nameFactory = context.getValueFactories().getNameFactory();
            this.properties.add(factory.create((Name)nameFactory.create(name), values));
            return this;
        }

        @Override
        public Create<T> and(Name name, Object ... values) {
            ExecutionContext context = this.queue().getGraph().getContext();
            PropertyFactory factory = context.getPropertyFactory();
            this.properties.add(factory.create(name, values));
            return this;
        }

        @Override
        public Create<T> and(Property property, Property ... additionalProperties) {
            this.properties.add(property);
            for (Property additionalProperty : additionalProperties) {
                this.properties.add(additionalProperty);
            }
            return this;
        }

        @Override
        public Create<T> with(UUID uuid) {
            return this.and(uuid);
        }

        @Override
        public Create<T> with(Property property) {
            return this.and(property);
        }

        @Override
        public Create<T> with(Property property, Property ... additionalProperties) {
            return this.and(property, additionalProperties);
        }

        @Override
        public Create<T> with(String name, Object ... values) {
            return this.and(name, values);
        }

        @Override
        public Create<T> with(Name name, Object ... values) {
            return this.and(name, values);
        }

        @Override
        public T and() {
            this.queue().submit(new CreateNodeRequest(this.at, this.properties));
            return super.and();
        }

        @Override
        public Results execute() {
            return this.queue().execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    static class CopyAction<T>
    extends AbstractAction<T>
    implements Copy<T> {
        private final Locations from;

        CopyAction(T afterConjunction, RequestQueue queue, Location from) {
            super(afterConjunction, queue);
            this.from = new Locations(from);
        }

        @Override
        public Copy<T> and(Location from) {
            this.from.add(from);
            return this;
        }

        @Override
        public Copy<T> and(String from) {
            this.from.add(new Location(this.createPath(from)));
            return this;
        }

        @Override
        public Copy<T> and(Path from) {
            this.from.add(new Location(from));
            return this;
        }

        @Override
        public Copy<T> and(Property firstFrom, Property ... additionalFroms) {
            this.from.add(new Location(firstFrom, additionalFroms));
            return this;
        }

        @Override
        public Copy<T> and(Property from) {
            this.from.add(new Location(from));
            return this;
        }

        @Override
        public Copy<T> and(UUID from) {
            this.from.add(new Location(from));
            return this;
        }

        private T submit(Location into) {
            if (this.from.hasNext()) {
                LinkedList<Request> requests = new LinkedList<Request>();
                Locations locations = this.from;
                while (locations.hasNext()) {
                    Location location = locations.getLocation();
                    requests.add(new CopyBranchRequest(location, into));
                    locations = locations.next();
                }
                this.queue().submit(requests);
            } else {
                this.queue().submit(new CopyBranchRequest(this.from.getLocation(), into));
            }
            return this.and();
        }

        @Override
        public T into(Location into) {
            return this.submit(into);
        }

        @Override
        public T into(Path into) {
            return this.submit(new Location(into));
        }

        @Override
        public T into(UUID into) {
            return this.submit(new Location(into));
        }

        @Override
        public T into(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.submit(new Location(firstIdProperty, additionalIdProperties));
        }

        @Override
        public T into(Property into) {
            return this.submit(new Location(into));
        }

        @Override
        public T into(String into) {
            return this.submit(new Location(this.createPath(into)));
        }

        @Override
        public Results execute() {
            return this.queue().execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    static class MoveAction<T>
    extends AbstractAction<T>
    implements Move<T> {
        private final Locations from;

        MoveAction(T afterConjunction, RequestQueue queue, Location from) {
            super(afterConjunction, queue);
            this.from = new Locations(from);
        }

        @Override
        public Move<T> and(Location from) {
            this.from.add(from);
            return this;
        }

        @Override
        public Move<T> and(String from) {
            this.from.add(new Location(this.createPath(from)));
            return this;
        }

        @Override
        public Move<T> and(Path from) {
            this.from.add(new Location(from));
            return this;
        }

        @Override
        public Move<T> and(Property firstFrom, Property ... additionalFroms) {
            this.from.add(new Location(firstFrom, additionalFroms));
            return this;
        }

        @Override
        public Move<T> and(Property from) {
            this.from.add(new Location(from));
            return this;
        }

        @Override
        public Move<T> and(UUID from) {
            this.from.add(new Location(from));
            return this;
        }

        private T submit(Location into) {
            if (this.from.hasNext()) {
                LinkedList<Request> requests = new LinkedList<Request>();
                Locations locations = this.from;
                while (locations.hasNext()) {
                    Location location = locations.getLocation();
                    requests.add(new MoveBranchRequest(location, into));
                    locations = locations.next();
                }
                this.queue().submit(requests);
            } else {
                this.queue().submit(new MoveBranchRequest(this.from.getLocation(), into));
            }
            return this.and();
        }

        @Override
        public T into(Location into) {
            return this.submit(into);
        }

        @Override
        public T into(Path into) {
            return this.submit(new Location(into));
        }

        @Override
        public T into(UUID into) {
            return this.submit(new Location(into));
        }

        @Override
        public T into(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.submit(new Location(firstIdProperty, additionalIdProperties));
        }

        @Override
        public T into(Property into) {
            return this.submit(new Location(into));
        }

        @Override
        public T into(String into) {
            return this.submit(new Location(this.createPath(into)));
        }

        @Override
        public Results execute() {
            return this.queue().execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static abstract class AbstractAction<T>
    implements Conjunction<T>,
    Executable {
        private final RequestQueue queue;
        private final T afterConjunction;

        AbstractAction(T afterConjunction, RequestQueue queue) {
            this.queue = queue;
            this.afterConjunction = afterConjunction;
        }

        RequestQueue queue() {
            return this.queue;
        }

        @Override
        public T and() {
            return this.afterConjunction;
        }

        Path createPath(String path) {
            return (Path)this.queue.getGraph().getContext().getValueFactories().getPathFactory().create(path);
        }

        @Override
        public Results execute() {
            return this.queue.execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class SubgraphNode
    implements Node {
        private final Location location;
        private final ReadBranchRequest request;

        SubgraphNode(Location location, ReadBranchRequest request) {
            this.location = location;
            this.request = request;
        }

        @Override
        public List<Location> getChildren() {
            return this.request.getChildren(this.location);
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public Collection<Property> getProperties() {
            return this.getPropertiesByName().values();
        }

        @Override
        public Map<Name, Property> getPropertiesByName() {
            return this.request.getPropertiesFor(this.location);
        }

        @Override
        public Property getProperty(Name name) {
            return this.getPropertiesByName().get(name);
        }

        @Override
        public Property getProperty(String nameStr) {
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(nameStr);
            return this.getPropertiesByName().get(name);
        }

        @Override
        public boolean hasChildren() {
            return this.getChildren().size() != 0;
        }

        @Override
        public List<Path.Segment> getChildrenSegments() {
            return Graph.this.getSegments(this.getChildren());
        }

        @Override
        public Iterator<Location> iterator() {
            return this.getChildren().iterator();
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                return this.location.equals(that.getLocation());
            }
            return false;
        }

        public String toString() {
            return "Node " + this.getLocation().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class SubgraphResults
    implements Subgraph {
        private final ReadBranchRequest request;

        SubgraphResults(ReadBranchRequest request) {
            this.request = request;
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Location getLocation() {
            return this.request.getActualLocationOfNode();
        }

        @Override
        public Node getRoot() {
            return this.getNode(this.getLocation());
        }

        @Override
        public int getMaximumDepth() {
            return this.request.maximumDepth();
        }

        @Override
        public Iterator<Node> iterator() {
            final Iterator<Location> iter = this.request.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Node next() {
                    return SubgraphResults.this.getNode((Location)iter.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean includes(Path path) {
            CheckArg.isNotNull((Object)path, (String)"path");
            path = this.getAbsolutePath(path);
            return this.request.includes(path);
        }

        @Override
        public boolean includes(Location location) {
            CheckArg.isNotNull((Object)location, (String)"location");
            return this.request.includes(location);
        }

        @Override
        public boolean includes(String pathStr) {
            Path path = Graph.this.createPath(pathStr);
            path = this.getAbsolutePath(path);
            return this.includes(path);
        }

        @Override
        public Node getNode(Location location) {
            if (!location.hasPath()) {
                return null;
            }
            Location actualLocation = this.request.getLocationFor(location.getPath());
            if (actualLocation == null) {
                return null;
            }
            return new SubgraphNode(actualLocation, this.request);
        }

        @Override
        public Node getNode(Path path) {
            if (!this.includes(path = this.getAbsolutePath(path))) {
                return null;
            }
            Location location = this.request.getLocationFor(path);
            if (location == null) {
                return null;
            }
            return new SubgraphNode(location, this.request);
        }

        @Override
        public Node getNode(String pathStr) {
            CheckArg.isNotEmpty((String)pathStr, (String)"path");
            Path path = Graph.this.createPath(pathStr);
            path = this.getAbsolutePath(path);
            return this.getNode(path);
        }

        protected Path getAbsolutePath(Path absoluteOrRelative) {
            Path result = absoluteOrRelative;
            if (!result.isAbsolute()) {
                result = this.getGraph().getContext().getValueFactories().getPathFactory().create(this.getLocation().getPath(), result);
                result = result.getNormalizedPath();
            }
            return result;
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public String toString() {
            return "Subgraph " + this.getLocation().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class BatchResultsNode
    implements Node {
        private final Location location;
        private Map<Name, Property> properties;
        private List<Location> children;

        BatchResultsNode(Location location) {
            this.location = location;
        }

        void addProperty(Property property) {
            if (this.properties == null) {
                this.properties = new HashMap<Name, Property>();
            }
            this.properties.put(property.getName(), property);
        }

        void setProperties(Map<Name, Property> properties) {
            this.properties = properties;
        }

        void setChildren(List<Location> children) {
            this.children = children;
        }

        void freeze() {
            this.properties = this.properties != null ? Collections.unmodifiableMap(this.properties) : Collections.emptyMap();
            this.children = this.children != null ? Collections.unmodifiableList(this.children) : Collections.emptyList();
        }

        @Override
        public List<Path.Segment> getChildrenSegments() {
            return Graph.this.getSegments(this.getChildren());
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public Collection<Property> getProperties() {
            return this.properties.values();
        }

        @Override
        public Map<Name, Property> getPropertiesByName() {
            return this.properties;
        }

        @Override
        public Property getProperty(Name name) {
            return this.properties.get(name);
        }

        @Override
        public Property getProperty(String nameStr) {
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(nameStr);
            return this.properties.get(name);
        }

        @Override
        public List<Location> getChildren() {
            return this.children;
        }

        @Override
        public boolean hasChildren() {
            return this.children.size() != 0;
        }

        @Override
        public Iterator<Location> iterator() {
            return this.children.iterator();
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                return this.location.equals(that.getLocation());
            }
            return false;
        }

        public String toString() {
            return "Node " + this.getLocation().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class BatchResults
    implements Results {
        private final Map<Path, BatchResultsNode> nodes = new HashMap<Path, BatchResultsNode>();

        BatchResults(List<Request> requests) {
            for (Request request : requests) {
                CacheableRequest read;
                if (request instanceof ReadAllPropertiesRequest) {
                    read = (ReadAllPropertiesRequest)request;
                    this.getOrCreateNode(((ReadAllPropertiesRequest)read).getActualLocationOfNode()).setProperties(((ReadAllPropertiesRequest)read).getPropertiesByName());
                    continue;
                }
                if (request instanceof ReadPropertyRequest) {
                    read = (ReadPropertyRequest)request;
                    this.getOrCreateNode(((ReadPropertyRequest)read).getActualLocationOfNode()).addProperty(((ReadPropertyRequest)read).getProperty());
                    continue;
                }
                if (request instanceof ReadNodeRequest) {
                    read = (ReadNodeRequest)request;
                    BatchResultsNode node = this.getOrCreateNode(((ReadNodeRequest)read).getActualLocationOfNode());
                    node.setProperties(((ReadNodeRequest)read).getPropertiesByName());
                    node.setChildren(((ReadNodeRequest)read).getChildren());
                    continue;
                }
                if (request instanceof ReadBlockOfChildrenRequest) {
                    throw new IllegalStateException();
                }
                if (request instanceof ReadAllChildrenRequest) {
                    read = (ReadAllChildrenRequest)request;
                    this.getOrCreateNode(((ReadAllChildrenRequest)read).getActualLocationOfNode()).setChildren(((ReadAllChildrenRequest)read).getChildren());
                    continue;
                }
                if (!(request instanceof ReadBranchRequest)) continue;
                read = (ReadBranchRequest)request;
                Iterator<Location> i$ = ((ReadBranchRequest)read).iterator();
                while (i$.hasNext()) {
                    Location location = i$.next();
                    BatchResultsNode node = this.getOrCreateNode(location);
                    node.setProperties(((ReadBranchRequest)read).getPropertiesFor(location));
                    node.setChildren(((ReadBranchRequest)read).getChildren(location));
                }
            }
            for (Map.Entry entry : this.nodes.entrySet()) {
                ((BatchResultsNode)entry.getValue()).freeze();
            }
        }

        private BatchResultsNode getOrCreateNode(Location location) {
            BatchResultsNode node = this.nodes.get(location);
            if (node == null) {
                node = new BatchResultsNode(location);
                assert (location.getPath() != null);
                this.nodes.put(location.getPath(), node);
            }
            return node;
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        protected void checkIsAbsolute(Path path) {
            if (!path.isAbsolute()) {
                throw new IllegalArgumentException(GraphI18n.pathIsNotAbsolute.text(new Object[]{path}));
            }
        }

        @Override
        public Node getNode(String pathStr) {
            Path path = Graph.this.createPath(pathStr);
            this.checkIsAbsolute(path);
            return this.nodes.get(path);
        }

        @Override
        public Node getNode(Path path) {
            CheckArg.isNotNull((Object)path, (String)"path");
            this.checkIsAbsolute(path);
            return this.nodes.get(path);
        }

        @Override
        public Node getNode(Location location) {
            CheckArg.isNotNull((Object)location, (String)"location");
            CheckArg.isNotNull((Object)location.getPath(), (String)"location.getPath()");
            return this.nodes.get(location.getPath());
        }

        @Override
        public boolean includes(String path) {
            return this.getNode(path) != null;
        }

        @Override
        public boolean includes(Path path) {
            return this.getNode(path) != null;
        }

        @Override
        public boolean includes(Location location) {
            return this.getNode(location) != null;
        }

        @Override
        public Iterator<Node> iterator() {
            ArrayList<Path> paths = new ArrayList<Path>(this.nodes.keySet());
            Collections.sort(paths);
            final Iterator pathIter = paths.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return pathIter.hasNext();
                }

                @Override
                public Node next() {
                    Path nextPath = (Path)pathIter.next();
                    return BatchResults.this.getNode(nextPath);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected class GraphNode
    implements Node {
        private final ReadNodeRequest request;

        GraphNode(ReadNodeRequest request) {
            this.request = request;
        }

        @Override
        public Location getLocation() {
            return this.request.getActualLocationOfNode();
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Collection<Property> getProperties() {
            return this.request.getProperties();
        }

        @Override
        public Property getProperty(Name name) {
            return this.getPropertiesByName().get(name);
        }

        @Override
        public Property getProperty(String nameStr) {
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(nameStr);
            return this.getPropertiesByName().get(name);
        }

        @Override
        public Map<Name, Property> getPropertiesByName() {
            return this.request.getPropertiesByName();
        }

        @Override
        public List<Location> getChildren() {
            return this.request.getChildren();
        }

        @Override
        public boolean hasChildren() {
            return this.request.getChildren().size() > 0;
        }

        @Override
        public List<Path.Segment> getChildrenSegments() {
            return Graph.this.getSegments(this.getChildren());
        }

        @Override
        public Iterator<Location> iterator() {
            return this.request.getChildren().iterator();
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                return this.getLocation().equals(that.getLocation());
            }
            return false;
        }

        public String toString() {
            return "Node " + this.getLocation().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    class CompositingRequestQueue
    implements RequestQueue {
        private final List<Request> requests = new LinkedList<Request>();

        CompositingRequestQueue() {
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        public List<Request> getRequests() {
            return this.requests;
        }

        @Override
        public void submit(Request request) {
            this.requests.add(request);
        }

        @Override
        public void submit(List<Request> requests) {
            this.requests.addAll(requests);
        }

        @Override
        public Results execute() {
            if (!this.requests.isEmpty()) {
                Request request = CompositeRequest.with(this.requests);
                Graph.this.execute(request);
            }
            return new BatchResults(this.requests);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    class GraphRequestQueue
    implements RequestQueue {
        GraphRequestQueue() {
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public void submit(Request request) {
            Graph.this.execute(request);
        }

        @Override
        public void submit(List<Request> requests) {
            Request request = CompositeRequest.with(requests);
            Graph.this.execute(request);
        }

        @Override
        public Results execute() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RequestQueue
    extends Executable {
        public Graph getGraph();

        public void submit(Request var1);

        public void submit(List<Request> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BatchConjunction
    extends Conjunction<Batch>,
    Executable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ImportInto<Next> {
        public ImportInto<Next> skippingRootElement(boolean var1);

        public Next into(Location var1) throws IOException, SAXException;

        public Next into(String var1) throws IOException, SAXException;

        public Next into(Path var1) throws IOException, SAXException;

        public Next into(UUID var1) throws IOException, SAXException;

        public Next into(Property var1) throws IOException, SAXException;

        public Next into(Property var1, Property ... var2) throws IOException, SAXException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface At<Next> {
        public Next at(Location var1);

        public Next at(String var1);

        public Next at(Path var1);

        public Next at(UUID var1);

        public Next at(Property var1);

        public Next at(Property var1, Property ... var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Of<Next> {
        public Next of(Location var1);

        public Next of(String var1);

        public Next of(Path var1);

        public Next of(UUID var1);

        public Next of(Property var1);

        public Next of(Property var1, Property ... var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface On<Next> {
        public Next on(Location var1);

        public Next on(String var1);

        public Next on(Path var1);

        public Next on(UUID var1);

        public Next on(Property var1);

        public Next on(Property var1, Property ... var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Create<Next>
    extends Conjunction<Next>,
    Executable {
        public Create<Next> with(UUID var1);

        public Create<Next> with(Property var1);

        public Create<Next> with(String var1, Object ... var2);

        public Create<Next> with(Name var1, Object ... var2);

        public Create<Next> with(Property var1, Property ... var2);

        public Create<Next> and(UUID var1);

        public Create<Next> and(Property var1);

        public Create<Next> and(String var1, Object ... var2);

        public Create<Next> and(Name var1, Object ... var2);

        public Create<Next> and(Property var1, Property ... var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Copy<Next>
    extends Into<Next>,
    And<Copy<Next>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Move<Next>
    extends Into<Next>,
    And<Move<Next>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface And<Next> {
        public Next and(Location var1);

        public Next and(String var1);

        public Next and(Path var1);

        public Next and(UUID var1);

        public Next and(Property var1);

        public Next and(Property var1, Property ... var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Into<Next> {
        public Next into(Location var1);

        public Next into(String var1);

        public Next into(Path var1);

        public Next into(UUID var1);

        public Next into(Property var1);

        public Next into(Property var1, Property ... var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Conjunction<Next> {
        public Next and();
    }

    public static interface Executable {
        public Results execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public final class Batch
    implements Executable {
        protected final CompositingRequestQueue requestQueue;
        protected final BatchConjunction nextRequests;
        protected boolean executed;

        Batch() {
            this.requestQueue = new CompositingRequestQueue();
            this.executed = false;
            this.nextRequests = new BatchConjunction(){

                public Batch and() {
                    return Batch.this;
                }

                public Results execute() {
                    Batch.this.executed = true;
                    return Batch.this.requestQueue.execute();
                }
            };
        }

        public Graph getGraph() {
            return Graph.this;
        }

        protected final void assertNotExecuted() {
            if (this.executed) {
                throw new IllegalStateException(GraphI18n.unableToAddMoreRequestsToAlreadyExecutedBatch.text(new Object[0]));
            }
        }

        public Move<BatchConjunction> move(Node from) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, this.requestQueue, from.getLocation());
        }

        public Move<BatchConjunction> move(Location from) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, this.requestQueue, from);
        }

        public Move<BatchConjunction> move(String fromPath) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(Graph.this.createPath(fromPath)));
        }

        public Move<BatchConjunction> move(Path from) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(from));
        }

        public Move<BatchConjunction> move(UUID from) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(from));
        }

        public Move<BatchConjunction> move(Property idProperty) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(idProperty));
        }

        public Move<BatchConjunction> move(Property firstIdProperty, Property ... additionalIdProperties) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(firstIdProperty, additionalIdProperties));
        }

        public Copy<BatchConjunction> copy(Node from) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, this.requestQueue, from.getLocation());
        }

        public Copy<BatchConjunction> copy(Location from) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, this.requestQueue, from);
        }

        public Copy<BatchConjunction> copy(String fromPath) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(Graph.this.createPath(fromPath)));
        }

        public Copy<BatchConjunction> copy(Path from) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(from));
        }

        public Copy<BatchConjunction> copy(UUID from) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(from));
        }

        public Copy<BatchConjunction> copy(Property idProperty) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(idProperty));
        }

        public Copy<BatchConjunction> copy(Property firstIdProperty, Property ... additionalIdProperties) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(firstIdProperty, additionalIdProperties));
        }

        public BatchConjunction delete(Node at) {
            this.assertNotExecuted();
            this.requestQueue.submit(new DeleteBranchRequest(at.getLocation()));
            return this.nextRequests;
        }

        public BatchConjunction delete(Location at) {
            this.assertNotExecuted();
            this.requestQueue.submit(new DeleteBranchRequest(at));
            return this.nextRequests;
        }

        public BatchConjunction delete(String atPath) {
            this.assertNotExecuted();
            this.requestQueue.submit(new DeleteBranchRequest(new Location(Graph.this.createPath(atPath))));
            return this.nextRequests;
        }

        public BatchConjunction delete(Path at) {
            this.assertNotExecuted();
            this.requestQueue.submit(new DeleteBranchRequest(new Location(at)));
            return this.nextRequests;
        }

        public BatchConjunction delete(UUID at) {
            this.assertNotExecuted();
            this.requestQueue.submit(new DeleteBranchRequest(new Location(at)));
            return this.nextRequests;
        }

        public BatchConjunction delete(Property idProperty) {
            this.assertNotExecuted();
            this.requestQueue.submit(new DeleteBranchRequest(new Location(idProperty)));
            return this.nextRequests;
        }

        public BatchConjunction delete(Property firstIdProperty, Property ... additionalIdProperties) {
            this.assertNotExecuted();
            this.requestQueue.submit(new DeleteBranchRequest(new Location(firstIdProperty, additionalIdProperties)));
            return this.nextRequests;
        }

        public Create<BatchConjunction> create(String atPath) {
            this.assertNotExecuted();
            return new CreateAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(Graph.this.createPath(atPath)));
        }

        public Create<BatchConjunction> create(String atPath, Property property) {
            this.assertNotExecuted();
            return new CreateAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(Graph.this.createPath(atPath))).with(property);
        }

        public Create<BatchConjunction> create(String atPath, Property firstProperty, Property ... additionalProperties) {
            this.assertNotExecuted();
            return new CreateAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(Graph.this.createPath(atPath))).with(firstProperty, additionalProperties);
        }

        public Create<BatchConjunction> create(Path at) {
            this.assertNotExecuted();
            return new CreateAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(at));
        }

        public Create<BatchConjunction> create(Path at, Iterable<Property> properties) {
            this.assertNotExecuted();
            CreateAction<BatchConjunction> action = new CreateAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(at));
            for (Property property : properties) {
                action.and(property);
            }
            return action;
        }

        public Create<BatchConjunction> create(Path at, Property property) {
            this.assertNotExecuted();
            return new CreateAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(at)).with(property);
        }

        public Create<BatchConjunction> create(Path at, Property firstProperty, Property ... additionalProperties) {
            this.assertNotExecuted();
            return new CreateAction<BatchConjunction>(this.nextRequests, this.requestQueue, new Location(at)).with(firstProperty, additionalProperties);
        }

        public On<BatchConjunction> set(final Property ... properties) {
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    UpdatePropertiesRequest request = new UpdatePropertiesRequest(location, properties);
                    Graph.this.queue().submit(request);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(new Location(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(new Location(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(new Location(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(new Location(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(new Location(uuid));
                }
            };
        }

        public On<BatchConjunction> remove(final Name ... propertyNames) {
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    RemovePropertiesRequest request = new RemovePropertiesRequest(location, propertyNames);
                    Graph.this.queue().submit(request);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(new Location(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(new Location(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(new Location(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(new Location(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(new Location(uuid));
                }
            };
        }

        public On<BatchConjunction> remove(String ... propertyNames) {
            NameFactory nameFactory = Graph.this.getContext().getValueFactories().getNameFactory();
            final LinkedList names = new LinkedList();
            for (String propertyName : propertyNames) {
                names.add(nameFactory.create(propertyName));
            }
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    RemovePropertiesRequest request = new RemovePropertiesRequest(location, names);
                    Graph.this.queue().submit(request);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(new Location(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(new Location(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(new Location(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(new Location(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(new Location(uuid));
                }
            };
        }

        public BatchConjunction read(UUID uuid) {
            return this.read(new Location(uuid));
        }

        public BatchConjunction read(Location location) {
            this.assertNotExecuted();
            ReadNodeRequest request = new ReadNodeRequest(location);
            this.requestQueue.submit(request);
            return this.nextRequests;
        }

        public BatchConjunction read(String path) {
            return this.read(new Location(Graph.this.createPath(path)));
        }

        public BatchConjunction read(Path path) {
            return this.read(new Location(path));
        }

        public BatchConjunction read(Property idProperty) {
            return this.read(new Location(idProperty));
        }

        public BatchConjunction read(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.read(new Location(firstIdProperty, additionalIdProperties));
        }

        public On<BatchConjunction> readProperty(String propertyName) {
            this.assertNotExecuted();
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(propertyName);
            return this.readProperty(name);
        }

        public On<BatchConjunction> readProperty(final Name name) {
            this.assertNotExecuted();
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(String path) {
                    return this.on(new Location(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(new Location(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(new Location(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(new Location(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(new Location(uuid));
                }

                @Override
                public BatchConjunction on(Location at) {
                    ReadPropertyRequest request = new ReadPropertyRequest(at, name);
                    Graph.this.queue().submit(request);
                    return Batch.this.nextRequests;
                }
            };
        }

        public On<BatchConjunction> readProperties() {
            this.assertNotExecuted();
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    ReadAllPropertiesRequest request = new ReadAllPropertiesRequest(location);
                    Graph.this.queue().submit(request);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(new Location(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(new Location(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(new Location(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(new Location(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(new Location(uuid));
                }
            };
        }

        public Of<BatchConjunction> readChildren() {
            this.assertNotExecuted();
            return new Of<BatchConjunction>(){

                @Override
                public BatchConjunction of(String path) {
                    return this.of(new Location(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction of(Path path) {
                    return this.of(new Location(path));
                }

                @Override
                public BatchConjunction of(Property idProperty) {
                    return this.of(new Location(idProperty));
                }

                @Override
                public BatchConjunction of(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.of(new Location(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction of(UUID uuid) {
                    return this.of(new Location(uuid));
                }

                @Override
                public BatchConjunction of(Location at) {
                    ReadAllChildrenRequest request = new ReadAllChildrenRequest(at);
                    Graph.this.queue().submit(request);
                    return Batch.this.nextRequests;
                }
            };
        }

        public At<BatchConjunction> readSubgraphOfDepth(final int depth) {
            this.assertNotExecuted();
            return new At<BatchConjunction>(){

                @Override
                public BatchConjunction at(Location location) {
                    ReadBranchRequest request = new ReadBranchRequest(location, depth);
                    Graph.this.queue().submit(request);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction at(String path) {
                    return this.at(new Location(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction at(Path path) {
                    return this.at(new Location(path));
                }

                @Override
                public BatchConjunction at(UUID uuid) {
                    return this.at(new Location(uuid));
                }

                @Override
                public BatchConjunction at(Property idProperty) {
                    return this.at(new Location(idProperty));
                }

                @Override
                public BatchConjunction at(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.at(new Location(firstIdProperty, additionalIdProperties));
                }
            };
        }

        @Override
        public Results execute() {
            return this.requestQueue.execute();
        }
    }
}

