/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.JcrNtLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.xml.XmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class GraphImporter {
    private final Graph graph;

    public GraphImporter(Graph graph) {
        CheckArg.isNotNull((Object)graph, (String)"graph");
        this.graph = graph;
    }

    public ExecutionContext getContext() {
        return this.graph.getContext();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graph.Batch importXml(URI uri, Location location) throws IOException, SAXException, RepositorySourceException {
        return this.importXml(uri, location, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Graph.Batch importXml(URI uri, Location location, boolean skip) throws IOException, SAXException, RepositorySourceException {
        CheckArg.isNotNull((Object)uri, (String)"uri");
        CheckArg.isNotNull((Object)location, (String)"location");
        CheckArg.isNotNull((Object)location.getPath(), (String)"location.getPath()");
        Graph.Batch batch = this.graph.batch();
        CreateOnGraphInBatch destination = new CreateOnGraphInBatch(batch);
        Path parentPath = location.getPath();
        InputStream stream = null;
        Name nameAttribute = JcrLexicon.NAME;
        Name typeAttribute = JcrLexicon.PRIMARY_TYPE;
        Name typeAttributeValue = null;
        NamespaceRegistry reg = this.graph.getContext().getNamespaceRegistry();
        if (reg.isRegisteredNamespaceUri("http://www.jcp.org/jcr/nt/1.0")) {
            typeAttributeValue = JcrNtLexicon.UNSTRUCTURED;
        }
        TextDecoder decoder = null;
        XmlHandler.AttributeScoping scoping = XmlHandler.AttributeScoping.USE_DEFAULT_NAMESPACE;
        XmlHandler handler = new XmlHandler(destination, skip, parentPath, decoder, nameAttribute, typeAttribute, typeAttributeValue, scoping);
        try {
            stream = uri.toURL().openStream();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(stream));
            Object var17_16 = null;
            if (stream == null) return batch;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
        return batch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    protected static final class CreateOnGraphInBatch
    implements XmlHandler.Destination {
        private final Graph.Batch batch;

        protected CreateOnGraphInBatch(Graph.Batch batch) {
            assert (batch != null);
            this.batch = batch;
        }

        @Override
        public ExecutionContext getExecutionContext() {
            return this.batch.getGraph().getContext();
        }

        @Override
        public void create(Path path, List<Property> properties) {
            assert (properties != null);
            if (properties.isEmpty()) {
                this.batch.create(path).and();
            } else {
                this.batch.create(path, properties).and();
            }
        }

        @Override
        public void create(Path path, Property firstProperty, Property ... additionalProperties) {
            if (firstProperty == null) {
                this.batch.create(path).and();
            } else {
                this.batch.create(path, firstProperty, additionalProperties);
            }
        }

        @Override
        public void submit() {
        }
    }
}

