/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Location
implements Iterable<Property> {
    private static final Iterator<Property> NO_ID_PROPERTIES_ITERATOR = new Iterator<Property>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Property next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private final Path path;
    private final List<Property> idProperties;

    public Location(Path path) {
        CheckArg.isNotNull((Object)path, (String)"path");
        this.path = path;
        this.idProperties = null;
    }

    public Location(UUID uuid) {
        CheckArg.isNotNull((Object)uuid, (String)"uuid");
        this.path = null;
        BasicSingleValueProperty idProperty = new BasicSingleValueProperty(DnaLexicon.UUID, uuid);
        this.idProperties = Collections.singletonList(idProperty);
    }

    public Location(Path path, UUID uuid) {
        CheckArg.isNotNull((Object)uuid, (String)"uuid");
        this.path = path;
        if (uuid != null) {
            BasicSingleValueProperty idProperty = new BasicSingleValueProperty(DnaLexicon.UUID, uuid);
            this.idProperties = Collections.singletonList(idProperty);
        } else {
            this.idProperties = null;
        }
    }

    public Location(Path path, Property idProperty) {
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)idProperty, (String)"idProperty");
        this.path = path;
        this.idProperties = idProperty != null ? Collections.singletonList(idProperty) : null;
    }

    public Location(Path path, Property firstIdProperty, Property ... remainingIdProperties) {
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)firstIdProperty, (String)"firstIdProperty");
        CheckArg.isNotNull((Object)remainingIdProperties, (String)"remainingIdProperties");
        this.path = path;
        ArrayList<Property> idProperties = new ArrayList<Property>(1 + remainingIdProperties.length);
        idProperties.add(firstIdProperty);
        for (Property property : remainingIdProperties) {
            idProperties.add(property);
        }
        this.idProperties = Collections.unmodifiableList(idProperties);
    }

    public Location(Path path, Iterable<Property> idProperties) {
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull(idProperties, (String)"idProperties");
        this.path = path;
        ArrayList<Property> idPropertiesList = new ArrayList<Property>();
        for (Property property : idProperties) {
            idPropertiesList.add(property);
        }
        this.idProperties = Collections.unmodifiableList(idPropertiesList);
    }

    public Location(Property idProperty) {
        CheckArg.isNotNull((Object)idProperty, (String)"idProperty");
        this.path = null;
        this.idProperties = Collections.singletonList(idProperty);
    }

    public Location(Property firstIdProperty, Property ... remainingIdProperties) {
        CheckArg.isNotNull((Object)firstIdProperty, (String)"firstIdProperty");
        CheckArg.isNotNull((Object)remainingIdProperties, (String)"remainingIdProperties");
        this.path = null;
        ArrayList<Property> idProperties = new ArrayList<Property>(1 + remainingIdProperties.length);
        idProperties.add(firstIdProperty);
        for (Property property : remainingIdProperties) {
            idProperties.add(property);
        }
        this.idProperties = Collections.unmodifiableList(idProperties);
    }

    public Location(Iterable<Property> idProperties) {
        CheckArg.isNotNull(idProperties, (String)"idProperties");
        this.path = null;
        ArrayList<Property> idPropertiesList = new ArrayList<Property>();
        for (Property property : idProperties) {
            idPropertiesList.add(property);
        }
        this.idProperties = Collections.unmodifiableList(idPropertiesList);
    }

    public Location(List<Property> idProperties) {
        CheckArg.isNotEmpty(idProperties, (String)"idProperties");
        this.path = null;
        this.idProperties = idProperties;
    }

    protected Location(Path path, List<Property> idProperties) {
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotEmpty(idProperties, (String)"idProperties");
        this.path = path;
        this.idProperties = idProperties;
    }

    protected Location(Location original, Property newIdProperty) {
        CheckArg.isNotNull((Object)original, (String)"original");
        this.path = original.getPath();
        if (original.hasIdProperties()) {
            List<Property> originalIdProperties = original.getIdProperties();
            if (newIdProperty == null) {
                this.idProperties = original.idProperties;
            } else {
                ArrayList<Property> idProperties = new ArrayList<Property>(originalIdProperties.size() + 1);
                for (Property property : originalIdProperties) {
                    if (newIdProperty.getName().equals(property.getName())) continue;
                    idProperties.add(property);
                }
                idProperties.add(newIdProperty);
                this.idProperties = Collections.unmodifiableList(idProperties);
            }
        } else {
            this.idProperties = Collections.singletonList(newIdProperty);
        }
    }

    protected Location(Location original, Path newPath) {
        CheckArg.isNotNull((Object)original, (String)"original");
        this.path = newPath != null ? newPath : original.getPath();
        this.idProperties = original.idProperties;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public List<Property> getIdProperties() {
        return this.idProperties;
    }

    public boolean hasIdProperties() {
        return this.idProperties != null && this.idProperties.size() != 0;
    }

    public Property getIdProperty(Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (this.idProperties != null) {
            for (Property property : this.idProperties) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
        }
        return null;
    }

    public boolean isSame(Location other) {
        return this.isSame(other, true);
    }

    public boolean isSame(Location other, boolean requireSameNameSiblingIndexes) {
        if (other != null) {
            if (this.hasPath() && other.hasPath()) {
                if (requireSameNameSiblingIndexes) {
                    if (!this.getPath().equals(other.getPath())) {
                        return false;
                    }
                } else {
                    Path thisPath = this.getPath();
                    Path thatPath = other.getPath();
                    if (thisPath.isRoot() && thatPath.isRoot()) {
                        return true;
                    }
                    if (!thisPath.hasSameAncestor(thatPath)) {
                        return false;
                    }
                    if (!thisPath.getLastSegment().getName().equals(thatPath.getLastSegment().getName())) {
                        return false;
                    }
                }
                if (this.hasIdProperties() && other.hasIdProperties()) {
                    return this.getIdProperties().containsAll(other.getIdProperties());
                }
                return true;
            }
            if (!other.hasIdProperties()) {
                return false;
            }
            return this.getIdProperties().containsAll(other.getIdProperties());
        }
        return false;
    }

    @Override
    public Iterator<Property> iterator() {
        return this.idProperties != null ? this.idProperties.iterator() : NO_ID_PROPERTIES_ITERATOR;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.path, this.idProperties});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location that = (Location)obj;
            if (this.hasPath() ? !this.getPath().equals(that.getPath()) : that.hasPath()) {
                return false;
            }
            return !(this.hasIdProperties() ? !((Object)this.getIdProperties()).equals(that.getIdProperties()) : that.hasIdProperties());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasPath()) {
            if (this.hasIdProperties()) {
                sb.append("[ ");
            }
            sb.append(this.getPath());
            if (this.hasIdProperties()) {
                sb.append(" && ");
            }
        }
        if (this.hasIdProperties()) {
            sb.append(this.getIdProperties().toString());
            if (this.hasPath()) {
                sb.append(" ]");
            }
        }
        return sb.toString();
    }

    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        return new Location(this, newIdProperty);
    }

    public Location with(Path newPath) {
        if (newPath == null) {
            return this;
        }
        if (!this.path.equals(newPath)) {
            return new Location(this, newPath);
        }
        return this;
    }
}

