/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.util.Iterator;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.properties.PropertyType;
import org.jboss.dna.graph.properties.ValueFactories;
import org.jboss.dna.graph.properties.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValueFactories
implements ValueFactories {
    @Override
    public Iterator<ValueFactory<?>> iterator() {
        return new ValueFactoryIterator();
    }

    @Override
    public ValueFactory<?> getValueFactory(PropertyType type) {
        CheckArg.isNotNull((Object)((Object)type), (String)"type");
        switch (type) {
            case BINARY: {
                return this.getBinaryFactory();
            }
            case BOOLEAN: {
                return this.getBooleanFactory();
            }
            case DATE: {
                return this.getDateFactory();
            }
            case DECIMAL: {
                return this.getDecimalFactory();
            }
            case DOUBLE: {
                return this.getDoubleFactory();
            }
            case LONG: {
                return this.getLongFactory();
            }
            case NAME: {
                return this.getNameFactory();
            }
            case PATH: {
                return this.getPathFactory();
            }
            case REFERENCE: {
                return this.getReferenceFactory();
            }
            case STRING: {
                return this.getStringFactory();
            }
            case URI: {
                return this.getUriFactory();
            }
            case UUID: {
                return this.getUuidFactory();
            }
            case OBJECT: {
                return this.getObjectFactory();
            }
        }
        return this.getObjectFactory();
    }

    @Override
    public ValueFactory<?> getValueFactory(Object prototype) {
        CheckArg.isNotNull((Object)prototype, (String)"prototype");
        PropertyType inferredType = PropertyType.discoverType(prototype);
        assert (inferredType != null);
        return this.getValueFactory(inferredType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueFactoryIterator
    implements Iterator<ValueFactory<?>> {
        private final Iterator<PropertyType> propertyTypeIter = PropertyType.iterator();

        protected ValueFactoryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.propertyTypeIter.hasNext();
        }

        @Override
        public ValueFactory<?> next() {
            PropertyType nextType = this.propertyTypeIter.next();
            return AbstractValueFactories.this.getValueFactory(nextType);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

