/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;

@Immutable
public class BasicName
implements Name {
    private static final long serialVersionUID = -1737537720336990144L;
    private final String namespaceUri;
    private final String localName;
    private final int hc;

    public BasicName(String namespaceUri, String localName) {
        CheckArg.isNotEmpty((String)localName, (String)"localName");
        this.namespaceUri = namespaceUri != null ? namespaceUri.trim() : "";
        this.localName = localName != null ? localName.trim() : "";
        this.hc = HashCode.compute((Object[])new Object[]{this.namespaceUri, this.localName});
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getString() {
        return this.getString(Path.DEFAULT_ENCODER);
    }

    public String getString(TextEncoder encoder) {
        if (this.getNamespaceUri().length() == 0) {
            if (this.getLocalName().equals(".")) {
                return ".";
            }
            if (this.getLocalName().equals("..")) {
                return "..";
            }
        }
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        return "{" + encoder.encode(this.namespaceUri) + "}" + encoder.encode(this.localName);
    }

    public String getString(NamespaceRegistry namespaceRegistry) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        String prefix = namespaceRegistry.getPrefixForNamespaceUri(this.namespaceUri, true);
        if (prefix != null && prefix.length() != 0) {
            return prefix + ":" + this.localName;
        }
        return this.localName;
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        String prefix = namespaceRegistry.getPrefixForNamespaceUri(this.namespaceUri, true);
        if (prefix != null && prefix.length() != 0) {
            return encoder.encode(prefix) + ":" + encoder.encode(this.localName);
        }
        return this.localName;
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        if (namespaceRegistry == null) {
            if (this.getNamespaceUri().length() == 0) {
                if (this.getLocalName().equals(".")) {
                    return ".";
                }
                if (this.getLocalName().equals("..")) {
                    return "..";
                }
            }
            if (encoder == null) {
                encoder = Path.DEFAULT_ENCODER;
            }
            if (delimiterEncoder != null) {
                return delimiterEncoder.encode("{") + encoder.encode(this.namespaceUri) + delimiterEncoder.encode("}") + encoder.encode(this.localName);
            }
            return "{" + encoder.encode(this.namespaceUri) + "}" + encoder.encode(this.localName);
        }
        String prefix = namespaceRegistry.getPrefixForNamespaceUri(this.namespaceUri, true);
        if (prefix != null && prefix.length() != 0) {
            String delim = delimiterEncoder != null ? delimiterEncoder.encode(":") : ":";
            return encoder.encode(prefix) + delim + encoder.encode(this.localName);
        }
        return this.localName;
    }

    public int compareTo(Name that) {
        if (that == this) {
            return 0;
        }
        int diff = this.getNamespaceUri().compareTo(that.getNamespaceUri());
        if (diff != 0) {
            return diff;
        }
        diff = this.getLocalName().compareTo(that.getLocalName());
        return diff;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Name) {
            Name that = (Name)obj;
            if (!this.getNamespaceUri().equals(that.getNamespaceUri())) {
                return false;
            }
            return this.getLocalName().equals(that.getLocalName());
        }
        return false;
    }

    public String toString() {
        return "{" + this.namespaceUri + "}" + this.localName;
    }
}

