/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.basic.BasicNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicNamespaceRegistry
implements NamespaceRegistry {
    public static final String DEFAULT_NAMESPACE_URI = "";
    public static final String DEFAULT_PREFIX_TEMPLATE = "ns##000";
    public static final String DEFAULT_PREFIX_NUMBER_FORMAT = "##000";
    private final ReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final Map<String, String> namespacesByPrefix = new HashMap<String, String>();
    private final Map<String, String> prefixesByNamespace = new HashMap<String, String>();
    private String generatedPrefixTemplate = "ns##000";
    private int nextGeneratedPrefixNumber = 1;

    public BasicNamespaceRegistry() {
        this(DEFAULT_NAMESPACE_URI);
    }

    public BasicNamespaceRegistry(String defaultNamespaceUri) {
        this.register(DEFAULT_NAMESPACE_URI, defaultNamespaceUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGeneratedPrefixTemplate() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            String string = this.generatedPrefixTemplate;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeneratedPrefixTemplate(String prefixTemplate) {
        if (prefixTemplate == null) {
            prefixTemplate = DEFAULT_PREFIX_TEMPLATE;
        }
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            this.generatedPrefixTemplate = prefixTemplate;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespaceForPrefix(String prefix) {
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            String string = this.namespacesByPrefix.get(prefix);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        String prefix = null;
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            prefix = this.prefixesByNamespace.get(namespaceUri);
        }
        finally {
            lock.unlock();
        }
        if (prefix == null && generateIfMissing) {
            lock = this.registryLock.writeLock();
            try {
                lock.lock();
                prefix = this.prefixesByNamespace.get(namespaceUri);
                if (prefix == null) {
                    prefix = this.generatePrefix();
                    this.register(prefix, namespaceUri);
                }
                String string = prefix;
                return string;
            }
            finally {
                lock.unlock();
            }
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            boolean bl = this.prefixesByNamespace.containsKey(namespaceUri);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultNamespaceUri() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            String string = this.namespacesByPrefix.get(DEFAULT_NAMESPACE_URI);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String register(String prefix, String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        String previousNamespaceForPrefix = null;
        namespaceUri = namespaceUri.trim();
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            if (prefix == null) {
                prefix = this.generatePrefix();
            }
            prefix = prefix.trim();
            prefix = prefix.replaceFirst("^:+", DEFAULT_NAMESPACE_URI);
            prefix = prefix.replaceFirst(":+$", DEFAULT_NAMESPACE_URI);
            previousNamespaceForPrefix = this.namespacesByPrefix.put(prefix, namespaceUri);
            String previousPrefix = this.prefixesByNamespace.put(namespaceUri, prefix);
            if (previousPrefix != null && !previousPrefix.equals(prefix)) {
                this.namespacesByPrefix.remove(previousPrefix);
            }
            if (previousNamespaceForPrefix != null && !previousNamespaceForPrefix.equals(namespaceUri)) {
                this.prefixesByNamespace.remove(previousNamespaceForPrefix);
            }
        }
        finally {
            lock.unlock();
        }
        return previousNamespaceForPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        namespaceUri = namespaceUri.trim();
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            String prefix = this.prefixesByNamespace.remove(namespaceUri);
            if (prefix == null) {
                boolean bl = false;
                return bl;
            }
            this.namespacesByPrefix.remove(prefix);
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredNamespaceUris() {
        HashSet<String> result = new HashSet<String>();
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            result.addAll(this.prefixesByNamespace.keySet());
        }
        finally {
            lock.unlock();
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        HashSet<BasicNamespace> result = new HashSet<BasicNamespace>();
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            for (Map.Entry<String, String> entry : this.namespacesByPrefix.entrySet()) {
                result.add(new BasicNamespace(entry.getKey(), entry.getValue()));
            }
        }
        finally {
            lock.unlock();
        }
        return Collections.unmodifiableSet(result);
    }

    @GuardedBy(value="registryLock")
    protected String generatePrefix() {
        DecimalFormat formatter = new DecimalFormat(this.generatedPrefixTemplate);
        return formatter.format(this.nextGeneratedPrefixNumber++);
    }
}

