/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.text.Inflector;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.InvalidPathException;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class BasicPath
implements Path {
    private static final long serialVersionUID = 8488295345524209746L;
    private static final List<Path.Segment> EMPTY_SEGMENTS = Collections.emptyList();
    public static final Path ROOT = new BasicPath(EMPTY_SEGMENTS, true);
    public static final Path EMPTY_RELATIVE = new BasicPath(EMPTY_SEGMENTS, false);
    public static final Path SELF_PATH = new BasicPath(Collections.singletonList(Path.SELF_SEGMENT), false);
    private final List<Path.Segment> segments;
    private final boolean absolute;
    private final boolean normalized;
    private transient String path;

    public BasicPath(List<Path.Segment> segments, boolean absolute) {
        CheckArg.isNotNull(segments, (String)"segments");
        this.segments = segments.isEmpty() ? EMPTY_SEGMENTS : Collections.unmodifiableList(segments);
        this.absolute = absolute;
        this.normalized = this.isNormalized(this.segments);
    }

    protected boolean isNormalized(List<Path.Segment> segments) {
        for (Path.Segment segment : segments) {
            if (!segment.isSelfReference() && !segment.isParentReference()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path getParent() {
        if (this.isRoot()) {
            return null;
        }
        if (this.segments.size() == 1) {
            return this.isAbsolute() ? ROOT : EMPTY_RELATIVE;
        }
        return this.subpath(0, this.segments.size() - 1);
    }

    @Override
    public Path getAncestor(int degree) {
        CheckArg.isNonNegative((int)degree, (String)"degree");
        if (degree == 0) {
            return this;
        }
        if (this.isRoot()) {
            return null;
        }
        int endIndex = this.segments.size() - degree;
        if (endIndex == 0) {
            return this.isAbsolute() ? ROOT : EMPTY_RELATIVE;
        }
        if (endIndex < 0) {
            String msg = GraphI18n.pathAncestorDegreeIsInvalid.text(new Object[]{this.getString(), Inflector.getInstance().ordinalize(degree)});
            throw new InvalidPathException(msg);
        }
        return this.subpath(0, endIndex);
    }

    @Override
    public Path getCanonicalPath() {
        if (!this.isAbsolute()) {
            String msg = GraphI18n.pathIsNotAbsolute.text(new Object[]{this});
            throw new InvalidPathException(msg);
        }
        if (this.isNormalized()) {
            return this;
        }
        return this.getNormalizedPath();
    }

    @Override
    public Path getCommonAncestor(Path that) {
        Path.Segment thatSeg;
        Path.Segment thisSeg;
        if (that == null) {
            return null;
        }
        if (this.isRoot() || that.isRoot()) {
            return ROOT;
        }
        Path normalizedPath = this.getNormalizedPath();
        int lastIndex = 0;
        Iterator<Path.Segment> thisIter = normalizedPath.iterator();
        Iterator<Path.Segment> thatIter = that.getNormalizedPath().iterator();
        while (thisIter.hasNext() && thatIter.hasNext() && (thisSeg = thisIter.next()).equals(thatSeg = thatIter.next())) {
            ++lastIndex;
        }
        if (lastIndex == 0) {
            return ROOT;
        }
        return normalizedPath.subpath(0, lastIndex);
    }

    @Override
    public Path.Segment getLastSegment() {
        if (this.isRoot()) {
            return null;
        }
        return this.segments.get(this.size() - 1);
    }

    @Override
    public Path getNormalizedPath() {
        if (this.isNormalized()) {
            return this;
        }
        LinkedList<Path.Segment> newSegments = new LinkedList<Path.Segment>();
        for (Path.Segment segment : this.segments) {
            if (segment.isSelfReference()) continue;
            if (segment.isParentReference()) {
                if (newSegments.isEmpty()) {
                    if (this.isAbsolute()) {
                        throw new InvalidPathException(CommonI18n.pathCannotBeNormalized.text(new Object[]{this}));
                    }
                } else if (!newSegments.getLast().isParentReference()) {
                    newSegments.removeLast();
                    continue;
                }
            }
            newSegments.add(segment);
        }
        if (newSegments.isEmpty()) {
            if (this.isAbsolute()) {
                return ROOT;
            }
            return SELF_PATH;
        }
        return new BasicPath(newSegments, this.isAbsolute());
    }

    @Override
    public Path.Segment getSegment(int index) {
        return this.segments.get(index);
    }

    @Override
    public Path.Segment[] getSegmentsArray() {
        return this.segments.toArray(new Path.Segment[this.segments.size()]);
    }

    @Override
    public List<Path.Segment> getSegmentsList() {
        return this.segments;
    }

    @Override
    public String getString() {
        return this.doGetString(null, DEFAULT_ENCODER, null);
    }

    @Override
    public String getString(TextEncoder encoder) {
        return this.doGetString(null, encoder, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return this.doGetString(namespaceRegistry, null, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return this.doGetString(namespaceRegistry, encoder, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        return this.doGetString(namespaceRegistry, encoder, delimiterEncoder);
    }

    protected String doGetString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        if (encoder == null) {
            encoder = DEFAULT_ENCODER;
        }
        if (encoder == DEFAULT_ENCODER && this.path != null && delimiterEncoder == null) {
            return this.path;
        }
        String delimiter = delimiterEncoder != null ? delimiterEncoder.encode(DELIMITER_STR) : DELIMITER_STR;
        StringBuilder sb = new StringBuilder();
        if (this.isAbsolute()) {
            sb.append(delimiter);
        }
        boolean first = true;
        for (Path.Segment segment : this.segments) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            assert (segment != null);
            sb.append(segment.getString(namespaceRegistry, encoder, delimiterEncoder));
        }
        String result = sb.toString();
        if (encoder == DEFAULT_ENCODER && this.path == null && delimiterEncoder == null) {
            this.path = result;
        }
        return result;
    }

    @Override
    public boolean hasSameAncestor(Path that) {
        if (that == null) {
            return false;
        }
        if (this.isRoot() && that.isRoot()) {
            return true;
        }
        if (that.size() != this.size()) {
            return false;
        }
        if (this.size() == 1) {
            return true;
        }
        for (int i = this.size() - 2; i >= 0; --i) {
            Path.Segment thatSegment;
            Path.Segment thisSegment = this.getSegment(i);
            if (thisSegment.equals(thatSegment = that.getSegment(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isAncestorOf(Path decendant) {
        if (decendant == null) {
            return false;
        }
        if (this == decendant) {
            return false;
        }
        if (this.size() >= decendant.size()) {
            return false;
        }
        Iterator<Path.Segment> thisIter = this.iterator();
        Iterator<Path.Segment> thatIter = decendant.iterator();
        while (thisIter.hasNext()) {
            Path.Segment thatSeg;
            Path.Segment thisSeg = thisIter.next();
            if (thisSeg.equals(thatSeg = thatIter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAtOrBelow(Path other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Iterator<Path.Segment> thisIter = this.segments.iterator();
        Iterator<Path.Segment> thatIter = other.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            if (thisIter.next().equals(thatIter.next())) continue;
            return false;
        }
        return !thatIter.hasNext();
    }

    @Override
    public boolean isAtOrAbove(Path other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Iterator<Path.Segment> thisIter = this.segments.iterator();
        Iterator<Path.Segment> thatIter = other.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            if (thisIter.next().equals(thatIter.next())) continue;
            return false;
        }
        return !thisIter.hasNext();
    }

    @Override
    public boolean isDecendantOf(Path ancestor) {
        if (ancestor == null) {
            return false;
        }
        return ancestor.isAncestorOf(this);
    }

    @Override
    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public boolean isRoot() {
        return this == ROOT || this.segments.isEmpty();
    }

    @Override
    public boolean isSameAs(Path other) {
        return other != null && this.compareTo(other) == 0;
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return this.segments.iterator();
    }

    @Override
    public Path relativeTo(Path startingPath) {
        int i;
        Path.Segment toSeg;
        Path.Segment thisSeg;
        CheckArg.isNotNull((Object)startingPath, (String)"to");
        if (!this.isAbsolute()) {
            String msg = GraphI18n.pathIsNotAbsolute.text(new Object[]{this});
            throw new InvalidPathException(msg);
        }
        if (!startingPath.isAbsolute()) {
            String msg = GraphI18n.pathIsNotAbsolute.text(new Object[]{startingPath});
            throw new InvalidPathException(msg);
        }
        int lengthOfCommonAncestor = 0;
        Iterator<Path.Segment> thisIter = this.getNormalizedPath().iterator();
        Iterator<Path.Segment> toIter = startingPath.getNormalizedPath().iterator();
        while (thisIter.hasNext() && toIter.hasNext() && (thisSeg = thisIter.next()).equals(toSeg = toIter.next())) {
            ++lengthOfCommonAncestor;
        }
        int numberOfParentReferences = startingPath.size() - lengthOfCommonAncestor;
        ArrayList<Path.Segment> relativeSegments = new ArrayList<Path.Segment>();
        for (i = 0; i != numberOfParentReferences; ++i) {
            relativeSegments.add(Path.PARENT_SEGMENT);
        }
        for (i = lengthOfCommonAncestor; i < this.size(); ++i) {
            relativeSegments.add(this.segments.get(i));
        }
        if (relativeSegments.isEmpty()) {
            relativeSegments.add(Path.SELF_SEGMENT);
        }
        return new BasicPath(relativeSegments, false);
    }

    @Override
    public Path resolve(Path relativePath) {
        CheckArg.isNotNull((Object)relativePath, (String)"relative path");
        if (!this.isAbsolute()) {
            String msg = GraphI18n.pathIsAlreadyAbsolute.text(new Object[]{this.path});
            throw new InvalidPathException(msg);
        }
        if (relativePath.isAbsolute()) {
            String msg = GraphI18n.pathIsNotRelative.text(new Object[]{relativePath});
            throw new InvalidPathException(msg);
        }
        if ((relativePath = relativePath.getNormalizedPath()).size() == 1) {
            Path.Segment onlySegment = relativePath.getSegment(0);
            if (onlySegment.isSelfReference()) {
                return this;
            }
            if (onlySegment.isParentReference()) {
                return this.getParent();
            }
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(this.size() + relativePath.size());
        segments.addAll(this.segments);
        segments.addAll(relativePath.getSegmentsList());
        return new BasicPath(segments, true).getNormalizedPath();
    }

    @Override
    public Path resolveAgainst(Path absolutePath) {
        CheckArg.isNotNull((Object)absolutePath, (String)"absolute path");
        return absolutePath.resolve(this);
    }

    @Override
    public int size() {
        return this.segments.size();
    }

    @Override
    public Path subpath(int beginIndex) {
        if (beginIndex == 0) {
            return this;
        }
        int size = this.size();
        if (beginIndex >= size) {
            throw new IndexOutOfBoundsException(GraphI18n.unableToCreateSubpathBeginIndexGreaterThanOrEqualToSize.text(new Object[]{beginIndex, size}));
        }
        if (size == 0) {
            return ROOT;
        }
        return new BasicPath(this.segments.subList(beginIndex, size), this.isAbsolute());
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        int size = this.size();
        if (beginIndex == 0) {
            if (endIndex == 0) {
                return ROOT;
            }
            if (endIndex == size) {
                return this;
            }
        }
        if (beginIndex >= size) {
            throw new IndexOutOfBoundsException(GraphI18n.unableToCreateSubpathBeginIndexGreaterThanOrEqualToSize.text(new Object[]{beginIndex, size}));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(GraphI18n.unableToCreateSubpathBeginIndexGreaterThanOrEqualToEndingIndex.text(new Object[]{beginIndex, endIndex}));
        }
        return new BasicPath(this.segments.subList(beginIndex, endIndex), this.isAbsolute());
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path that = (Path)obj;
            return ((Object)this.segments).equals(that.getSegmentsList());
        }
        return false;
    }

    @Override
    public int compareTo(Path that) {
        if (this == that) {
            return 0;
        }
        Iterator<Path.Segment> thisIter = this.segments.iterator();
        Iterator<Path.Segment> thatIter = that.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            Path.Segment thatSegment;
            Path.Segment thisSegment = thisIter.next();
            int diff = thisSegment.compareTo(thatSegment = thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        if (thisIter.hasNext()) {
            return 1;
        }
        if (thatIter.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.getString(Path.URL_ENCODER);
    }
}

