/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.ValueComparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public abstract class BasicProperty
implements Property {
    private final Name name;

    public BasicProperty(Name name) {
        this.name = name;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Iterator<?> getValues() {
        return this.iterator();
    }

    @Override
    public Object[] getValuesAsArray() {
        if (this.size() == 0) {
            return null;
        }
        Object[] results = new Object[this.size()];
        Iterator iter = this.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            results[index++] = value;
        }
        return results;
    }

    @Override
    public int compareTo(Property o) {
        return 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Property) {
            Property that = (Property)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            Iterator thisIter = this.iterator();
            Iterator thatIter = that.iterator();
            while (thisIter.hasNext()) {
                Object thatValue;
                Object thisValue = thisIter.next();
                if (ValueComparators.OBJECT_COMPARATOR.compare(thisValue, thatValue = thatIter.next()) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" = ");
        if (this.isSingle()) {
            sb.append(this.getValues().next());
        } else {
            sb.append(Arrays.asList(this.getValuesAsArray()));
        }
        return sb.toString();
    }
}

