/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.Base64;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.ValueComparators;

@Immutable
public class InMemoryBinary
implements Binary {
    protected static final Set<String> ALGORITHMS_NOT_FOUND_AND_LOGGED = new CopyOnWriteArraySet<String>();
    private static final String SHA1DIGEST_NAME = "SHA-1";
    private static final byte[] NO_HASH = new byte[0];
    private static final long serialVersionUID = 8792863149767123559L;
    protected static final byte[] EMPTY_CONTENT = new byte[0];
    private final byte[] bytes;
    private byte[] sha1hash;

    public InMemoryBinary(byte[] bytes) {
        CheckArg.isNotNull((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    public long getSize() {
        return this.bytes.length;
    }

    public byte[] getHash() {
        if (this.sha1hash == null) {
            try {
                this.sha1hash = this.getHash(SHA1DIGEST_NAME);
            }
            catch (NoSuchAlgorithmException e) {
                if (ALGORITHMS_NOT_FOUND_AND_LOGGED.add(SHA1DIGEST_NAME)) {
                    Logger.getLogger(this.getClass()).error((Throwable)e, GraphI18n.messageDigestNotFound, new Object[]{SHA1DIGEST_NAME});
                }
                this.sha1hash = NO_HASH;
            }
        }
        return this.sha1hash;
    }

    protected byte[] getHash(String digestName) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(digestName);
        assert (digest != null);
        return digest.digest(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void acquire() {
    }

    public void release() {
    }

    public int compareTo(Binary o) {
        return ValueComparators.BINARY_COMPARATOR.compare(this, o);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Binary) {
            Binary that = (Binary)obj;
            if (this.getSize() != that.getSize()) {
                return false;
            }
            return ValueComparators.BINARY_COMPARATOR.compare(this, that) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" len=").append(this.getSize()).append("; [");
        sb.append(Base64.encodeBytes((byte[])this.bytes));
        return sb.toString();
    }
}

