/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.properties.DateTime;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

@Immutable
public class JodaDateTime
implements DateTime {
    private static final long serialVersionUID = -730188225988292422L;
    private static final int MILLIS_IN_HOUR = 3600000;
    private final org.joda.time.DateTime instance;

    public JodaDateTime() {
        this.instance = new org.joda.time.DateTime();
    }

    public JodaDateTime(String iso8601) {
        this.instance = new org.joda.time.DateTime((Object)iso8601);
    }

    public JodaDateTime(String iso8601, String timeZoneId) {
        this.instance = new org.joda.time.DateTime((Object)iso8601, DateTimeZone.forID((String)timeZoneId));
    }

    public JodaDateTime(long milliseconds) {
        this.instance = new org.joda.time.DateTime(milliseconds);
    }

    public JodaDateTime(long milliseconds, Chronology chronology) {
        this.instance = new org.joda.time.DateTime(milliseconds, chronology);
    }

    public JodaDateTime(long milliseconds, String timeZoneId) {
        this.instance = new org.joda.time.DateTime(milliseconds, DateTimeZone.forID((String)timeZoneId));
    }

    public JodaDateTime(DateTimeZone dateTimeZone) {
        this.instance = new org.joda.time.DateTime(dateTimeZone);
    }

    public JodaDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond) {
        this.instance = new org.joda.time.DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond);
    }

    public JodaDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, Chronology chronology) {
        this.instance = new org.joda.time.DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, chronology);
    }

    public JodaDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, DateTimeZone dateTimeZone) {
        this.instance = new org.joda.time.DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, dateTimeZone);
    }

    public JodaDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, int timeZoneOffsetHours) {
        this.instance = new org.joda.time.DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, DateTimeZone.forOffsetHours((int)timeZoneOffsetHours));
    }

    public JodaDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, String timeZoneId) {
        this.instance = new org.joda.time.DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, DateTimeZone.forID((String)timeZoneId));
    }

    public JodaDateTime(Date jdkDate) {
        this.instance = new org.joda.time.DateTime((Object)jdkDate);
    }

    public JodaDateTime(Calendar jdkCalendar) {
        this.instance = new org.joda.time.DateTime((Object)jdkCalendar);
    }

    public JodaDateTime(org.joda.time.DateTime dateTime) {
        this.instance = dateTime;
    }

    public int getCenturyOfEra() {
        return this.instance.getCenturyOfEra();
    }

    public int getDayOfMonth() {
        return this.instance.getDayOfMonth();
    }

    public int getDayOfWeek() {
        return this.instance.getDayOfWeek();
    }

    public int getDayOfYear() {
        return this.instance.getDayOfYear();
    }

    public int getEra() {
        return this.instance.getEra();
    }

    public int getHourOfDay() {
        return this.instance.getHourOfDay();
    }

    public int getMillisOfSecond() {
        return this.instance.getMillisOfSecond();
    }

    public long getMilliseconds() {
        return this.instance.getMillis();
    }

    public int getMinuteOfHour() {
        return this.instance.getMinuteOfHour();
    }

    public int getMonthOfYear() {
        return this.instance.getMonthOfYear();
    }

    public int getSecondOfMinute() {
        return this.instance.getSecondOfMinute();
    }

    public String getString() {
        return this.instance.toString(ISODateTimeFormat.dateTime());
    }

    public int getWeekOfWeekyear() {
        return this.instance.getWeekOfWeekyear();
    }

    public int getWeekyear() {
        return this.instance.getWeekyear();
    }

    public int getYear() {
        return this.instance.getYear();
    }

    public int getYearOfCentury() {
        return this.instance.getYearOfCentury();
    }

    public int getYearOfEra() {
        return this.instance.getYearOfEra();
    }

    public int getTimeZoneOffsetHours() {
        return this.instance.getZone().getOffset(this.instance.getMillis()) / 3600000;
    }

    public String getTimeZoneId() {
        return this.instance.getZone().getID();
    }

    public Calendar toCalendar() {
        return this.toCalendar(null);
    }

    public Calendar toCalendar(Locale locale) {
        return this.instance.toCalendar(locale);
    }

    public Date toDate() {
        return this.instance.toDate();
    }

    public GregorianCalendar toGregorianCalendar() {
        return this.instance.toGregorianCalendar();
    }

    public int compareTo(DateTime that) {
        if (that instanceof JodaDateTime) {
            return this.instance.compareTo((Object)((JodaDateTime)that).instance);
        }
        long diff = this.toUtcTimeZone().getMilliseconds() - that.toUtcTimeZone().getMilliseconds();
        return (int)diff;
    }

    public int hashCode() {
        return this.instance.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JodaDateTime) {
            JodaDateTime that = (JodaDateTime)obj;
            return this.instance.equals((Object)that.instance);
        }
        if (obj instanceof org.joda.time.DateTime) {
            return this.instance.equals(obj);
        }
        return false;
    }

    public String toString() {
        return this.getString();
    }

    public DateTime toUtcTimeZone() {
        org.joda.time.DateTime jodaTime = this.instance.withZone(DateTimeZone.forID((String)"UTC"));
        return new JodaDateTime(jodaTime);
    }

    public DateTime toTimeZone(String timeZoneId) {
        CheckArg.isNotNull((Object)timeZoneId, (String)"time zone identifier");
        org.joda.time.DateTime jodaTime = this.instance.withZone(DateTimeZone.forID((String)timeZoneId));
        return new JodaDateTime(jodaTime);
    }

    public boolean isBefore(DateTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean isSameAs(DateTime other) {
        return this.compareTo(other) == 0;
    }

    public boolean isAfter(DateTime other) {
        return this.compareTo(other) > 0;
    }

    public DateTime minus(long timeAmount, TimeUnit unit) {
        CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
        return new JodaDateTime(this.instance.minus(TimeUnit.MILLISECONDS.convert(timeAmount, unit)));
    }

    public DateTime minusDays(int days) {
        return new JodaDateTime(this.instance.minusDays(days));
    }

    public DateTime minusHours(int hours) {
        return new JodaDateTime(this.instance.minusHours(hours));
    }

    public DateTime minusMillis(int milliseconds) {
        return new JodaDateTime(this.instance.minusMillis(milliseconds));
    }

    public DateTime minusMinutes(int minutes) {
        return new JodaDateTime(this.instance.minusMinutes(minutes));
    }

    public DateTime minusMonths(int months) {
        return new JodaDateTime(this.instance.minusMonths(months));
    }

    public DateTime minusSeconds(int seconds) {
        return new JodaDateTime(this.instance.minusSeconds(seconds));
    }

    public DateTime minusWeeks(int weeks) {
        return new JodaDateTime(this.instance.minusWeeks(weeks));
    }

    public DateTime minusYears(int years) {
        return new JodaDateTime(this.instance.minusYears(years));
    }

    public DateTime plus(long timeAmount, TimeUnit unit) {
        CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
        return new JodaDateTime(this.instance.plus(TimeUnit.MILLISECONDS.convert(timeAmount, unit)));
    }

    public DateTime plusDays(int days) {
        return new JodaDateTime(this.instance.plusDays(days));
    }

    public DateTime plusHours(int hours) {
        return new JodaDateTime(this.instance.plusHours(hours));
    }

    public DateTime plusMillis(int milliseconds) {
        return new JodaDateTime(this.instance.plusMillis(milliseconds));
    }

    public DateTime plusMinutes(int minutes) {
        return new JodaDateTime(this.instance.plusMinutes(minutes));
    }

    public DateTime plusMonths(int months) {
        return new JodaDateTime(this.instance.plusMonths(months));
    }

    public DateTime plusSeconds(int seconds) {
        return new JodaDateTime(this.instance.plusSeconds(seconds));
    }

    public DateTime plusWeeks(int weeks) {
        return new JodaDateTime(this.instance.plusWeeks(weeks));
    }

    public DateTime plusYears(int years) {
        return new JodaDateTime(this.instance.plusYears(years));
    }
}

