/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.IoException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PropertyType;
import org.jboss.dna.graph.properties.Reference;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.graph.properties.ValueFormatException;
import org.jboss.dna.graph.properties.basic.AbstractValueFactory;
import org.jboss.dna.graph.properties.basic.JodaDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class StringValueFactory
extends AbstractValueFactory<String> {
    private final TextEncoder encoder;

    public StringValueFactory(TextDecoder decoder, TextEncoder encoder) {
        super(PropertyType.STRING, decoder, null);
        CheckArg.isNotNull((Object)encoder, (String)"encoder");
        this.encoder = encoder;
    }

    public TextEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    protected ValueFactory<String> getStringValueFactory() {
        return this;
    }

    @Override
    public String create(String value) {
        return value;
    }

    @Override
    public String create(String value, TextDecoder decoder) {
        if (value == null) {
            return value;
        }
        if (decoder == null) {
            decoder = this.getDecoder();
        }
        return decoder.decode(value);
    }

    @Override
    public String create(int value) {
        return Integer.toString(value);
    }

    @Override
    public String create(long value) {
        return Long.toString(value);
    }

    @Override
    public String create(boolean value) {
        return Boolean.toString(value);
    }

    @Override
    public String create(float value) {
        return Float.toString(value);
    }

    @Override
    public String create(double value) {
        return Double.toString(value);
    }

    @Override
    public String create(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String create(Calendar value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value).getString();
    }

    @Override
    public String create(Date value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value).getString();
    }

    @Override
    public String create(DateTime value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    @Override
    public String create(Name value) {
        if (value == null) {
            return null;
        }
        return value.getString(this.getEncoder());
    }

    @Override
    public String create(Path value) {
        if (value == null) {
            return null;
        }
        return value.getString(this.getEncoder());
    }

    @Override
    public String create(Reference value) {
        if (value == null) {
            return null;
        }
        return value.getString(this.getEncoder());
    }

    @Override
    public String create(URI value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String create(UUID value) throws IoException {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String create(byte[] value) {
        if (value == null) {
            return null;
        }
        try {
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{byte[].class.getSimpleName(), String.class.getSimpleName(), value}), err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String create(Binary value) throws ValueFormatException, IoException {
        if (value == null) {
            return null;
        }
        try {
            String string;
            value.acquire();
            InputStream stream = value.getStream();
            try {
                string = this.create(stream, value.getSize());
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass()).debug((Throwable)e, "Error closing the stream while converting from Binary to String", new Object[0]);
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass()).debug((Throwable)e, "Error closing the stream while converting from Binary to String", new Object[0]);
            }
            return string;
        }
        finally {
            value.release();
        }
    }

    @Override
    public String create(InputStream stream, long approximateLength) throws IoException {
        if (stream == null) {
            return null;
        }
        byte[] value = null;
        try {
            value = IoUtil.readBytes((InputStream)stream);
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{InputStream.class.getSimpleName(), String.class.getSimpleName(), value}), err);
        }
        catch (IOException err) {
            throw new IoException(GraphI18n.errorConvertingIo.text(new Object[]{InputStream.class.getSimpleName(), String.class.getSimpleName()}), err);
        }
    }

    @Override
    public String create(Reader reader, long approximateLength) throws IoException {
        if (reader == null) {
            return null;
        }
        try {
            return IoUtil.read((Reader)reader);
        }
        catch (IOException err) {
            throw new IoException(GraphI18n.errorConvertingIo.text(new Object[]{Reader.class.getSimpleName(), String.class.getSimpleName()}), err);
        }
    }

    protected String[] createEmptyArray(int length) {
        return new String[length];
    }
}

