/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.requests.Request;

public class CopyBranchRequest
extends Request {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location from;
    private final Location into;
    private final NodeConflictBehavior conflictBehavior;
    private Location actualOldLocation;
    private Location actualNewLocation;

    public CopyBranchRequest(Location from, Location into) {
        this(from, into, DEFAULT_CONFLICT_BEHAVIOR);
    }

    public CopyBranchRequest(Location from, Location into, NodeConflictBehavior conflictBehavior) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull((Object)into, (String)"into");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        this.from = from;
        this.into = into;
        this.conflictBehavior = conflictBehavior;
    }

    public Location from() {
        return this.from;
    }

    public Location into() {
        return this.into;
    }

    public boolean isReadOnly() {
        return false;
    }

    public NodeConflictBehavior conflictBehavior() {
        return this.conflictBehavior;
    }

    public void setActualLocations(Location oldLocation, Location newLocation) {
        if (!this.from.isSame(oldLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{oldLocation, this.from}));
        }
        if (!this.into.isSame(newLocation, false)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{newLocation, this.into}));
        }
        assert (oldLocation != null);
        assert (newLocation != null);
        if (!oldLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{oldLocation}));
        }
        if (!newLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{newLocation}));
        }
        this.actualNewLocation = newLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualOldLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualNewLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            CopyBranchRequest that = (CopyBranchRequest)obj;
            if (!this.from().equals(that.from())) {
                return false;
            }
            if (!this.into().equals(that.into())) {
                return false;
            }
            return this.conflictBehavior().equals((Object)that.conflictBehavior());
        }
        return false;
    }

    public String toString() {
        return "copy branch " + this.from() + " into " + this.into();
    }
}

