/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNodeRequest
extends Request
implements Iterable<Property> {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location at;
    private final List<Property> properties;
    private final NodeConflictBehavior conflictBehavior;
    private Location actualLocation;

    public CreateNodeRequest(Location at, Property ... properties) {
        this(at, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location at, Iterable<Property> properties) {
        this(at, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location at, Iterator<Property> properties) {
        this(at, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location at, NodeConflictBehavior conflictBehavior, Property ... properties) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        this.at = at;
        this.conflictBehavior = conflictBehavior;
        int number = properties.length + (at.hasIdProperties() ? at.getIdProperties().size() : 0);
        ArrayList<Property> props = new ArrayList<Property>(number);
        for (Property property : properties) {
            if (property == null) continue;
            props.add(property);
        }
        if (at.hasIdProperties()) {
            for (Property property : at.getIdProperties()) {
                if (property == null) continue;
                props.add(property);
            }
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public CreateNodeRequest(Location at, NodeConflictBehavior conflictBehavior, Iterable<Property> properties) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        this.at = at;
        this.conflictBehavior = conflictBehavior;
        LinkedList<Property> props = new LinkedList<Property>();
        for (Property property : properties) {
            if (property == null) continue;
            props.add(property);
        }
        if (at.hasIdProperties()) {
            for (Property property : at.getIdProperties()) {
                if (property == null) continue;
                props.add(property);
            }
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public CreateNodeRequest(Location at, NodeConflictBehavior conflictBehavior, Iterator<Property> properties) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        this.at = at;
        this.conflictBehavior = conflictBehavior;
        LinkedList<Property> props = new LinkedList<Property>();
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property == null) continue;
            props.add(property);
        }
        if (at.hasIdProperties()) {
            for (Property property : at.getIdProperties()) {
                if (property == null) continue;
                props.add(property);
            }
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public Location at() {
        return this.at;
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.iterator();
    }

    public Collection<Property> properties() {
        return this.properties;
    }

    public NodeConflictBehavior conflictBehavior() {
        return this.conflictBehavior;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.at.isSame(actual, false)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.at}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            CreateNodeRequest that = (CreateNodeRequest)obj;
            if (!this.at().equals(that.at())) {
                return false;
            }
            if (!this.conflictBehavior().equals((Object)that.conflictBehavior())) {
                return false;
            }
            return ((Object)this.properties()).equals(that.properties());
        }
        return false;
    }

    public String toString() {
        return "create node at " + this.at() + " with properties " + this.properties();
    }
}

