/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.requests.Request;

public class DeleteBranchRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private Location actualLocation;

    public DeleteBranchRequest(Location at) {
        CheckArg.isNotNull((Object)at, (String)"at");
        this.at = at;
    }

    public Location at() {
        return this.at;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.at.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.at}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            DeleteBranchRequest that = (DeleteBranchRequest)obj;
            return this.at().equals(that.at());
        }
        return false;
    }

    public String toString() {
        return "delete branch " + this.at();
    }
}

