/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.CacheableRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadAllChildrenRequest
extends CacheableRequest
implements Iterable<Location> {
    private static final long serialVersionUID = 1L;
    private final Location of;
    private final List<Location> children = new LinkedList<Location>();
    private Location actualOf;

    public ReadAllChildrenRequest(Location of) {
        CheckArg.isNotNull((Object)of, (String)"of");
        this.of = of;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location of() {
        return this.of;
    }

    public List<Location> getChildren() {
        return this.children;
    }

    @Override
    public Iterator<Location> iterator() {
        return this.children.iterator();
    }

    public void addChild(Location child) {
        CheckArg.isNotNull((Object)child, (String)"child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        Location child = new Location(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        Location child = new Location(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.of.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.of}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualOf = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualOf;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            ReadAllChildrenRequest that = (ReadAllChildrenRequest)obj;
            return this.of().equals(that.of());
        }
        return false;
    }

    public String toString() {
        return "read children of " + this.of();
    }
}

