/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.text.Inflector;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.CacheableRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadBlockOfChildrenRequest
extends CacheableRequest {
    public static final int INDEX_NOT_USED = -1;
    private static final long serialVersionUID = 1L;
    private final Location of;
    private final List<Location> children = new LinkedList<Location>();
    private final int startingAtIndex;
    private final int count;
    private Location actualLocation;

    public ReadBlockOfChildrenRequest(Location of, int startingIndex, int count) {
        CheckArg.isNotNull((Object)of, (String)"of");
        CheckArg.isNonNegative((int)startingIndex, (String)"startingIndex");
        CheckArg.isPositive((int)count, (String)"count");
        this.of = of;
        this.startingAtIndex = startingIndex;
        this.count = count;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location of() {
        return this.of;
    }

    public int count() {
        return this.count;
    }

    public int startingAtIndex() {
        return this.startingAtIndex;
    }

    public int endingBefore() {
        return this.startingAtIndex + this.count;
    }

    public List<Location> getChildren() {
        return this.children;
    }

    public void addChild(Location child) {
        CheckArg.isNotNull((Object)child, (String)"child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        Location child = new Location(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        Location child = new Location(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.of.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.of}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            ReadBlockOfChildrenRequest that = (ReadBlockOfChildrenRequest)obj;
            if (!this.of().equals(that.of())) {
                return false;
            }
            if (this.startingAtIndex() != that.startingAtIndex()) {
                return false;
            }
            return this.count() == that.count();
        }
        return false;
    }

    public String toString() {
        Inflector inflector = Inflector.getInstance();
        if (this.count() == 1) {
            return "read " + inflector.ordinalize(this.startingAtIndex()) + " thru " + inflector.ordinalize(this.endingBefore() - 1) + " children of " + this.of();
        }
        return "read " + inflector.ordinalize(this.startingAtIndex()) + " child of " + this.of();
    }
}

